/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

public interface PssReleaseOrderRepository
extends JpaRepository<PssReleaseOrder, Long>,
JpaSpecificationExecutor<PssReleaseOrder> {
    public static final Splitter SEARCH_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();

    @Nonnull
    public static Specification<PssReleaseOrder> quotationNumberIn(@NonNull Collection<String> quotationNumbers) {
        if (quotationNumbers == null) {
            throw new NullPointerException("quotationNumbers is marked non-null but is null");
        }
        return (Specification & Serializable)(item, cq, cb) -> item.get("quotationNumber").in(quotationNumbers);
    }

    @Nonnull
    public static Specification<PssReleaseOrder> textMatches(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return (Specification & Serializable)(item, cq, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            ImmutableList terms = ImmutableList.copyOf(SEARCH_SPLITTER.split((CharSequence)text).iterator());
            for (String term : terms) {
                String lowerTerm = StringUtils.lowerCase((String)term);
                predicates.add(cb.or(new Predicate[]{cb.like(cb.lower((Expression)item.get("projectNumber")), "%" + lowerTerm + "%"), cb.like(cb.lower((Expression)item.get("releaseOrderNumber")), "%" + lowerTerm + "%"), cb.like(cb.lower((Expression)item.get("place")), "%" + lowerTerm + "%")}));
            }
            return cb.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Nonnull
    public static Specification<PssReleaseOrder> pssIdMatches(@NonNull Long pssIdCandidate) {
        if (pssIdCandidate == null) {
            throw new NullPointerException("pssIdCandidate is marked non-null but is null");
        }
        return (Specification & Serializable)(item, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)item.get("pssId"), (Object)pssIdCandidate)});
    }

    @Nonnull
    public Optional<PssReleaseOrder> findByPssId(@NonNull Long var1);

    @Nonnull
    public Optional<PssReleaseOrder> findByReferenceId(@NonNull String var1);

    @Query(value="select p from PssReleaseOrder p where p.quotationNumber = ?1 order by p.pssId asc ")
    public Page<PssReleaseOrder> search(@NonNull String var1, @NonNull Pageable var2);
}

