/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.internal.payroll.EPayrollItemClazzFilterOption;
import de.qfm.erp.service.model.internal.payroll.EPayrollItemFilterOption;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.PayrollMonthItemRepository;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface PayrollMonthItemRepository
extends JpaRepository<PayrollMonthItem, Long>,
JpaSpecificationExecutor<PayrollMonthItem> {
    @Nonnull
    public static Specification<PayrollMonthItem> filter(@NonNull YearMonth accountingMonth, @NonNull Collection<User> senders, @NonNull Collection<User> recipients, @NonNull EPayrollItemFilterOption payrollItemFilterOption, @NonNull EPayrollItemClazzFilterOption payrollItemClazzFilterOption) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (senders == null) {
            throw new NullPointerException("senders is marked non-null but is null");
        }
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (payrollItemFilterOption == null) {
            throw new NullPointerException("payrollItemFilterOption is marked non-null but is null");
        }
        if (payrollItemClazzFilterOption == null) {
            throw new NullPointerException("payrollItemClazzFilterOption is marked non-null but is null");
        }
        return (Specification & Serializable)(root, cq, cb) -> {
            Join senderProd = root.join("sender", JoinType.LEFT);
            Join recipientProd = root.join("recipient", JoinType.LEFT);
            Join payrollMonthProd = root.join("payrollMonth", JoinType.LEFT);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            ImmutableSet payrollItemClasses = switch (1.$SwitchMap$de$qfm$erp$service$model$internal$payroll$EPayrollItemClazzFilterOption[payrollItemClazzFilterOption.ordinal()]) {
                case 1 -> ImmutableSet.of((Object)EPayrollItemClazz.AUXILIARY_WAGE);
                case 2 -> ImmutableSet.of((Object)EPayrollItemClazz.INCENTIVE_PAYMENT);
                default -> ImmutableSet.copyOf((Object[])EPayrollItemClazz.values());
            };
            if (!payrollItemClasses.isEmpty()) {
                predicates.add(root.get("payrollItemClazz").in((Collection)payrollItemClasses));
            }
            if (!Iterables.isEmpty((Iterable)senders) || !Iterables.isEmpty((Iterable)recipients)) {
                Predicate senderIn = senderProd.in(senders);
                Predicate recipientIn = recipientProd.in(recipients);
                switch (1.$SwitchMap$de$qfm$erp$service$model$internal$payroll$EPayrollItemFilterOption[payrollItemFilterOption.ordinal()]) {
                    case 1: {
                        predicates.add(senderIn);
                        break;
                    }
                    case 2: {
                        predicates.add(recipientIn);
                        break;
                    }
                    case 3: {
                        predicates.add(cb.or((Expression)senderIn, (Expression)recipientIn));
                        break;
                    }
                    case 4: 
                    case 5: {
                        predicates.add(cb.and((Expression)senderIn, (Expression)recipientIn));
                        break;
                    }
                    case 6: {
                        predicates.add(cb.and((Expression)senderIn, (Expression)recipientIn.not()));
                        break;
                    }
                    case 7: {
                        predicates.add(cb.and((Expression)senderIn.not(), (Expression)recipientIn));
                    }
                }
            }
            LocalDate referenceDate = accountingMonth.atDay(1);
            predicates.add(cb.equal((Expression)payrollMonthProd.get("accountingMonth"), (Object)referenceDate));
            return cb.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Nonnull
    public Optional<PayrollMonthItem> findByReferenceId(@NonNull String var1);

    @Nonnull
    @Query(value="select pmi from PayrollMonthItem pmi join pmi.payrollMonth pm where  pmi.payrollItemClazz = :payrollItemClazz  AND pm.accountingMonth = :accountingMonth  AND pmi.recipient = :recipient  order by pmi.id")
    public Iterable<PayrollMonthItem> wagesAssignedToPayroll(@Param(value="payrollItemClazz") @NonNull EPayrollItemClazz var1, @Param(value="accountingMonth") @NonNull LocalDate var2, @Param(value="recipient") @NonNull User var3);

    @Nonnull
    @Query(value="select pmi from PayrollMonthItem pmi  join pmi.payrollMonth pm  join pmi.payrollItemType pit1  join pit1.sbsValuePayrollItemType pit2 where  pmi.payrollItemClazz = :payrollItemClazz  AND pm.accountingMonth = :accountingMonth  AND pm.user = :user  AND (pit1.wageType = 'INCENTIVE_WAGE' OR pit2.wageType = 'INCENTIVE_WAGE' )  order by pmi.id")
    public Iterable<PayrollMonthItem> routedWagesAssignedToPayroll(@Param(value="payrollItemClazz") @NonNull EPayrollItemClazz var1, @Param(value="accountingMonth") @NonNull LocalDate var2, @Param(value="user") @NonNull User var3);

    @Modifying
    @Query(value="update PayrollMonthItem pmi  set   pmi.quotation = :targetStage,  pmi.quotationNumber = :targetStageQuotationNumber where  pmi.quotation = :sourceStage")
    public int patchStage(@Param(value="sourceStage") @NonNull Quotation var1, @Param(value="targetStage") @NonNull Quotation var2, @Param(value="targetStageQuotationNumber") @NonNull String var3);

    @Nonnull
    public Iterable<PayrollMonthItem> findAllByQuotation(@NonNull Quotation var1);

    @Nonnull
    @Query(value="SELECT   distinct pmi.quotationNumber FROM   PayrollMonthItem pmi join pmi.payrollMonth pm WHERE   pmi.sender = :assignedUser    AND pm.accountingMonth > :referenceDate    AND NOT exists ( select q from Quotation q where q.flagOrderEnd = true AND q.quotationNumber = pmi.quotationNumber )ORDER BY pmi.quotationNumber")
    public List<String> quotationNumbersFromPaymentsForSenderBesideMeasurement(@Param(value="assignedUser") @NonNull User var1, @Param(value="referenceDate") @NonNull LocalDate var2);
}

