/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.qfm.erp.service.model.internal.payroll.PayrollItemTypeFilter;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

public interface PayrollItemTypeRepository
extends JpaRepository<PayrollItemType, Long>,
JpaSpecificationExecutor<PayrollItemType> {
    @Nonnull
    public static Specification<PayrollItemType> filter(@NonNull PayrollItemTypeFilter payrollItemTypeFilter) {
        if (payrollItemTypeFilter == null) {
            throw new NullPointerException("payrollItemTypeFilter is marked non-null but is null");
        }
        return (Specification & Serializable)(root, cq, builder) -> {
            boolean all = payrollItemTypeFilter.isAll();
            Iterable laborUnionContracts = payrollItemTypeFilter.getLaborUnionContracts();
            ArrayList predicates = Lists.newArrayList();
            if (!all) {
                predicates.add(builder.equal((Expression)root.get("flagVisibleInSelection"), (Object)true));
            }
            if (!Iterables.isEmpty((Iterable)laborUnionContracts)) {
                predicates.add(builder.or((Expression)builder.in((Expression)root.get("laborUnionContract")).value((Object)laborUnionContracts), (Expression)builder.isNull((Expression)root.get("laborUnionContract"))));
            }
            return builder.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Nonnull
    public Iterable<PayrollItemType> findAllByLaborUnionContractIsNull();
}

