/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import de.qfm.erp.service.model.internal.EStringSearchFilterType;
import de.qfm.erp.service.model.internal.StringSearchFilter;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.costcenter.ECostCenterFilterType;
import de.qfm.erp.service.model.internal.dashboard.IReportCountDateBigDecimalBigDecimal;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.measurement.MeasurementAmountPriceWage;
import de.qfm.erp.service.model.internal.measurement.MeasurementFilter;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.BaseRepository;
import de.qfm.erp.service.repository.MeasurementRepository;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/*
 * Exception performing whole class analysis ignored.
 */
public interface MeasurementRepository
extends JpaRepository<Measurement, Long>,
JpaSpecificationExecutor<Measurement>,
BaseRepository {
    public static final CharMatcher DIGIT = CharMatcher.inRange((char)'0', (char)'9').precomputed();

    @Nonnull
    public static List<Predicate> predicates(@NonNull MeasurementFilter measurementFilter, @NonNull Root<Measurement> root, @NonNull Join<Measurement, Quotation> childrenProd_M_Q, @NonNull Join<Quotation, QEntity> childrenProd_Q_E, @NonNull Join<Quotation, Project> childrenProd_Q_P, @NonNull Join<Measurement, Invoice> childrenProd_M_I, @NonNull Join<Measurement, MeasurementState> childrenProd_M_MS, @NonNull Join<Measurement, MeasurementPosition> childrenProd_M_MP, @NonNull Join<Measurement, User> childrenProd_M_U, @NonNull Join<User, UserCostCenter> childrenProd_U_UCU, @NonNull CriteriaBuilder builder, @NonNull Iterable<Long> limitToUserIds) {
        ImmutableList pre;
        ImmutableList.Builder specificationBuilder;
        ImmutableSet securedAssignedUserIds;
        if (measurementFilter == null) {
            throw new NullPointerException("measurementFilter is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (childrenProd_M_Q == null) {
            throw new NullPointerException("childrenProd_M_Q is marked non-null but is null");
        }
        if (childrenProd_Q_E == null) {
            throw new NullPointerException("childrenProd_Q_E is marked non-null but is null");
        }
        if (childrenProd_Q_P == null) {
            throw new NullPointerException("childrenProd_Q_P is marked non-null but is null");
        }
        if (childrenProd_M_I == null) {
            throw new NullPointerException("childrenProd_M_I is marked non-null but is null");
        }
        if (childrenProd_M_MS == null) {
            throw new NullPointerException("childrenProd_M_MS is marked non-null but is null");
        }
        if (childrenProd_M_MP == null) {
            throw new NullPointerException("childrenProd_M_MP is marked non-null but is null");
        }
        if (childrenProd_M_U == null) {
            throw new NullPointerException("childrenProd_M_U is marked non-null but is null");
        }
        if (childrenProd_U_UCU == null) {
            throw new NullPointerException("childrenProd_U_UCU is marked non-null but is null");
        }
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (limitToUserIds == null) {
            throw new NullPointerException("limitToUserIds is marked non-null but is null");
        }
        ArrayList predicates = Lists.newArrayList();
        boolean restrictEmptyAssigned = measurementFilter.isRestrictEmptyAssigned();
        boolean flagNAL = measurementFilter.isFlagNAL();
        ImmutableSet measurementIds = ImmutableSet.copyOf((Iterable)measurementFilter.getMeasurementIds());
        ImmutableSet assignedUserIds = ImmutableSet.copyOf((Iterable)measurementFilter.getAssignedUserIds());
        ImmutableSet limitedUserIds = ImmutableSet.copyOf(limitToUserIds);
        if (!Iterables.isEmpty(limitToUserIds)) {
            ImmutableSet intersection = Sets.intersection((Set)assignedUserIds, (Set)limitedUserIds).immutableCopy();
            if (restrictEmptyAssigned && Iterables.isEmpty((Iterable)intersection)) {
                predicates.add(builder.and(new Predicate[]{root.get("id").isNull()}));
                securedAssignedUserIds = limitedUserIds;
            } else {
                securedAssignedUserIds = intersection;
            }
        } else {
            securedAssignedUserIds = assignedUserIds;
        }
        ImmutableSet measurementStates = ImmutableSet.copyOf((Iterable)measurementFilter.getMeasurementStates());
        Range accountingMonth = measurementFilter.getAccountingMonth();
        Range projectExecution = measurementFilter.getProjectExecution();
        ImmutableSet quotationNumbers = ImmutableSet.copyOf((Iterable)measurementFilter.getQuotationNumbers());
        ImmutableSet entityIds = ImmutableSet.copyOf((Iterable)measurementFilter.getEntityIds());
        ImmutableSet stageIds = ImmutableSet.copyOf((Iterable)measurementFilter.getStageIds());
        ImmutableSet projectIds = ImmutableSet.copyOf((Iterable)measurementFilter.getProjectIds());
        ImmutableSet costCenterFilters = ImmutableSet.copyOf((Iterable)measurementFilter.getCostCenters());
        ImmutableSet positionFilters = ImmutableSet.copyOf((Iterable)measurementFilter.getPositionNumbers());
        if (!Iterables.isEmpty((Iterable)measurementIds)) {
            predicates.add(root.get("id").in((Collection)measurementIds));
        }
        if (flagNAL) {
            predicates.add(builder.isFalse((Expression)childrenProd_M_Q.get("flagOrderEnd")));
        }
        if (!Iterables.isEmpty((Iterable)quotationNumbers)) {
            MeasurementSpecifications.quotationNumberIn(childrenProd_M_Q, (Iterable)quotationNumbers).ifPresent(predicates::add);
        }
        if (!Iterables.isEmpty((Iterable)stageIds)) {
            MeasurementSpecifications.stageIdsIn(childrenProd_M_Q, (Iterable)stageIds).ifPresent(predicates::add);
        }
        if (!Iterables.isEmpty((Iterable)entityIds)) {
            MeasurementSpecifications.entityIdsIn(childrenProd_Q_E, (Iterable)entityIds).ifPresent(predicates::add);
        }
        if (!Iterables.isEmpty((Iterable)projectIds)) {
            MeasurementSpecifications.projectIdsIn(childrenProd_Q_P, (Iterable)projectIds).ifPresent(predicates::add);
        }
        if (!Iterables.isEmpty((Iterable)costCenterFilters)) {
            specificationBuilder = ImmutableList.builder();
            for (CostCenterFilter costCenterFilter : costCenterFilters) {
                MeasurementRepository.userCostCenter((CriteriaBuilder)builder, childrenProd_U_UCU, (CostCenterFilter)costCenterFilter).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationBuilder).add(arg_0));
            }
            pre = specificationBuilder.build();
            predicates.add(builder.or((Predicate[])pre.toArray((Object[])new Predicate[0])));
        }
        if (!Iterables.isEmpty((Iterable)positionFilters)) {
            specificationBuilder = ImmutableList.builder();
            for (StringSearchFilter positionFilter : positionFilters) {
                MeasurementRepository.positionNumber((CriteriaBuilder)builder, childrenProd_M_MP, (StringSearchFilter)positionFilter).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationBuilder).add(arg_0));
            }
            pre = specificationBuilder.build();
            predicates.add(builder.disjunction().in((Collection)pre));
        }
        if (!Iterables.isEmpty((Iterable)securedAssignedUserIds)) {
            predicates.add(builder.and(new Predicate[]{childrenProd_M_U.get("id").in(securedAssignedUserIds.toArray())}));
        }
        if (!Iterables.isEmpty((Iterable)measurementStates)) {
            if (flagNAL) {
                LocalDate referenceDate = accountingMonth.hasLowerBound() ? (LocalDate)accountingMonth.lowerEndpoint() : (accountingMonth.hasUpperBound() ? (LocalDate)accountingMonth.upperEndpoint() : YearMonth.now().atDay(1));
                String accountingMonthToString = YearMonth.from(referenceDate).format(DateTimeFormatter.ofPattern("yyyyMM"));
                predicates.add(builder.or((Expression)MeasurementSpecifications.measurementStateIn(childrenProd_M_MS, (Iterable)measurementStates).get(), (Expression)builder.greaterThan(builder.function("TO_CHAR", String.class, new Expression[]{childrenProd_M_I.get("postingDate"), builder.literal((Object)"yyyyMM")}), (Comparable)((Object)accountingMonthToString))));
            } else {
                MeasurementSpecifications.measurementStateIn(childrenProd_M_MS, (Iterable)measurementStates).ifPresent(predicates::add);
            }
        }
        if (!measurementFilter.isFlagInvoiceDateLaterThanProjectExecutionBegin()) {
            if (accountingMonth.hasLowerBound()) {
                localDate = (LocalDate)accountingMonth.lowerEndpoint();
                predicates.add(builder.greaterThanOrEqualTo((Expression)root.get("accountingMonth"), (Comparable)localDate));
            }
            if (accountingMonth.hasUpperBound()) {
                localDate = (LocalDate)accountingMonth.upperEndpoint();
                predicates.add(builder.lessThanOrEqualTo((Expression)root.get("accountingMonth"), (Comparable)localDate));
            }
        } else {
            if (accountingMonth.hasLowerBound()) {
                localDate = (LocalDate)accountingMonth.lowerEndpoint();
                predicates.add(builder.greaterThanOrEqualTo((Expression)root.get("projectExecutionStartDate"), (Comparable)localDate));
            }
            if (accountingMonth.hasUpperBound()) {
                localDate = (LocalDate)accountingMonth.upperEndpoint();
                predicates.add(builder.lessThanOrEqualTo((Expression)root.get("projectExecutionStartDate"), (Comparable)localDate));
            }
        }
        if (projectExecution.hasLowerBound() || projectExecution.hasUpperBound()) {
            LocalDate lowerBound = projectExecution.hasLowerBound() ? (LocalDate)projectExecution.lowerEndpoint() : MIN_DATE;
            LocalDate upperBound = projectExecution.hasUpperBound() ? (LocalDate)projectExecution.upperEndpoint() : MAX_DATE;
            predicates.add(builder.and((Expression)builder.lessThanOrEqualTo((Expression)root.get("projectExecutionStartDate"), (Comparable)upperBound), (Expression)builder.lessThanOrEqualTo((Expression)root.get("projectExecutionEndDate"), (Comparable)lowerBound)));
        }
        return predicates;
    }

    @Nonnull
    public static Optional<Predicate> userCostCenter(@NonNull CriteriaBuilder builder, @NonNull Join<User, UserCostCenter> childrenProd_U_UCU, @NonNull CostCenterFilter costCenterFilter) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (childrenProd_U_UCU == null) {
            throw new NullPointerException("childrenProd_U_UCU is marked non-null but is null");
        }
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        ECostCenterFilterType costCenterFilterType = costCenterFilter.getCostCenterFilterType();
        String costCenter = costCenterFilter.getCostCenter();
        if (ECostCenterFilterType.EQ == costCenterFilterType) {
            return Optional.of(childrenProd_U_UCU.get("costCenter").in((Collection)ImmutableSet.of((Object)costCenter)));
        }
        if (ECostCenterFilterType.STARTS_WITH == costCenterFilterType) {
            return Optional.of(builder.like((Expression)childrenProd_U_UCU.get("costCenter"), costCenter + "%"));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Predicate> positionNumber(@NonNull CriteriaBuilder builder, @NonNull Join<Measurement, MeasurementPosition> childrenProd_M_MP, @NonNull StringSearchFilter stringSearchFilter) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (childrenProd_M_MP == null) {
            throw new NullPointerException("childrenProd_M_MP is marked non-null but is null");
        }
        if (stringSearchFilter == null) {
            throw new NullPointerException("stringSearchFilter is marked non-null but is null");
        }
        EStringSearchFilterType stringSearchFilterType = stringSearchFilter.getStringSearchFilterType();
        String value = stringSearchFilter.getValue();
        if (EStringSearchFilterType.EQ == stringSearchFilterType) {
            return Optional.of(childrenProd_M_MP.get("surrogatePositionNumber").in((Collection)ImmutableSet.of((Object)value)));
        }
        if (EStringSearchFilterType.STARTS_WITH == stringSearchFilterType) {
            return Optional.of(builder.like((Expression)childrenProd_M_MP.get("surrogatePositionNumber"), value + "%"));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Measurement> findByMeasurementNumber(@NonNull String var1);

    @Nonnull
    public Iterable<Measurement> findAllByMeasurementNumberIn(@NonNull Iterable<String> var1);

    @Nonnull
    public Optional<Measurement> findByReferenceId(@NonNull String var1);

    @Query(value="select m from Measurement m where m.catchAll like %:query% AND m.entityState in (:entityStates)order by m.updatedOn desc")
    public Page<Measurement> search(@NonNull Pageable var1, @Param(value="query") @NonNull String var2, @Param(value="entityStates") @NonNull Iterable<EntityState> var3);

    @Query(value="select m.id from Measurement m where  m.entityState in (:entityStates) order by m.id")
    public Page<Long> findEntityIds(@NonNull Pageable var1, @Param(value="entityStates") @NonNull Iterable<EntityState> var2);

    @Query(value="select distinct(trim(m.personResponsibleAtCustomer)) from Measurement m join m.quotation q where q.id = :quotationId AND lower(m.personResponsibleAtCustomer) like %:filter%")
    public List<String> personAutoComplete(@Param(value="quotationId") long var1, @Param(value="filter") @NonNull String var3);

    @Nonnull
    @Query(value="select m from   Measurement m join m.releaseOrder ro where  ro.pssReleaseOrder in (:pssReleaseOrders)")
    public Iterable<Measurement> allMeasurementsWithPSSRO(@Param(value="pssReleaseOrders") @NonNull Iterable<PssReleaseOrder> var1);

    default public Long countMeasurementsWithPSSRO(@NonNull Iterable<Long> measurementIdsToIgnore, @NonNull Iterable<EMeasurementType> measurementTypes, @NonNull Iterable<EMeasurementState> measurementStates, @NonNull Iterable<PssReleaseOrder> pssReleaseOrders) {
        if (measurementIdsToIgnore == null) {
            throw new NullPointerException("measurementIdsToIgnore is marked non-null but is null");
        }
        if (measurementTypes == null) {
            throw new NullPointerException("measurementTypes is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        if (pssReleaseOrders == null) {
            throw new NullPointerException("pssReleaseOrders is marked non-null but is null");
        }
        ImmutableList.Builder specificationsList = ImmutableList.builder();
        MeasurementSpecifications.idNotIn(measurementIdsToIgnore).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        MeasurementSpecifications.measurementTypesIn(measurementTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        MeasurementSpecifications.measurementStateIn(measurementStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        MeasurementSpecifications.pssReleaseOrderIn(pssReleaseOrders).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        ImmutableList specs = specificationsList.build();
        return this.count(MeasurementSpecifications.conjunction((Specification)MeasurementSpecifications.identity(), (Iterable)specs));
    }

    default public Iterable<Measurement> allMeasurementsWithPSSRO(@NonNull Iterable<Long> measurementIdsToIgnore, @NonNull Iterable<EMeasurementType> measurementTypes, @NonNull Iterable<EMeasurementState> measurementStates, @NonNull Iterable<PssReleaseOrder> pssReleaseOrders, int maxResults) {
        if (measurementIdsToIgnore == null) {
            throw new NullPointerException("measurementIdsToIgnore is marked non-null but is null");
        }
        if (measurementTypes == null) {
            throw new NullPointerException("measurementTypes is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        if (pssReleaseOrders == null) {
            throw new NullPointerException("pssReleaseOrders is marked non-null but is null");
        }
        ImmutableList.Builder specificationsList = ImmutableList.builder();
        MeasurementSpecifications.idNotIn(measurementIdsToIgnore).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        MeasurementSpecifications.measurementTypesIn(measurementTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        MeasurementSpecifications.measurementStateIn(measurementStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        MeasurementSpecifications.pssReleaseOrderIn(pssReleaseOrders).ifPresent(arg_0 -> ((ImmutableList.Builder)specificationsList).add(arg_0));
        ImmutableList specs = specificationsList.build();
        return this.findAll(MeasurementSpecifications.conjunction((Specification)MeasurementSpecifications.identity(), (Iterable)specs), (Pageable)PageRequest.of((int)0, (int)maxResults));
    }

    @Modifying
    @Query(value="update Measurement m set m.searchIndexState = :searchIndexState where m.id in :measurementIds")
    public int updateSearchIndexState(@Param(value="searchIndexState") @NonNull ESearchIndexState var1, @Param(value="measurementIds") @NonNull Iterable<Long> var2);

    @Query(value="select m from Measurement m   join m.quotation q where   m.measurementNumber in :measurementNumbers   AND q.pdfExtractType in :pdfExtractTypes")
    public Iterable<Measurement> allRelevant(@Param(value="measurementNumbers") Iterable<String> var1, @Param(value="pdfExtractTypes") Iterable<EPdfExtractType> var2);

    @Modifying
    @Query(value="update Measurement m set m.sheetNumberValue = :sheetNumberValue where m.id in :measurementId")
    public int patchSheetNumberValue(@Param(value="measurementId") @NonNull Long var1, @Param(value="sheetNumberValue") @NonNull Long var2);

    @Query(value="SELECT m.accountingMonth AS label, sum(m.valueOverall) AS value1, sum(m.wageOverall) AS value2 FROM Measurement m WHERE m.accountingMonth = :referenceDate AND       m.assignedUser in (:referenceUsers) GROUP BY m.accountingMonth ")
    public List<IReportCountDateBigDecimalBigDecimal> measurementAmountsInMonth(@Param(value="referenceDate") @NonNull LocalDate var1, @Param(value="referenceUsers") @NonNull Iterable<User> var2);

    @Query(value="SELECT m FROM Measurement m WHERE   m.searchIndexState in :searchIndexStates")
    @Nonnull
    public List<Measurement> findAllUnIndexed(@Param(value="searchIndexStates") @NonNull Iterable<ESearchIndexState> var1, @NonNull Pageable var2);

    @Query(value="select mp.surrogatePositionNumber AS surrogatePositionNumber, q.quotationNumber AS quotationNumber, mp.addendumNumber AS addendumNumber, mp.flagAlternativePosition AS flagAlternativePosition, ms.measurementState AS measurementState, sum(mp.product) AS product, sum(mp.priceAggregated) AS price, sum(mp.internalWageAggregated) AS internalWageAggregated, sum(mp.companyWageAggregated) AS companyWageAggregated, sum(mp.materialSellingPriceAggregated) AS materialSellingPriceAggregated from Measurement m join m.measurementState ms join m.measurementPositions mp join m.quotation q where   q.quotationNumber in (:quotationNumbers)   AND ms.measurementState in :measurementStates   AND m.projectExecutionStartDate <= :dateRangeTo   AND m.projectExecutionEndDate >= :dateRangeFrom group by   q.quotationNumber, mp.surrogatePositionNumber, mp.addendumNumber, mp.flagAlternativePosition, ms.measurementState")
    @Nonnull
    public List<MeasurementAmountPriceWage> amountPriceWage(@Param(value="quotationNumbers") @NonNull Iterable<String> var1, @Param(value="measurementStates") @NonNull Iterable<EMeasurementState> var2, @Param(value="dateRangeFrom") @NonNull LocalDate var3, @Param(value="dateRangeTo") @NonNull LocalDate var4);

    @Query(value="select mp.surrogatePositionNumber AS surrogatePositionNumber, q.quotationNumber AS quotationNumber, mp.addendumNumber AS addendumNumber, mp.flagAlternativePosition AS flagAlternativePosition, ms.measurementState AS measurementState, sum(mp.product) AS product, sum(mp.priceAggregated) AS price, sum(mp.internalWageAggregated) AS internalWageAggregated, sum(mp.companyWageAggregated) AS companyWageAggregated, sum(mp.materialSellingPriceAggregated) AS materialSellingPriceAggregated from Measurement m join m.measurementState ms join m.measurementPositions mp join m.quotation q where   q.quotationNumber in (:quotationNumbers)  AND mp.surrogatePositionNumber in :surrogatePositionNumbers   AND ms.measurementState in :measurementStates   AND m.projectExecutionStartDate <= :dateRangeTo   AND m.projectExecutionEndDate >= :dateRangeFrom group by   q.quotationNumber, mp.surrogatePositionNumber, mp.addendumNumber, mp.flagAlternativePosition, ms.measurementState")
    @Nonnull
    public List<MeasurementAmountPriceWage> amountPriceWage(@Param(value="quotationNumbers") @NonNull Iterable<String> var1, @Param(value="surrogatePositionNumbers") @NonNull Iterable<String> var2, @Param(value="measurementStates") @NonNull Iterable<EMeasurementState> var3, @Param(value="dateRangeFrom") @NonNull LocalDate var4, @Param(value="dateRangeTo") @NonNull LocalDate var5);

    @Nonnull
    @Query(value="SELECT distinct q.quotationNumber FROM Measurement m JOIN m.quotation q WHERE    m.assignedUser = :assignedUser AND m.accountingMonth between :referenceDateFrom AND :referenceDateTo    AND NOT exists ( select q2 from Quotation q2 where q2.flagOrderEnd = true AND q2.quotationNumber = q.quotationNumber )ORDER BY q.quotationNumber")
    public List<String> quotationNumbersFromMeasurementsForAssignedUser(@Param(value="assignedUser") @NonNull User var1, @Param(value="referenceDateFrom") @NonNull LocalDate var2, @Param(value="referenceDateTo") @NonNull LocalDate var3);
}

