/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.base.Splitter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;

public interface BaseRepository {
    public static final LocalDate MIN_DATE = LocalDate.of(1900, 1, 1);
    public static final LocalDate MAX_DATE = LocalDate.of(2100, 1, 1);
    public static final Splitter SEARCH_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();

    @Nonnull
    public static Expression<LocalDate> truncToMonth(@NonNull CriteriaBuilder builder, @NonNull Path<LocalDate> datePath) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (datePath == null) {
            throw new NullPointerException("datePath is marked non-null but is null");
        }
        return ((SqmCriteriaNodeBuilder)builder).truncate(datePath, TemporalUnit.MONTH);
    }

    @Nonnull
    public static Expression<String> replace(@NonNull CriteriaBuilder builder, @NonNull Path<String> path, @NonNull String first, @NonNull String second) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        return builder.function("REPLACE", String.class, new Expression[]{path, builder.literal((Object)first), builder.literal((Object)second)});
    }

    @Nonnull
    public static Expression<String> upper(@NonNull CriteriaBuilder builder, @NonNull Path<String> stringPath) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (stringPath == null) {
            throw new NullPointerException("stringPath is marked non-null but is null");
        }
        return builder.function("UPPER", String.class, new Expression[]{stringPath});
    }

    @Nonnull
    public static Expression<String> lower(@NonNull CriteriaBuilder builder, @NonNull Path<String> stringPath) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (stringPath == null) {
            throw new NullPointerException("stringPath is marked non-null but is null");
        }
        return builder.function("LOWER", String.class, new Expression[]{stringPath});
    }
}

