/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import de.qfm.erp.service.model.internal.payroll.IAggregatedAttendanceUser;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.user.User;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface AttendanceRepository
extends JpaRepository<Attendance, Long> {
    @Nonnull
    public Optional<Attendance> findByReferenceId(@NonNull String var1);

    @Nonnull
    public Iterable<Attendance> findByEmployeeDayTypeAndDateBetweenAndPayrollMonthIsNotNull(@NonNull EAttendanceDayType var1, @NonNull LocalDate var2, @NonNull LocalDate var3);

    @Query(value="SELECT a FROM    Attendance a    JOIN a.payrollMonth pm    JOIN pm.user u WHERE    a.date between :referenceStart AND :referenceEnd AND    a.squadLeader = :squadLeader AND    (   a.employeeDayType = 'STANDARD' OR ( a.employeeDayType = 'BAD_WEATHER' AND a.workDuration >= :badWeatherWorkTimeMin )    ) ")
    @Nonnull
    public Iterable<Attendance> findByDateBetweenAndSquadLeader(@Param(value="referenceStart") @NonNull LocalDate var1, @Param(value="referenceEnd") @NonNull LocalDate var2, @Param(value="squadLeader") @NonNull User var3, @Param(value="badWeatherWorkTimeMin") @NonNull Duration var4);

    @Query(value="SELECT   a.id as attendanceId, u.id as userId, a.origin as origin, a.lastOrigin as lastOrigin FROM    Attendance a    JOIN a.payrollMonth pm    JOIN pm.user u WHERE    pm.accountingMonth = :accountingMonth AND    u.id in :relevantUserIds AND    pm.payrollMonthState = 'RELEASED' ")
    @Nonnull
    public Iterable<IAggregatedAttendanceUser> releaseAttendances(@Param(value="accountingMonth") @NonNull LocalDate var1, @Param(value="relevantUserIds") @NonNull Iterable<Long> var2);

    @Query(value="SELECT   a.id as attendanceId, u.id as userId, a.origin as origin, a.lastOrigin as lastOrigin FROM    Attendance a    JOIN a.payrollMonth pm    JOIN pm.user u WHERE    u.id in :relevantUserIds AND    a.date = :referenceDate AND    (       a.employeeDayType in :attendanceDayTypes OR       a.lastOrigin <> 'BAD_WEATHER'    )")
    @Nonnull
    public Iterable<IAggregatedAttendanceUser> alreadyOfTypeOrPayrollMonthEdited(@Param(value="referenceDate") @NonNull LocalDate var1, @Param(value="relevantUserIds") @NonNull Iterable<Long> var2, @Param(value="attendanceDayTypes") @NonNull Iterable<EAttendanceDayType> var3);
}

