/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.search.IndexSearchResult;
import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.UserSearchResultItem;
import de.qfm.erp.service.model.search.timing.TimingResult;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class UserIndexSearchResult
extends IndexSearchResult<UserSearchResultItem> {
    public UserIndexSearchResult(@NonNull InternalSearchRequest searchRequest, long totalHits, int totalPages, @NonNull List<UserSearchResultItem> searchResultItems, @NonNull TimingResult timing) {
        super(searchRequest, totalHits, totalPages, searchResultItems, timing);
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest is marked non-null but is null");
        }
        if (searchResultItems == null) {
            throw new NullPointerException("searchResultItems is marked non-null but is null");
        }
        if (timing == null) {
            throw new NullPointerException("timing is marked non-null but is null");
        }
    }

    @Nonnull
    public static UserIndexSearchResult of(@NonNull InternalSearchRequest searchRequest, long totalHits, int totalPages, @NonNull List<UserSearchResultItem> items, @NonNull TimingResult timingResult) {
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (timingResult == null) {
            throw new NullPointerException("timingResult is marked non-null but is null");
        }
        return new UserIndexSearchResult(searchRequest, totalHits, totalPages, (List)ImmutableList.copyOf(items), timingResult);
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    public String toString() {
        return "UserIndexSearchResult()";
    }
}

