/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import lombok.NonNull;
import org.apache.lucene.document.Document;

public abstract class SearchResultItem<T> {
    @NonNull
    private Document document;
    @NonNull
    private Float score;
    @NonNull
    private T indexEntry;

    protected SearchResultItem() {
    }

    protected SearchResultItem(@NonNull Document document, @NonNull Float score, @NonNull T indexEntry) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        if (indexEntry == null) {
            throw new NullPointerException("indexEntry is marked non-null but is null");
        }
        this.document = document;
        this.score = score;
        this.indexEntry = indexEntry;
    }

    @NonNull
    public Document getDocument() {
        return this.document;
    }

    @NonNull
    public Float getScore() {
        return this.score;
    }

    @NonNull
    public T getIndexEntry() {
        return (T)this.indexEntry;
    }

    public String toString() {
        return "SearchResultItem(document=" + String.valueOf(this.getDocument()) + ", score=" + this.getScore() + ", indexEntry=" + String.valueOf(this.getIndexEntry()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResultItem)) {
            return false;
        }
        SearchResultItem other = (SearchResultItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Float this$score = this.getScore();
        Float other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        Object this$indexEntry = this.getIndexEntry();
        Object other$indexEntry = other.getIndexEntry();
        return !(this$indexEntry == null ? other$indexEntry != null : !this$indexEntry.equals(other$indexEntry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchResultItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        Object $indexEntry = this.getIndexEntry();
        result = result * 59 + ($indexEntry == null ? 43 : $indexEntry.hashCode());
        return result;
    }
}

