/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.search.IndexField;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EUserIndexField implements IndexField
{
    UNKNOWN("unknown"),
    _ID("_id"),
    _SOURCE("_source"),
    _TYPE("_type"),
    _ALL("_all"),
    ENTRY_TYPE("entry_type"),
    USER__ENTITY_STATE("user.entity_state"),
    USER__CREATED_ON("user.created_on"),
    USER__CREATED_BY("user.created_by"),
    USER__UPDATED_ON("user.updated_on"),
    USER__UPDATED_BY("user.updated_by"),
    USER__FULL_NAME("user.full_name"),
    USER__PERSONAL_NUMBER("user.personal_number"),
    USER__PERSONAL_NUMBER_TXT("user.personal_number_txt"),
    USER__EMAIL("user.email"),
    SORT_USER__CREATED_ON("sort.user.created_on"),
    SORT_USER__UPDATED_ON("sort.user.updated_on"),
    SPELLCHECK__CLAZZ("spellcheck_clazz"),
    SPELLCHECK__FIELD("spellcheck_field"),
    SPELLCHECK__VALUE("spellcheck_value"),
    SPELLCHECK__PHONETIC("spellcheck_phonetic"),
    SPELLCHECK__LENGTH("spellcheck_length");

    private final String fieldName;
    private static final Map<String, EUserIndexField> LOOKUP;
    @Nonnull
    public static final Iterable<IndexField> STRING_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> USER__FULLTEXT_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> NUMERIC_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> CATCH_ALL_FIELDS;

    private EUserIndexField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.fieldName = fieldName;
    }

    @Nonnull
    public static Iterable<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EUserIndexField lookup(@NonNull String candidate, @NonNull EUserIndexField defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EUserIndexField.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EUserIndexField> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EUserIndexField.key((String)candidate);
        return Optional.ofNullable((EUserIndexField)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EUserIndexField hint) {
        if (hint == null) {
            throw new NullPointerException("hint is marked non-null but is null");
        }
        return EUserIndexField.key((String)hint.fieldName());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String fieldName() {
        return this.fieldName;
    }

    @Nonnull
    public Iterable<IndexField> numericFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public Iterable<IndexField> copyFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public String messageCode() {
        return "index_field." + this.fieldName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EUserIndexField value : EUserIndexField.values()) {
            String key = EUserIndexField.key((EUserIndexField)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        STRING_QUERY_FIELDS = ImmutableSet.of((Object)USER__FULL_NAME, (Object)USER__EMAIL, (Object)USER__PERSONAL_NUMBER_TXT);
        USER__FULLTEXT_QUERY_FIELDS = ImmutableSet.of((Object)USER__FULL_NAME, (Object)USER__EMAIL, (Object)USER__PERSONAL_NUMBER_TXT);
        NUMERIC_FIELDS = ImmutableSet.of((Object)USER__PERSONAL_NUMBER);
        CATCH_ALL_FIELDS = ImmutableSet.builder().addAll(STRING_QUERY_FIELDS).addAll(NUMERIC_FIELDS).build();
    }
}

