/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.search.IndexField;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EInvoiceIndexField implements IndexField
{
    UNKNOWN("unknown"),
    _ID("_id"),
    _SOURCE("_source"),
    _TYPE("_type"),
    _ALL("_all"),
    ENTRY_TYPE("entry_type"),
    INVOICE__ID("invoice.id"),
    INVOICE__ENTITY_STATE("invoice.entity_state"),
    INVOICE__INVOICE_STATE("invoice.invoice_state"),
    INVOICE__INVOICE_TYPE("invoice.invoice_type"),
    INVOICE__CREATED_ON("invoice.created_on"),
    INVOICE__CREATED_BY("invoice.created_by"),
    INVOICE__UPDATED_ON("invoice.updated_on"),
    INVOICE__UPDATED_BY("invoice.updated_by"),
    INVOICE__MEASUREMENT_NUMBER("invoice.measurement_number"),
    INVOICE__STAGE_ID("invoice.stage_id"),
    INVOICE__ENTITY_ID("invoice.entity_id"),
    INVOICE__STAGE_NUMBER("invoice.stage_number"),
    INVOICE__STAGE_ALIAS("invoice.stage_alias"),
    INVOICE__ENTITY_NUMBER("invoice.entity_number"),
    INVOICE__ENTITY_ALIAS("invoice.entity_alias"),
    INVOICE__QUOTATION_NUMBER("invoice.quotation_number"),
    INVOICE__INVOICE_NUMBER("invoice.invoice_number"),
    INVOICE__COST_CENTER("invoice.cost_center"),
    INVOICE__CONTACT_PERSON("invoice.contact_person"),
    INVOICE__ORDER_NUMBER("invoice.order_number"),
    INVOICE__VOUCHER_NUMBER("invoice.voucher_number"),
    INVOICE__CREDIT_VOUCHER_NUMBER("invoice.credit_voucher_number"),
    INVOICE__CONSTRUCTION_SITE("invoice.construction_site"),
    INVOICE__INVOICE_NAME("invoice.invoice_name"),
    INVOICE__INVOICE_ADDRESS_NAME("invoice.invoice_address.name"),
    INVOICE__INVOICE_ADDRESS_STREET("invoice.invoice_address.street"),
    INVOICE__INVOICE_ADDRESS_SUFFIX("invoice.invoice_address_suffix"),
    INVOICE__INVOICE_REF_ADDRESS_NAME("invoice.invoice_ref_address.name"),
    INVOICE__INVOICE_REF_ADDRESS_STREET("invoice.invoice_ref_address.street"),
    INVOICE__INVOICE_REF_ADDRESS_SUFFIX("invoice.invoice_ref_address_suffix"),
    INVOICE__INVOICE_REF_NAME("invoice.invoice_ref_name"),
    INVOICE__IMPORT_FILE_NAME("invoice.import_file_name"),
    INVOICE__ORDER_DESCRIPTION("invoice.order_description"),
    INVOICE__FINANCE_DEBTOR_ACCOUNT_NUMBER("invoice.finance_debtor_account_number"),
    INVOICE__PRIMARY_RESPONSIBLE_USER__FULL_NAME("invoice.primary_responsible_user.full_name"),
    SORT_INVOICE__CREATED_ON("sort.invoice.created_on"),
    SORT_INVOICE__UPDATED_ON("sort.invoice.updated_on"),
    SPELLCHECK__CLAZZ("spellcheck_clazz"),
    SPELLCHECK__FIELD("spellcheck_field"),
    SPELLCHECK__VALUE("spellcheck_value"),
    SPELLCHECK__PHONETIC("spellcheck_phonetic"),
    SPELLCHECK__LENGTH("spellcheck_length");

    private final String fieldName;
    private static final Map<String, EInvoiceIndexField> LOOKUP;
    @Nonnull
    public static final Iterable<IndexField> STRING_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<EInvoiceIndexField> INVOICE__FULLTEXT_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> NUMERIC_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> ALL_NO_ANALYZER_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> CATCH_ALL_FIELDS;

    private EInvoiceIndexField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.fieldName = fieldName;
    }

    @Nonnull
    public static Iterable<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EInvoiceIndexField lookup(@NonNull String candidate, @NonNull EInvoiceIndexField defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EInvoiceIndexField.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EInvoiceIndexField> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EInvoiceIndexField.key((String)candidate);
        return Optional.ofNullable((EInvoiceIndexField)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EInvoiceIndexField hint) {
        if (hint == null) {
            throw new NullPointerException("hint is marked non-null but is null");
        }
        return EInvoiceIndexField.key((String)hint.fieldName());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String fieldName() {
        return this.fieldName;
    }

    @Nonnull
    public Iterable<IndexField> numericFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public Iterable<IndexField> copyFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public String messageCode() {
        return "index_field." + this.fieldName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EInvoiceIndexField value : EInvoiceIndexField.values()) {
            String key = EInvoiceIndexField.key((EInvoiceIndexField)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        STRING_QUERY_FIELDS = ImmutableSet.of((Object)INVOICE__MEASUREMENT_NUMBER, (Object)INVOICE__STAGE_NUMBER, (Object)INVOICE__ENTITY_NUMBER, (Object)INVOICE__QUOTATION_NUMBER, (Object)INVOICE__INVOICE_NUMBER, (Object)INVOICE__CONTACT_PERSON, (Object[])new IndexField[]{INVOICE__ORDER_NUMBER, INVOICE__CONSTRUCTION_SITE, INVOICE__VOUCHER_NUMBER, INVOICE__CREDIT_VOUCHER_NUMBER, INVOICE__INVOICE_NAME, INVOICE__INVOICE_ADDRESS_SUFFIX, INVOICE__INVOICE_REF_NAME, INVOICE__INVOICE_REF_ADDRESS_SUFFIX, INVOICE__IMPORT_FILE_NAME, INVOICE__ORDER_DESCRIPTION, INVOICE__FINANCE_DEBTOR_ACCOUNT_NUMBER, INVOICE__PRIMARY_RESPONSIBLE_USER__FULL_NAME});
        INVOICE__FULLTEXT_QUERY_FIELDS = ImmutableSet.of((Object)INVOICE__STAGE_NUMBER, (Object)INVOICE__ENTITY_NUMBER, (Object)INVOICE__QUOTATION_NUMBER, (Object)INVOICE__INVOICE_NUMBER, (Object)INVOICE__CONTACT_PERSON, (Object)INVOICE__ORDER_NUMBER, (Object[])new EInvoiceIndexField[]{INVOICE__VOUCHER_NUMBER, INVOICE__CREDIT_VOUCHER_NUMBER, INVOICE__CONSTRUCTION_SITE, INVOICE__INVOICE_NAME, INVOICE__ORDER_DESCRIPTION, INVOICE__FINANCE_DEBTOR_ACCOUNT_NUMBER, INVOICE__MEASUREMENT_NUMBER});
        NUMERIC_FIELDS = ImmutableSet.of((Object)INVOICE__MEASUREMENT_NUMBER);
        ALL_NO_ANALYZER_FIELDS = ImmutableSet.of((Object)INVOICE__QUOTATION_NUMBER, (Object)INVOICE__INVOICE_NUMBER);
        CATCH_ALL_FIELDS = ImmutableSet.builder().addAll(STRING_QUERY_FIELDS).addAll(NUMERIC_FIELDS).build();
    }
}

