/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.user;

import com.google.common.base.Objects;
import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.UserBusinessUnit;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.employee.contract.EmployeeContract;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.profile.UserSetting;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.ERole;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.UserPrivilege;
import de.qfm.erp.service.model.jpa.user.UserRole;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.Set;

@Entity(name="User")
@Table(name="SYS_USER")
public class User
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SYS_USER_SEQ")
    @SequenceGenerator(sequenceName="SYS_USER_SEQ", allocationSize=1, name="SYS_USER_SEQ")
    private Long id;
    @Column(name="username", length=50, nullable=false, unique=true)
    private String username;
    @Column(name="password", length=50)
    private String password;
    @Column(name="disable_date")
    private LocalDate disableDate;
    @Column(name="disabled_at_date")
    private LocalDate disableAtDate;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="title", length=50)
    private String title;
    @Convert(converter=NullStringConverter.class)
    @Column(name="salutation", length=25)
    private String salutation;
    @Convert(converter=NullStringConverter.class)
    @Column(name="first_name", length=50)
    private String firstName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="last_name", length=50)
    private String lastName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="full_name", length=50)
    private String fullName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="short_name", length=20)
    private String shortName;
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Column(name="personal_number")
    private Integer personalNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="social_security_number", length=25)
    private String socialSecurityNumber;
    @Column(name="sequence_number")
    private Integer sequenceNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_name", length=30)
    private String groupName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="phone", length=20)
    private String phone;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cellular", length=20)
    private String cellular;
    @Convert(converter=NullStringConverter.class)
    @Column(name="fax", length=20)
    private String fax;
    @Convert(converter=NullStringConverter.class)
    @Column(name="email", length=100)
    private String email;
    @Convert(converter=NullStringConverter.class)
    @Column(name="location", length=250)
    private String location;
    @Convert(converter=NullStringConverter.class)
    @Column(name="authority_to_sign", length=25)
    private String authorityToSign;
    @Convert(converter=NullStringConverter.class)
    @Column(name="squad_reference_id", length=50)
    private String squadReferenceId;
    @Convert(converter=NullStringConverter.class)
    @Column(name="squad_name", length=50)
    private String squadName;
    @Column(name="squad_number")
    private Integer squadNumber;
    @Column(name="flag_sync_default")
    private boolean flagSyncDefault;
    @Deprecated
    @Enumerated(value=EnumType.STRING)
    @Column(name="role", length=50, nullable=false)
    private ERole roleDeprecated;
    @Column(name="search_index_state", length=50)
    @Enumerated(value=EnumType.STRING)
    private ESearchIndexState searchIndexState;
    @Column(name="allowed_to_login", nullable=false)
    private Boolean allowedToLogin;
    @Column(name="visible_in_measurement_edit", nullable=false)
    private Boolean visibleInMeasurement;
    @OneToOne(mappedBy="user", cascade={CascadeType.ALL})
    private WageAccount wageAccount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="squad_leader_id")
    private User squadLeader;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="manager_id")
    private User manager;
    @Deprecated
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="role_id")
    private Role role;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<UserSetting> settings;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<EmployeeContract> employeeContracts;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<UserBusinessUnit> userBusinessUnits;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<UserCostCenter> userCostCenters;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<UserRole> userRoles;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<UserPrivilege> userPrivileges;

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equal((Object)this.getId(), (Object)user.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getId()});
    }

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public LocalDate getDisableDate() {
        return this.disableDate;
    }

    public LocalDate getDisableAtDate() {
        return this.disableAtDate;
    }

    @Deprecated
    public String getTitle() {
        return this.title;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public Integer getPersonalNumber() {
        return this.personalNumber;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getCellular() {
        return this.cellular;
    }

    public String getFax() {
        return this.fax;
    }

    public String getEmail() {
        return this.email;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAuthorityToSign() {
        return this.authorityToSign;
    }

    public String getSquadReferenceId() {
        return this.squadReferenceId;
    }

    public String getSquadName() {
        return this.squadName;
    }

    public Integer getSquadNumber() {
        return this.squadNumber;
    }

    public boolean isFlagSyncDefault() {
        return this.flagSyncDefault;
    }

    @Deprecated
    public ERole getRoleDeprecated() {
        return this.roleDeprecated;
    }

    public ESearchIndexState getSearchIndexState() {
        return this.searchIndexState;
    }

    public Boolean getAllowedToLogin() {
        return this.allowedToLogin;
    }

    public Boolean getVisibleInMeasurement() {
        return this.visibleInMeasurement;
    }

    public WageAccount getWageAccount() {
        return this.wageAccount;
    }

    public User getSquadLeader() {
        return this.squadLeader;
    }

    public User getManager() {
        return this.manager;
    }

    @Deprecated
    public Role getRole() {
        return this.role;
    }

    public Set<UserSetting> getSettings() {
        return this.settings;
    }

    public Set<EmployeeContract> getEmployeeContracts() {
        return this.employeeContracts;
    }

    public Set<UserBusinessUnit> getUserBusinessUnits() {
        return this.userBusinessUnits;
    }

    public Set<UserCostCenter> getUserCostCenters() {
        return this.userCostCenters;
    }

    public Set<UserRole> getUserRoles() {
        return this.userRoles;
    }

    public Set<UserPrivilege> getUserPrivileges() {
        return this.userPrivileges;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDisableDate(LocalDate disableDate) {
        this.disableDate = disableDate;
    }

    public void setDisableAtDate(LocalDate disableAtDate) {
        this.disableAtDate = disableAtDate;
    }

    @Deprecated
    public void setTitle(String title) {
        this.title = title;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setPersonalNumber(Integer personalNumber) {
        this.personalNumber = personalNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setCellular(String cellular) {
        this.cellular = cellular;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setAuthorityToSign(String authorityToSign) {
        this.authorityToSign = authorityToSign;
    }

    public void setSquadReferenceId(String squadReferenceId) {
        this.squadReferenceId = squadReferenceId;
    }

    public void setSquadName(String squadName) {
        this.squadName = squadName;
    }

    public void setSquadNumber(Integer squadNumber) {
        this.squadNumber = squadNumber;
    }

    public void setFlagSyncDefault(boolean flagSyncDefault) {
        this.flagSyncDefault = flagSyncDefault;
    }

    @Deprecated
    public void setRoleDeprecated(ERole roleDeprecated) {
        this.roleDeprecated = roleDeprecated;
    }

    public void setSearchIndexState(ESearchIndexState searchIndexState) {
        this.searchIndexState = searchIndexState;
    }

    public void setAllowedToLogin(Boolean allowedToLogin) {
        this.allowedToLogin = allowedToLogin;
    }

    public void setVisibleInMeasurement(Boolean visibleInMeasurement) {
        this.visibleInMeasurement = visibleInMeasurement;
    }

    public void setWageAccount(WageAccount wageAccount) {
        this.wageAccount = wageAccount;
    }

    public void setSquadLeader(User squadLeader) {
        this.squadLeader = squadLeader;
    }

    public void setManager(User manager) {
        this.manager = manager;
    }

    @Deprecated
    public void setRole(Role role) {
        this.role = role;
    }

    public void setSettings(Set<UserSetting> settings) {
        this.settings = settings;
    }

    public void setEmployeeContracts(Set<EmployeeContract> employeeContracts) {
        this.employeeContracts = employeeContracts;
    }

    public void setUserBusinessUnits(Set<UserBusinessUnit> userBusinessUnits) {
        this.userBusinessUnits = userBusinessUnits;
    }

    public void setUserCostCenters(Set<UserCostCenter> userCostCenters) {
        this.userCostCenters = userCostCenters;
    }

    public void setUserRoles(Set<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    public void setUserPrivileges(Set<UserPrivilege> userPrivileges) {
        this.userPrivileges = userPrivileges;
    }

    public String toString() {
        return "User(super=" + super.toString() + ", id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", disableDate=" + String.valueOf(this.getDisableDate()) + ", disableAtDate=" + String.valueOf(this.getDisableAtDate()) + ", title=" + this.getTitle() + ", salutation=" + this.getSalutation() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", fullName=" + this.getFullName() + ", shortName=" + this.getShortName() + ", referenceId=" + this.getReferenceId() + ", personalNumber=" + this.getPersonalNumber() + ", socialSecurityNumber=" + this.getSocialSecurityNumber() + ", sequenceNumber=" + this.getSequenceNumber() + ", groupName=" + this.getGroupName() + ", phone=" + this.getPhone() + ", cellular=" + this.getCellular() + ", fax=" + this.getFax() + ", email=" + this.getEmail() + ", location=" + this.getLocation() + ", authorityToSign=" + this.getAuthorityToSign() + ", squadReferenceId=" + this.getSquadReferenceId() + ", squadName=" + this.getSquadName() + ", squadNumber=" + this.getSquadNumber() + ", flagSyncDefault=" + this.isFlagSyncDefault() + ", roleDeprecated=" + String.valueOf(this.getRoleDeprecated()) + ", searchIndexState=" + String.valueOf(this.getSearchIndexState()) + ", allowedToLogin=" + this.getAllowedToLogin() + ", visibleInMeasurement=" + this.getVisibleInMeasurement() + ")";
    }
}

