/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.user;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ERole implements GrantedAuthority
{
    ROLE_NONE("role_none"),
    ROLE_ADMIN("role_admin"),
    ROLE_TECHNICIAN("role_technician"),
    ROLE_SITE_MANAGER("role_site_manager"),
    ROLE_PROJECT_MANAGER("role_project_manager"),
    ROLE_BUSINESS_UNIT_MANAGER("role_business_unit_manager"),
    ROLE_ACCOUNTING("role_accounting"),
    ROLE_REFRESH_TOKEN("role_refresh_token"),
    ROLE_READONLY_API("role_readonly_api"),
    ROLE_DISABLED("role_disabled");

    private static final Logger log;
    private final String value;
    private static final Map<String, ERole> LOOKUP;
    @Nonnull
    public static final Iterable<ERole> REAL_USER_ROLES_VALID;

    private ERole(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static ERole lookup(@NonNull String candidate, @NonNull ERole defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return ERole.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<ERole> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = ERole.key((String)candidate);
        Optional<ERole> value = Optional.ofNullable((ERole)LOOKUP.get(key));
        if (value.isEmpty()) {
            log.warn("ERole for Candidate: {} not found", (Object)candidate);
        }
        return value;
    }

    @Nonnull
    private static String key(@NonNull ERole eRole) {
        if (eRole == null) {
            throw new NullPointerException("eRole is marked non-null but is null");
        }
        return ERole.key((String)eRole.getAuthority());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String getAuthority() {
        return this.name();
    }

    public String getValue() {
        return this.value;
    }

    static {
        log = LogManager.getLogger(ERole.class);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ERole value : ERole.values()) {
            String key = ERole.key((ERole)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        REAL_USER_ROLES_VALID = ImmutableSet.of((Object)ROLE_NONE, (Object)ROLE_ADMIN, (Object)ROLE_TECHNICIAN, (Object)ROLE_SITE_MANAGER, (Object)ROLE_PROJECT_MANAGER, (Object)ROLE_BUSINESS_UNIT_MANAGER, (Object[])new ERole[]{ROLE_ACCOUNTING});
    }
}

