/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.tracking;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ETrackingCategory {
    VIDEO,
    VIDEO_PLAY;

    private static final Map<String, ETrackingCategory> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static ETrackingCategory lookup(@NonNull String candidate, @NonNull ETrackingCategory defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return ETrackingCategory.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<ETrackingCategory> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = ETrackingCategory.key((String)candidate);
        return Optional.ofNullable((ETrackingCategory)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull ETrackingCategory item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return ETrackingCategory.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ETrackingCategory value : ETrackingCategory.values()) {
            String key = ETrackingCategory.key((ETrackingCategory)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

