/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.quotation.EStagePositionSortOption;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.ECommissionType;
import de.qfm.erp.service.model.jpa.quotation.EER2ExportState;
import de.qfm.erp.service.model.jpa.quotation.EInquiryReceiveType;
import de.qfm.erp.service.model.jpa.quotation.EInquiryType;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EQuotationSubmissionType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.QuotationBoQ;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.quotation.StageInvoiceSupplement;
import de.qfm.erp.service.model.jpa.quotation.StageNotifyUser;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.quotation.StageSignatureUser;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;

@Entity(name="Quotation")
@Table(name="QUOTATION")
public class Quotation
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUOTATION_SEQ")
    @SequenceGenerator(sequenceName="QUOTATION_SEQ", allocationSize=1, name="QUOTATION_SEQ")
    private Long id;
    @Convert(converter=NullStringConverter.class)
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Column(name="origin", length=50)
    @Enumerated(value=EnumType.STRING)
    private EStageOrigin origin;
    @Column(name="search_index_state", length=50)
    @Enumerated(value=EnumType.STRING)
    private ESearchIndexState searchIndexState;
    @Convert(converter=NullStringConverter.class)
    @Column(name="quotation_name", length=5)
    private String quotationName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="quotation_number", length=25)
    private String quotationNumber;
    @Column(name="addendum_number")
    private Long addendumNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="q_number", length=50)
    private String qNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="alias", length=250)
    private String alias;
    @Column(name="alias_changed")
    private Boolean aliasChanged;
    @Deprecated
    @Column(name="value_aggregated")
    private BigDecimal valueAggregated;
    @Deprecated
    @Column(name="material_value_aggregated")
    private BigDecimal materialValueAggregated;
    @Deprecated
    @Column(name="wage_value_aggregated")
    private BigDecimal wageValueAggregated;
    @Column(name="order_value")
    private BigDecimal orderValue;
    @Column(name="order_value_with_discount")
    private BigDecimal orderValueWithDiscount;
    @Column(name="order_value_estimate")
    private BigDecimal orderValueEstimate;
    @Column(name="budget_allow_overdraft_percent")
    private BigDecimal budgetAllowedOverdraftPercent;
    @Column(name="budget_allow_overdraft_value")
    private BigDecimal budgetAllowedOverdraftValue;
    @Deprecated
    @Column(name="price_aggregated")
    private BigDecimal priceAggregated;
    @Column(name="material_percentage_min")
    private BigDecimal materialPercentageMin;
    @Column(name="material_percentage_standard")
    private BigDecimal materialPercentageStandard;
    @Deprecated(forRemoval=true)
    @Column(name="wage_factor_min")
    private BigDecimal wageFactorMin;
    @Deprecated(forRemoval=true)
    @Column(name="wage_factor_max")
    private BigDecimal wageFactorMax;
    @Column(name="quotation_date")
    private LocalDate quotationDate;
    @Column(name="quotation_opening_date")
    private LocalDate quotationOpeningDate;
    @Deprecated(forRemoval=true)
    @Column(name="order_date")
    private LocalDate orderDate;
    @Convert(converter=NullStringConverter.class)
    @Column(name="order_number")
    private String orderNumber;
    @Column(name="project_execution_start_date")
    private LocalDate projectExecutionStartDate;
    @Column(name="project_execution_end_date")
    private LocalDate projectExecutionEndDate;
    @Column(name="project_exec_quote_start_date")
    private LocalDate quotationProjectExecutionStartDate;
    @Column(name="project_exec_quote_end_date")
    private LocalDate quotationProjectExecutionEndDate;
    @Convert(converter=NullStringConverter.class)
    @Column(name="accounting_flag", length=12)
    private String accountingFlag;
    @Convert(converter=NullStringConverter.class)
    @Column(name="accounting_text", length=12)
    private String accountingText;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cost_center_internal", length=12)
    private String costCenterInternal;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cost_center_external", length=3)
    private String costCenterExternal;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="customer_id")
    private Customer customer;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="customer_address_id")
    private Address address;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="contact_person_id")
    private ContactPerson contactPerson;
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_email", length=250)
    private String customerEmail;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_short_name", length=5)
    private String customerShortName;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_name_1", length=30)
    private String customerName1;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_name_2", length=30)
    private String customerName2;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_street", length=30)
    private String customerStreet;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_street_no", length=10)
    private String customerStreetNo;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_zip_code", length=5)
    private String customerZipCode;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_city", length=30)
    private String customerCity;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="customer_invoice_id")
    private Customer customerInvoice;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="customer_invoice_address_id")
    private Address customerInvoiceAddress;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_invoice_short_name", length=5)
    private String customerInvoiceShortName;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_invoice_name_1", length=30)
    private String customerInvoiceName1;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_invoice_name_2", length=30)
    private String customerInvoiceName2;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_invoice_street", length=30)
    private String customerInvoiceStreet;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_invoice_street_no", length=10)
    private String customerInvoiceStreetNo;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_invoice_zip_code", length=5)
    private String customerInvoiceZipCode;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="customer_invoice_city", length=30)
    private String customerInvoiceCity;
    @Column(name="headline_group_1_set")
    private Boolean headlineG1Set;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_1", length=20)
    private String headlineG1;
    @Column(name="headline_group_1_length")
    private Integer headlineG1Length;
    @Column(name="headline_group_1_is_numeric")
    private Boolean headlineG1IsNumeric;
    @Column(name="headline_group_1_align")
    private String headlineG1Align;
    @Column(name="headline_group_2_set")
    private Boolean headlineG2Set;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_2", length=20)
    private String headlineG2;
    @Column(name="headline_group_2_length")
    private Integer headlineG2Length;
    @Column(name="headline_group_2_is_numeric")
    private Boolean headlineG2IsNumeric;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_2_align")
    private String headlineG2Align;
    @Column(name="headline_group_3_set")
    private Boolean headlineG3Set;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_3", length=20)
    private String headlineG3;
    @Column(name="headline_group_3_length")
    private Integer headlineG3Length;
    @Column(name="headline_group_3_is_numeric")
    private Boolean headlineG3IsNumeric;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_3_align")
    private String headlineG3Align;
    @Column(name="headline_group_4_set")
    private Boolean headlineG4Set;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_4", length=20)
    private String headlineG4;
    @Column(name="headline_group_4_length")
    private Integer headlineG4Length;
    @Column(name="headline_group_4_is_numeric")
    private Boolean headlineG4IsNumeric;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_4_align")
    private String headlineG4Align;
    @Column(name="headline_group_5_set")
    private Boolean headlineG5Set;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_5", length=20)
    private String headlineG5;
    @Column(name="headline_group_5_length")
    private Integer headlineG5Length;
    @Column(name="headline_group_5_is_numeric")
    private Boolean headlineG5IsNumeric;
    @Convert(converter=NullStringConverter.class)
    @Column(name="headline_group_5_align")
    private String headlineG5Align;
    @Column(name="item_format_1_set")
    private Boolean itemFormatG1Set;
    @Convert(converter=NullStringConverter.class)
    @Column(name="item_format_1", length=20)
    private String itemFormatG1;
    @Column(name="item_format_1_length")
    private Integer itemFormatG1Length;
    @Column(name="item_format_1_is_numeric")
    private Boolean itemFormatG1IsNumeric;
    @Column(name="item_format_1_align")
    private String itemFormatG1Align;
    @Column(name="item_format_2_set")
    private Boolean itemFormatG2Set;
    @Convert(converter=NullStringConverter.class)
    @Column(name="item_format_2", length=20)
    private String itemFormatG2;
    @Column(name="item_format_2_length")
    private Integer itemFormatG2Length;
    @Column(name="item_format_2_is_numeric")
    private Boolean itemFormatG2IsNumeric;
    @Convert(converter=NullStringConverter.class)
    @Column(name="item_format_2_align")
    private String itemFormatG2Align;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_project_label")
    private String x83ProjectLabel;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_project_name")
    private String x83ProjectName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_project_currency")
    private String x83ProjectCurrency;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_project_currency_label")
    private String x83ProjectCurrencyLabel;
    @Column(name="x83_boq_info_date")
    private LocalDate x83BoqInfoDate;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_boq_name")
    private String x83BoqName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_boq_label")
    private String x83BoqLabel;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_boq_award_currency")
    private String x83BoqAwardCurrency;
    @Convert(converter=NullStringConverter.class)
    @Column(name="x83_boq_award_currency_label")
    private String x83BoqAwardCurrencyLabel;
    @Deprecated(forRemoval=true)
    @Column(name="flag_constant_company_wage")
    private Boolean flagConstantCompanyWage;
    @Deprecated(forRemoval=true)
    @Column(name="flag_order_end")
    private Boolean flagOrderEnd;
    @Column(name="flag_order_equals_quotation")
    private Boolean flagOrderEqualsQuotation;
    @Deprecated(forRemoval=true)
    @Column(name="flag_squad_creat_rel_ord_allow")
    private Boolean flagSquadIsAllowedToCreateReleaseOrder;
    @Column(name="flag_measure_wo_comm_num_allow")
    private Boolean flagMeasurementWithoutCommissionNumberAllowed;
    @Deprecated(forRemoval=true)
    @Column(name="flag_release_order_num_must")
    private Boolean flagReleaseOrderOrderNumberMandatory;
    @Deprecated(forRemoval=true)
    @Column(name="flag_auto_wage_assign_allow")
    private Boolean flagAutomaticWageAssignmentAllowed;
    @Column(name="flag_discount_fee_positions")
    private Boolean flagDiscountFeePositions;
    @Enumerated(value=EnumType.STRING)
    @Column(name="pdf_extractor_type")
    private EPdfExtractType pdfExtractType;
    @Column(name="flag_b2b")
    private Boolean flagB2B;
    @Column(name="flag_position_grid_locked")
    private Boolean flagPositionGridLocked;
    @Column(name="flag_budget_relevant")
    private Boolean flagBudgetRelevant;
    @Column(name="flag_cross_version_order_value")
    private Boolean flagCrossVersionOrderValue;
    @Column(name="budget")
    private BigDecimal budget;
    @Deprecated(forRemoval=true)
    @Convert(converter=NullStringConverter.class)
    @Column(name="order_description", length=50)
    private String orderDescription;
    @Convert(converter=NullStringConverter.class)
    @Column(name="order_description_customer", length=250)
    private String orderDescriptionCustomer;
    @Convert(converter=NullStringConverter.class)
    @Column(name="order_description_internal", length=250)
    private String orderDescriptionInternal;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="contact_person", length=30)
    private String contactPersonOld;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="agent_id")
    private Customer agent;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="agent_address_id")
    private Address agentAddress;
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_short_name", length=5)
    private String agentShortName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_name_1", length=30)
    private String agentName1;
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_name_2", length=30)
    private String agentName2;
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_street", length=30)
    private String agentStreet;
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_street_no", length=10)
    private String agentStreetNo;
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_zip_code", length=5)
    private String agentZipCode;
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_city", length=30)
    private String agentCity;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="agent_invoice_id")
    private Customer agentInvoice;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="agent_invoice_address_id")
    private Address agentInvoiceAddress;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_invoice_short_name", length=5)
    private String agentInvoiceShortName;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_invoice_name_1", length=30)
    private String agentInvoiceName1;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_invoice_name_2", length=30)
    private String agentInvoiceName2;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_invoice_street", length=30)
    private String agentInvoiceStreet;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_invoice_street_no", length=10)
    private String agentInvoiceStreetNo;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_invoice_zip_code", length=5)
    private String agentInvoiceZipCode;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="agent_invoice_city", length=30)
    private String agentInvoiceCity;
    @Deprecated(forRemoval=true)
    @Convert(converter=NullStringConverter.class)
    @Column(name="finance_company_number", length=10)
    private String financeCompanyNumber;
    @Deprecated(forRemoval=true)
    @Convert(converter=NullStringConverter.class)
    @Column(name="finance_accounting_text", length=30)
    private String financeAccountingText;
    @Column(name="finance_time_for_payment")
    private Integer financeTimeForPayment;
    @Column(name="finance_cash_discount_time_1")
    private Integer financeCashDiscountTime1;
    @Column(name="finance_cash_discount_1")
    private BigDecimal financeCashDiscount1;
    @Column(name="finance_cash_discount_time_2")
    private Integer financeCashDiscountTime2;
    @Column(name="finance_cash_discount_2")
    private BigDecimal financeCashDiscount2;
    @Convert(converter=NullStringConverter.class)
    @Column(name="finance_debtor_account_number", length=12)
    private String financeDebtorAccountNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="finance_tax_key", length=12)
    private String financeTaxKeyValue;
    @Convert(converter=NullStringConverter.class)
    @Column(name="finance_account", length=12)
    private String financeAccount;
    @Column(name="finance_cost_unit")
    private Integer financeCostUnit;
    @Column(name="vat_percent")
    private BigDecimal vatPercent;
    @Column(name="finance_default_invoice_type")
    @Enumerated(value=EnumType.STRING)
    private EInvoiceType financeDefaultInvoiceType;
    @Column(name="finance_flag_subcontractor")
    private Boolean financeFlagSubcontractor;
    @Column(name="finance_routing_reference_id", length=100)
    private String financeRoutingReferenceId;
    @Column(name="general_discount")
    private BigDecimal generalDiscount;
    @Column(name="other_discount")
    private BigDecimal otherDiscount;
    @JoinColumn(name="finance_tax_key_id")
    @ManyToOne
    private TaxKey financeTaxKey;
    @JoinColumn(name="last_quotation_boq_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private QuotationBoQ lastQuotationBoQ;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation", cascade={CascadeType.ALL})
    private Set<QuotationBoQ> quotationBoQs;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation", cascade={CascadeType.ALL})
    private Set<QuotationPosition> quotationPositions;
    @Enumerated(value=EnumType.STRING)
    @Column(name="stage_type")
    private EQStageType stageType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="stage_state")
    private EQStageState stageState;
    @Column(name="stage_state_on")
    private LocalDateTime stageStateSince;
    @Convert(converter=NullStringConverter.class)
    @Column(name="archive_reason", length=250)
    private String archiveReason;
    @Enumerated(value=EnumType.STRING)
    @Column(name="stage_position_sort_option", length=50)
    private EStagePositionSortOption stagePositionSortOption;
    @Column(name="version")
    private Integer version;
    @Column(name="version_since")
    private LocalDateTime versionSince;
    @Column(name="wage_percentage_min")
    private BigDecimal wagePercentageMin;
    @Column(name="wage_percentage_standard")
    private BigDecimal wagePercentageStandard;
    @Column(name="warranty_sec_ret_percent")
    private BigDecimal warrantySecurityRetentionPercent;
    @Column(name="fulfillment_sec_ret_percent")
    private BigDecimal fulfillmentSecurityRetentionPercent;
    @Column(name="inquiry_date")
    private LocalDate inquiryDate;
    @Convert(converter=NullStringConverter.class)
    @Column(name="procurement_number", length=50)
    private String procurementNumber;
    @Column(name="submission_date_time")
    private LocalDateTime submissionDateTime;
    @Column(name="flag_wo_submission_deadline")
    private Boolean flagWithoutSubmissionDeadline;
    @Column(name="planned_submission_date")
    private LocalDate plannedSubmissionDate;
    @Column(name="submission_of_bid_date")
    private LocalDate submissionOfBidDate;
    @Column(name="placement_of_order_duty_date")
    private LocalDate placementOfOrderDutyDate;
    @Column(name="binding_period_date")
    private LocalDate bindingPeriodDate;
    @Column(name="commission_date")
    private LocalDate commissionDate;
    @Column(name="grace_period_date")
    private LocalDate gracePeriodDate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="commission_type")
    private ECommissionType commissionType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="inquiry_type")
    private EInquiryType inquiryType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="inquiry_receive_type")
    private EInquiryReceiveType inquiryReceiveType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="quotation_submission_type")
    private EQuotationSubmissionType quotationSubmissionType;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cover_letter_subject_1", length=250)
    private String coverLetterSubject1st;
    @Column(name="cover_letter_subject_1_changed")
    private Boolean coverLetterSubject1stChanged;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cover_letter_subject_2", length=250)
    private String coverLetterSubject2nd;
    @Column(name="cover_letter_subject_2_changed")
    private Boolean coverLetterSubject2ndChanged;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cover_letter_title", length=250)
    private String coverLetterTitle;
    @Column(name="cover_letter_title_changed")
    private Boolean coverLetterTitleChanged;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cover_letter_body_1", length=2000)
    private String coverLetterBody1;
    @Column(name="cover_letter_body_1_changed")
    private Boolean coverLetterBody1Changed;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cover_letter_body_2", length=2000)
    private String coverLetterBody2;
    @Column(name="cover_letter_body_2_changed")
    private Boolean coverLetterBody2Changed;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cover_letter_body_3", length=2000)
    private String coverLetterBody3;
    @Column(name="cover_letter_body_3_changed")
    private Boolean coverLetterBody3Changed;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks", length=4000)
    private String remarks;
    @Column(name="price_without_discount_sum")
    private BigDecimal priceWithoutDiscountSum;
    @Column(name="price_with_discount_sum")
    private BigDecimal priceWithDiscountSum;
    @Column(name="squad_wage_sum")
    private BigDecimal squadWageSum;
    @Column(name="company_wage_sum")
    private BigDecimal companyWageSum;
    @Column(name="material_purchase_price_sum")
    private BigDecimal materialPurchasePriceSum;
    @Column(name="material_selling_price_sum")
    private BigDecimal materialSellingPriceSum;
    @Column(name="ext_service_purchase_price_sum")
    private BigDecimal externalServicePurchasePriceSum;
    @Column(name="ext_service_selling_price_sum")
    private BigDecimal externalServiceSellingPriceSum;
    @Column(name="wage_percent_w_avg")
    private BigDecimal wagePercentageWeightedAverage;
    @Column(name="material_percent_w_avg")
    private BigDecimal materialPercentageWeightedAverage;
    @Column(name="ext_service_percent_w_avg")
    private BigDecimal externalServicePercentageWeightedAverage;
    @Column(name="vat_value_without_discount_sum")
    private BigDecimal vatValueWithoutDiscountSum;
    @Column(name="vat_value_with_discount_sum")
    private BigDecimal vatValueWithDiscountSum;
    @Column(name="price_gross_wo_discount_sum")
    private BigDecimal priceGrossWithoutDiscountSum;
    @Column(name="price_gross_w_discount_sum")
    private BigDecimal priceGrossWithDiscountSum;
    @Column(name="stage_notify_users_text")
    private String stageNotifyUsersText;
    @Column(name="stage_responsible_users_text")
    private String stageResponsibleUsersText;
    @Column(name="stage_signature_users_text")
    private String stageSignatureUsersText;
    @Enumerated(value=EnumType.STRING)
    @Column(name="er2_export_state")
    private EER2ExportState er2ExportState;
    @Column(name="er2_exported_on")
    private LocalDateTime er2ExportedOn;
    @Column(name="er2_exported_to_path")
    private String er2ExportedToPath;
    @JoinColumn(name="sub_project_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private SubProject subProject;
    @JoinColumn(name="q_entity_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private QEntity qEntity;
    @JoinColumn(name="reference_quotation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Quotation reference;
    @JoinColumn(name="parent_quotation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Quotation parent;
    @JoinColumn(name="last_invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Invoice lastInvoice;
    @JoinColumn(name="final_invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Invoice finalInvoice;
    @JoinColumn(name="project_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private Project project;
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY)
    private Set<Quotation> children;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation", cascade={CascadeType.ALL})
    private Set<StageNotifyUser> stageNotifyUsers;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation", cascade={CascadeType.ALL})
    private Set<StageResponsibleUser> stageResponsibleUsers;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation", cascade={CascadeType.ALL})
    private Set<StageSignatureUser> stageSignatureUsers;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation")
    private Set<Invoice> invoices;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation")
    private Set<Measurement> measurements;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="quotation", cascade={CascadeType.ALL})
    private Set<StageInvoiceSupplement> stageInvoiceSupplements;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        Quotation quotation = (Quotation)o;
        return this.id != null && Objects.equals(this.id, quotation.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public EStageOrigin getOrigin() {
        return this.origin;
    }

    public ESearchIndexState getSearchIndexState() {
        return this.searchIndexState;
    }

    public String getQuotationName() {
        return this.quotationName;
    }

    public String getQuotationNumber() {
        return this.quotationNumber;
    }

    public Long getAddendumNumber() {
        return this.addendumNumber;
    }

    public String getQNumber() {
        return this.qNumber;
    }

    public String getAlias() {
        return this.alias;
    }

    public Boolean getAliasChanged() {
        return this.aliasChanged;
    }

    @Deprecated
    public BigDecimal getValueAggregated() {
        return this.valueAggregated;
    }

    @Deprecated
    public BigDecimal getMaterialValueAggregated() {
        return this.materialValueAggregated;
    }

    @Deprecated
    public BigDecimal getWageValueAggregated() {
        return this.wageValueAggregated;
    }

    public BigDecimal getOrderValue() {
        return this.orderValue;
    }

    public BigDecimal getOrderValueWithDiscount() {
        return this.orderValueWithDiscount;
    }

    public BigDecimal getOrderValueEstimate() {
        return this.orderValueEstimate;
    }

    public BigDecimal getBudgetAllowedOverdraftPercent() {
        return this.budgetAllowedOverdraftPercent;
    }

    public BigDecimal getBudgetAllowedOverdraftValue() {
        return this.budgetAllowedOverdraftValue;
    }

    @Deprecated
    public BigDecimal getPriceAggregated() {
        return this.priceAggregated;
    }

    public BigDecimal getMaterialPercentageMin() {
        return this.materialPercentageMin;
    }

    public BigDecimal getMaterialPercentageStandard() {
        return this.materialPercentageStandard;
    }

    @Deprecated
    public BigDecimal getWageFactorMin() {
        return this.wageFactorMin;
    }

    @Deprecated
    public BigDecimal getWageFactorMax() {
        return this.wageFactorMax;
    }

    public LocalDate getQuotationDate() {
        return this.quotationDate;
    }

    public LocalDate getQuotationOpeningDate() {
        return this.quotationOpeningDate;
    }

    @Deprecated
    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public LocalDate getProjectExecutionStartDate() {
        return this.projectExecutionStartDate;
    }

    public LocalDate getProjectExecutionEndDate() {
        return this.projectExecutionEndDate;
    }

    public LocalDate getQuotationProjectExecutionStartDate() {
        return this.quotationProjectExecutionStartDate;
    }

    public LocalDate getQuotationProjectExecutionEndDate() {
        return this.quotationProjectExecutionEndDate;
    }

    public String getAccountingFlag() {
        return this.accountingFlag;
    }

    public String getAccountingText() {
        return this.accountingText;
    }

    public String getCostCenterInternal() {
        return this.costCenterInternal;
    }

    public String getCostCenterExternal() {
        return this.costCenterExternal;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Address getAddress() {
        return this.address;
    }

    public ContactPerson getContactPerson() {
        return this.contactPerson;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Deprecated
    public String getCustomerShortName() {
        return this.customerShortName;
    }

    @Deprecated
    public String getCustomerName1() {
        return this.customerName1;
    }

    @Deprecated
    public String getCustomerName2() {
        return this.customerName2;
    }

    @Deprecated
    public String getCustomerStreet() {
        return this.customerStreet;
    }

    @Deprecated
    public String getCustomerStreetNo() {
        return this.customerStreetNo;
    }

    @Deprecated
    public String getCustomerZipCode() {
        return this.customerZipCode;
    }

    @Deprecated
    public String getCustomerCity() {
        return this.customerCity;
    }

    public Customer getCustomerInvoice() {
        return this.customerInvoice;
    }

    public Address getCustomerInvoiceAddress() {
        return this.customerInvoiceAddress;
    }

    @Deprecated
    public String getCustomerInvoiceShortName() {
        return this.customerInvoiceShortName;
    }

    @Deprecated
    public String getCustomerInvoiceName1() {
        return this.customerInvoiceName1;
    }

    @Deprecated
    public String getCustomerInvoiceName2() {
        return this.customerInvoiceName2;
    }

    @Deprecated
    public String getCustomerInvoiceStreet() {
        return this.customerInvoiceStreet;
    }

    @Deprecated
    public String getCustomerInvoiceStreetNo() {
        return this.customerInvoiceStreetNo;
    }

    @Deprecated
    public String getCustomerInvoiceZipCode() {
        return this.customerInvoiceZipCode;
    }

    @Deprecated
    public String getCustomerInvoiceCity() {
        return this.customerInvoiceCity;
    }

    public Boolean getHeadlineG1Set() {
        return this.headlineG1Set;
    }

    public String getHeadlineG1() {
        return this.headlineG1;
    }

    public Integer getHeadlineG1Length() {
        return this.headlineG1Length;
    }

    public Boolean getHeadlineG1IsNumeric() {
        return this.headlineG1IsNumeric;
    }

    public String getHeadlineG1Align() {
        return this.headlineG1Align;
    }

    public Boolean getHeadlineG2Set() {
        return this.headlineG2Set;
    }

    public String getHeadlineG2() {
        return this.headlineG2;
    }

    public Integer getHeadlineG2Length() {
        return this.headlineG2Length;
    }

    public Boolean getHeadlineG2IsNumeric() {
        return this.headlineG2IsNumeric;
    }

    public String getHeadlineG2Align() {
        return this.headlineG2Align;
    }

    public Boolean getHeadlineG3Set() {
        return this.headlineG3Set;
    }

    public String getHeadlineG3() {
        return this.headlineG3;
    }

    public Integer getHeadlineG3Length() {
        return this.headlineG3Length;
    }

    public Boolean getHeadlineG3IsNumeric() {
        return this.headlineG3IsNumeric;
    }

    public String getHeadlineG3Align() {
        return this.headlineG3Align;
    }

    public Boolean getHeadlineG4Set() {
        return this.headlineG4Set;
    }

    public String getHeadlineG4() {
        return this.headlineG4;
    }

    public Integer getHeadlineG4Length() {
        return this.headlineG4Length;
    }

    public Boolean getHeadlineG4IsNumeric() {
        return this.headlineG4IsNumeric;
    }

    public String getHeadlineG4Align() {
        return this.headlineG4Align;
    }

    public Boolean getHeadlineG5Set() {
        return this.headlineG5Set;
    }

    public String getHeadlineG5() {
        return this.headlineG5;
    }

    public Integer getHeadlineG5Length() {
        return this.headlineG5Length;
    }

    public Boolean getHeadlineG5IsNumeric() {
        return this.headlineG5IsNumeric;
    }

    public String getHeadlineG5Align() {
        return this.headlineG5Align;
    }

    public Boolean getItemFormatG1Set() {
        return this.itemFormatG1Set;
    }

    public String getItemFormatG1() {
        return this.itemFormatG1;
    }

    public Integer getItemFormatG1Length() {
        return this.itemFormatG1Length;
    }

    public Boolean getItemFormatG1IsNumeric() {
        return this.itemFormatG1IsNumeric;
    }

    public String getItemFormatG1Align() {
        return this.itemFormatG1Align;
    }

    public Boolean getItemFormatG2Set() {
        return this.itemFormatG2Set;
    }

    public String getItemFormatG2() {
        return this.itemFormatG2;
    }

    public Integer getItemFormatG2Length() {
        return this.itemFormatG2Length;
    }

    public Boolean getItemFormatG2IsNumeric() {
        return this.itemFormatG2IsNumeric;
    }

    public String getItemFormatG2Align() {
        return this.itemFormatG2Align;
    }

    public String getX83ProjectLabel() {
        return this.x83ProjectLabel;
    }

    public String getX83ProjectName() {
        return this.x83ProjectName;
    }

    public String getX83ProjectCurrency() {
        return this.x83ProjectCurrency;
    }

    public String getX83ProjectCurrencyLabel() {
        return this.x83ProjectCurrencyLabel;
    }

    public LocalDate getX83BoqInfoDate() {
        return this.x83BoqInfoDate;
    }

    public String getX83BoqName() {
        return this.x83BoqName;
    }

    public String getX83BoqLabel() {
        return this.x83BoqLabel;
    }

    public String getX83BoqAwardCurrency() {
        return this.x83BoqAwardCurrency;
    }

    public String getX83BoqAwardCurrencyLabel() {
        return this.x83BoqAwardCurrencyLabel;
    }

    @Deprecated
    public Boolean getFlagConstantCompanyWage() {
        return this.flagConstantCompanyWage;
    }

    @Deprecated
    public Boolean getFlagOrderEnd() {
        return this.flagOrderEnd;
    }

    public Boolean getFlagOrderEqualsQuotation() {
        return this.flagOrderEqualsQuotation;
    }

    @Deprecated
    public Boolean getFlagSquadIsAllowedToCreateReleaseOrder() {
        return this.flagSquadIsAllowedToCreateReleaseOrder;
    }

    public Boolean getFlagMeasurementWithoutCommissionNumberAllowed() {
        return this.flagMeasurementWithoutCommissionNumberAllowed;
    }

    @Deprecated
    public Boolean getFlagReleaseOrderOrderNumberMandatory() {
        return this.flagReleaseOrderOrderNumberMandatory;
    }

    @Deprecated
    public Boolean getFlagAutomaticWageAssignmentAllowed() {
        return this.flagAutomaticWageAssignmentAllowed;
    }

    public Boolean getFlagDiscountFeePositions() {
        return this.flagDiscountFeePositions;
    }

    public EPdfExtractType getPdfExtractType() {
        return this.pdfExtractType;
    }

    public Boolean getFlagB2B() {
        return this.flagB2B;
    }

    public Boolean getFlagPositionGridLocked() {
        return this.flagPositionGridLocked;
    }

    public Boolean getFlagBudgetRelevant() {
        return this.flagBudgetRelevant;
    }

    public Boolean getFlagCrossVersionOrderValue() {
        return this.flagCrossVersionOrderValue;
    }

    public BigDecimal getBudget() {
        return this.budget;
    }

    @Deprecated
    public String getOrderDescription() {
        return this.orderDescription;
    }

    public String getOrderDescriptionCustomer() {
        return this.orderDescriptionCustomer;
    }

    public String getOrderDescriptionInternal() {
        return this.orderDescriptionInternal;
    }

    @Deprecated
    public String getContactPersonOld() {
        return this.contactPersonOld;
    }

    public Customer getAgent() {
        return this.agent;
    }

    public Address getAgentAddress() {
        return this.agentAddress;
    }

    public String getAgentShortName() {
        return this.agentShortName;
    }

    public String getAgentName1() {
        return this.agentName1;
    }

    public String getAgentName2() {
        return this.agentName2;
    }

    public String getAgentStreet() {
        return this.agentStreet;
    }

    public String getAgentStreetNo() {
        return this.agentStreetNo;
    }

    public String getAgentZipCode() {
        return this.agentZipCode;
    }

    public String getAgentCity() {
        return this.agentCity;
    }

    public Customer getAgentInvoice() {
        return this.agentInvoice;
    }

    public Address getAgentInvoiceAddress() {
        return this.agentInvoiceAddress;
    }

    @Deprecated
    public String getAgentInvoiceShortName() {
        return this.agentInvoiceShortName;
    }

    @Deprecated
    public String getAgentInvoiceName1() {
        return this.agentInvoiceName1;
    }

    @Deprecated
    public String getAgentInvoiceName2() {
        return this.agentInvoiceName2;
    }

    @Deprecated
    public String getAgentInvoiceStreet() {
        return this.agentInvoiceStreet;
    }

    @Deprecated
    public String getAgentInvoiceStreetNo() {
        return this.agentInvoiceStreetNo;
    }

    @Deprecated
    public String getAgentInvoiceZipCode() {
        return this.agentInvoiceZipCode;
    }

    @Deprecated
    public String getAgentInvoiceCity() {
        return this.agentInvoiceCity;
    }

    @Deprecated
    public String getFinanceCompanyNumber() {
        return this.financeCompanyNumber;
    }

    @Deprecated
    public String getFinanceAccountingText() {
        return this.financeAccountingText;
    }

    public Integer getFinanceTimeForPayment() {
        return this.financeTimeForPayment;
    }

    public Integer getFinanceCashDiscountTime1() {
        return this.financeCashDiscountTime1;
    }

    public BigDecimal getFinanceCashDiscount1() {
        return this.financeCashDiscount1;
    }

    public Integer getFinanceCashDiscountTime2() {
        return this.financeCashDiscountTime2;
    }

    public BigDecimal getFinanceCashDiscount2() {
        return this.financeCashDiscount2;
    }

    public String getFinanceDebtorAccountNumber() {
        return this.financeDebtorAccountNumber;
    }

    public String getFinanceTaxKeyValue() {
        return this.financeTaxKeyValue;
    }

    public String getFinanceAccount() {
        return this.financeAccount;
    }

    public Integer getFinanceCostUnit() {
        return this.financeCostUnit;
    }

    public BigDecimal getVatPercent() {
        return this.vatPercent;
    }

    public EInvoiceType getFinanceDefaultInvoiceType() {
        return this.financeDefaultInvoiceType;
    }

    public Boolean getFinanceFlagSubcontractor() {
        return this.financeFlagSubcontractor;
    }

    public String getFinanceRoutingReferenceId() {
        return this.financeRoutingReferenceId;
    }

    public BigDecimal getGeneralDiscount() {
        return this.generalDiscount;
    }

    public BigDecimal getOtherDiscount() {
        return this.otherDiscount;
    }

    public TaxKey getFinanceTaxKey() {
        return this.financeTaxKey;
    }

    public QuotationBoQ getLastQuotationBoQ() {
        return this.lastQuotationBoQ;
    }

    public Set<QuotationBoQ> getQuotationBoQs() {
        return this.quotationBoQs;
    }

    public Set<QuotationPosition> getQuotationPositions() {
        return this.quotationPositions;
    }

    public EQStageType getStageType() {
        return this.stageType;
    }

    public EQStageState getStageState() {
        return this.stageState;
    }

    public LocalDateTime getStageStateSince() {
        return this.stageStateSince;
    }

    public String getArchiveReason() {
        return this.archiveReason;
    }

    public EStagePositionSortOption getStagePositionSortOption() {
        return this.stagePositionSortOption;
    }

    public Integer getVersion() {
        return this.version;
    }

    public LocalDateTime getVersionSince() {
        return this.versionSince;
    }

    public BigDecimal getWagePercentageMin() {
        return this.wagePercentageMin;
    }

    public BigDecimal getWagePercentageStandard() {
        return this.wagePercentageStandard;
    }

    public BigDecimal getWarrantySecurityRetentionPercent() {
        return this.warrantySecurityRetentionPercent;
    }

    public BigDecimal getFulfillmentSecurityRetentionPercent() {
        return this.fulfillmentSecurityRetentionPercent;
    }

    public LocalDate getInquiryDate() {
        return this.inquiryDate;
    }

    public String getProcurementNumber() {
        return this.procurementNumber;
    }

    public LocalDateTime getSubmissionDateTime() {
        return this.submissionDateTime;
    }

    public Boolean getFlagWithoutSubmissionDeadline() {
        return this.flagWithoutSubmissionDeadline;
    }

    public LocalDate getPlannedSubmissionDate() {
        return this.plannedSubmissionDate;
    }

    public LocalDate getSubmissionOfBidDate() {
        return this.submissionOfBidDate;
    }

    public LocalDate getPlacementOfOrderDutyDate() {
        return this.placementOfOrderDutyDate;
    }

    public LocalDate getBindingPeriodDate() {
        return this.bindingPeriodDate;
    }

    public LocalDate getCommissionDate() {
        return this.commissionDate;
    }

    public LocalDate getGracePeriodDate() {
        return this.gracePeriodDate;
    }

    public ECommissionType getCommissionType() {
        return this.commissionType;
    }

    public EInquiryType getInquiryType() {
        return this.inquiryType;
    }

    public EInquiryReceiveType getInquiryReceiveType() {
        return this.inquiryReceiveType;
    }

    public EQuotationSubmissionType getQuotationSubmissionType() {
        return this.quotationSubmissionType;
    }

    public String getCoverLetterSubject1st() {
        return this.coverLetterSubject1st;
    }

    public Boolean getCoverLetterSubject1stChanged() {
        return this.coverLetterSubject1stChanged;
    }

    public String getCoverLetterSubject2nd() {
        return this.coverLetterSubject2nd;
    }

    public Boolean getCoverLetterSubject2ndChanged() {
        return this.coverLetterSubject2ndChanged;
    }

    public String getCoverLetterTitle() {
        return this.coverLetterTitle;
    }

    public Boolean getCoverLetterTitleChanged() {
        return this.coverLetterTitleChanged;
    }

    public String getCoverLetterBody1() {
        return this.coverLetterBody1;
    }

    public Boolean getCoverLetterBody1Changed() {
        return this.coverLetterBody1Changed;
    }

    public String getCoverLetterBody2() {
        return this.coverLetterBody2;
    }

    public Boolean getCoverLetterBody2Changed() {
        return this.coverLetterBody2Changed;
    }

    public String getCoverLetterBody3() {
        return this.coverLetterBody3;
    }

    public Boolean getCoverLetterBody3Changed() {
        return this.coverLetterBody3Changed;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public BigDecimal getPriceWithoutDiscountSum() {
        return this.priceWithoutDiscountSum;
    }

    public BigDecimal getPriceWithDiscountSum() {
        return this.priceWithDiscountSum;
    }

    public BigDecimal getSquadWageSum() {
        return this.squadWageSum;
    }

    public BigDecimal getCompanyWageSum() {
        return this.companyWageSum;
    }

    public BigDecimal getMaterialPurchasePriceSum() {
        return this.materialPurchasePriceSum;
    }

    public BigDecimal getMaterialSellingPriceSum() {
        return this.materialSellingPriceSum;
    }

    public BigDecimal getExternalServicePurchasePriceSum() {
        return this.externalServicePurchasePriceSum;
    }

    public BigDecimal getExternalServiceSellingPriceSum() {
        return this.externalServiceSellingPriceSum;
    }

    public BigDecimal getWagePercentageWeightedAverage() {
        return this.wagePercentageWeightedAverage;
    }

    public BigDecimal getMaterialPercentageWeightedAverage() {
        return this.materialPercentageWeightedAverage;
    }

    public BigDecimal getExternalServicePercentageWeightedAverage() {
        return this.externalServicePercentageWeightedAverage;
    }

    public BigDecimal getVatValueWithoutDiscountSum() {
        return this.vatValueWithoutDiscountSum;
    }

    public BigDecimal getVatValueWithDiscountSum() {
        return this.vatValueWithDiscountSum;
    }

    public BigDecimal getPriceGrossWithoutDiscountSum() {
        return this.priceGrossWithoutDiscountSum;
    }

    public BigDecimal getPriceGrossWithDiscountSum() {
        return this.priceGrossWithDiscountSum;
    }

    public String getStageNotifyUsersText() {
        return this.stageNotifyUsersText;
    }

    public String getStageResponsibleUsersText() {
        return this.stageResponsibleUsersText;
    }

    public String getStageSignatureUsersText() {
        return this.stageSignatureUsersText;
    }

    public EER2ExportState getEr2ExportState() {
        return this.er2ExportState;
    }

    public LocalDateTime getEr2ExportedOn() {
        return this.er2ExportedOn;
    }

    public String getEr2ExportedToPath() {
        return this.er2ExportedToPath;
    }

    public SubProject getSubProject() {
        return this.subProject;
    }

    public QEntity getQEntity() {
        return this.qEntity;
    }

    public Quotation getReference() {
        return this.reference;
    }

    public Quotation getParent() {
        return this.parent;
    }

    public Invoice getLastInvoice() {
        return this.lastInvoice;
    }

    public Invoice getFinalInvoice() {
        return this.finalInvoice;
    }

    public Project getProject() {
        return this.project;
    }

    public Set<Quotation> getChildren() {
        return this.children;
    }

    public Set<StageNotifyUser> getStageNotifyUsers() {
        return this.stageNotifyUsers;
    }

    public Set<StageResponsibleUser> getStageResponsibleUsers() {
        return this.stageResponsibleUsers;
    }

    public Set<StageSignatureUser> getStageSignatureUsers() {
        return this.stageSignatureUsers;
    }

    public Set<Invoice> getInvoices() {
        return this.invoices;
    }

    public Set<Measurement> getMeasurements() {
        return this.measurements;
    }

    public Set<StageInvoiceSupplement> getStageInvoiceSupplements() {
        return this.stageInvoiceSupplements;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setOrigin(EStageOrigin origin) {
        this.origin = origin;
    }

    public void setSearchIndexState(ESearchIndexState searchIndexState) {
        this.searchIndexState = searchIndexState;
    }

    public void setQuotationName(String quotationName) {
        this.quotationName = quotationName;
    }

    public void setQuotationNumber(String quotationNumber) {
        this.quotationNumber = quotationNumber;
    }

    public void setAddendumNumber(Long addendumNumber) {
        this.addendumNumber = addendumNumber;
    }

    public void setQNumber(String qNumber) {
        this.qNumber = qNumber;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAliasChanged(Boolean aliasChanged) {
        this.aliasChanged = aliasChanged;
    }

    @Deprecated
    public void setValueAggregated(BigDecimal valueAggregated) {
        this.valueAggregated = valueAggregated;
    }

    @Deprecated
    public void setMaterialValueAggregated(BigDecimal materialValueAggregated) {
        this.materialValueAggregated = materialValueAggregated;
    }

    @Deprecated
    public void setWageValueAggregated(BigDecimal wageValueAggregated) {
        this.wageValueAggregated = wageValueAggregated;
    }

    public void setOrderValue(BigDecimal orderValue) {
        this.orderValue = orderValue;
    }

    public void setOrderValueWithDiscount(BigDecimal orderValueWithDiscount) {
        this.orderValueWithDiscount = orderValueWithDiscount;
    }

    public void setOrderValueEstimate(BigDecimal orderValueEstimate) {
        this.orderValueEstimate = orderValueEstimate;
    }

    public void setBudgetAllowedOverdraftPercent(BigDecimal budgetAllowedOverdraftPercent) {
        this.budgetAllowedOverdraftPercent = budgetAllowedOverdraftPercent;
    }

    public void setBudgetAllowedOverdraftValue(BigDecimal budgetAllowedOverdraftValue) {
        this.budgetAllowedOverdraftValue = budgetAllowedOverdraftValue;
    }

    @Deprecated
    public void setPriceAggregated(BigDecimal priceAggregated) {
        this.priceAggregated = priceAggregated;
    }

    public void setMaterialPercentageMin(BigDecimal materialPercentageMin) {
        this.materialPercentageMin = materialPercentageMin;
    }

    public void setMaterialPercentageStandard(BigDecimal materialPercentageStandard) {
        this.materialPercentageStandard = materialPercentageStandard;
    }

    @Deprecated
    public void setWageFactorMin(BigDecimal wageFactorMin) {
        this.wageFactorMin = wageFactorMin;
    }

    @Deprecated
    public void setWageFactorMax(BigDecimal wageFactorMax) {
        this.wageFactorMax = wageFactorMax;
    }

    public void setQuotationDate(LocalDate quotationDate) {
        this.quotationDate = quotationDate;
    }

    public void setQuotationOpeningDate(LocalDate quotationOpeningDate) {
        this.quotationOpeningDate = quotationOpeningDate;
    }

    @Deprecated
    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setProjectExecutionStartDate(LocalDate projectExecutionStartDate) {
        this.projectExecutionStartDate = projectExecutionStartDate;
    }

    public void setProjectExecutionEndDate(LocalDate projectExecutionEndDate) {
        this.projectExecutionEndDate = projectExecutionEndDate;
    }

    public void setQuotationProjectExecutionStartDate(LocalDate quotationProjectExecutionStartDate) {
        this.quotationProjectExecutionStartDate = quotationProjectExecutionStartDate;
    }

    public void setQuotationProjectExecutionEndDate(LocalDate quotationProjectExecutionEndDate) {
        this.quotationProjectExecutionEndDate = quotationProjectExecutionEndDate;
    }

    public void setAccountingFlag(String accountingFlag) {
        this.accountingFlag = accountingFlag;
    }

    public void setAccountingText(String accountingText) {
        this.accountingText = accountingText;
    }

    public void setCostCenterInternal(String costCenterInternal) {
        this.costCenterInternal = costCenterInternal;
    }

    public void setCostCenterExternal(String costCenterExternal) {
        this.costCenterExternal = costCenterExternal;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setContactPerson(ContactPerson contactPerson) {
        this.contactPerson = contactPerson;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    @Deprecated
    public void setCustomerShortName(String customerShortName) {
        this.customerShortName = customerShortName;
    }

    @Deprecated
    public void setCustomerName1(String customerName1) {
        this.customerName1 = customerName1;
    }

    @Deprecated
    public void setCustomerName2(String customerName2) {
        this.customerName2 = customerName2;
    }

    @Deprecated
    public void setCustomerStreet(String customerStreet) {
        this.customerStreet = customerStreet;
    }

    @Deprecated
    public void setCustomerStreetNo(String customerStreetNo) {
        this.customerStreetNo = customerStreetNo;
    }

    @Deprecated
    public void setCustomerZipCode(String customerZipCode) {
        this.customerZipCode = customerZipCode;
    }

    @Deprecated
    public void setCustomerCity(String customerCity) {
        this.customerCity = customerCity;
    }

    public void setCustomerInvoice(Customer customerInvoice) {
        this.customerInvoice = customerInvoice;
    }

    public void setCustomerInvoiceAddress(Address customerInvoiceAddress) {
        this.customerInvoiceAddress = customerInvoiceAddress;
    }

    @Deprecated
    public void setCustomerInvoiceShortName(String customerInvoiceShortName) {
        this.customerInvoiceShortName = customerInvoiceShortName;
    }

    @Deprecated
    public void setCustomerInvoiceName1(String customerInvoiceName1) {
        this.customerInvoiceName1 = customerInvoiceName1;
    }

    @Deprecated
    public void setCustomerInvoiceName2(String customerInvoiceName2) {
        this.customerInvoiceName2 = customerInvoiceName2;
    }

    @Deprecated
    public void setCustomerInvoiceStreet(String customerInvoiceStreet) {
        this.customerInvoiceStreet = customerInvoiceStreet;
    }

    @Deprecated
    public void setCustomerInvoiceStreetNo(String customerInvoiceStreetNo) {
        this.customerInvoiceStreetNo = customerInvoiceStreetNo;
    }

    @Deprecated
    public void setCustomerInvoiceZipCode(String customerInvoiceZipCode) {
        this.customerInvoiceZipCode = customerInvoiceZipCode;
    }

    @Deprecated
    public void setCustomerInvoiceCity(String customerInvoiceCity) {
        this.customerInvoiceCity = customerInvoiceCity;
    }

    public void setHeadlineG1Set(Boolean headlineG1Set) {
        this.headlineG1Set = headlineG1Set;
    }

    public void setHeadlineG1(String headlineG1) {
        this.headlineG1 = headlineG1;
    }

    public void setHeadlineG1Length(Integer headlineG1Length) {
        this.headlineG1Length = headlineG1Length;
    }

    public void setHeadlineG1IsNumeric(Boolean headlineG1IsNumeric) {
        this.headlineG1IsNumeric = headlineG1IsNumeric;
    }

    public void setHeadlineG1Align(String headlineG1Align) {
        this.headlineG1Align = headlineG1Align;
    }

    public void setHeadlineG2Set(Boolean headlineG2Set) {
        this.headlineG2Set = headlineG2Set;
    }

    public void setHeadlineG2(String headlineG2) {
        this.headlineG2 = headlineG2;
    }

    public void setHeadlineG2Length(Integer headlineG2Length) {
        this.headlineG2Length = headlineG2Length;
    }

    public void setHeadlineG2IsNumeric(Boolean headlineG2IsNumeric) {
        this.headlineG2IsNumeric = headlineG2IsNumeric;
    }

    public void setHeadlineG2Align(String headlineG2Align) {
        this.headlineG2Align = headlineG2Align;
    }

    public void setHeadlineG3Set(Boolean headlineG3Set) {
        this.headlineG3Set = headlineG3Set;
    }

    public void setHeadlineG3(String headlineG3) {
        this.headlineG3 = headlineG3;
    }

    public void setHeadlineG3Length(Integer headlineG3Length) {
        this.headlineG3Length = headlineG3Length;
    }

    public void setHeadlineG3IsNumeric(Boolean headlineG3IsNumeric) {
        this.headlineG3IsNumeric = headlineG3IsNumeric;
    }

    public void setHeadlineG3Align(String headlineG3Align) {
        this.headlineG3Align = headlineG3Align;
    }

    public void setHeadlineG4Set(Boolean headlineG4Set) {
        this.headlineG4Set = headlineG4Set;
    }

    public void setHeadlineG4(String headlineG4) {
        this.headlineG4 = headlineG4;
    }

    public void setHeadlineG4Length(Integer headlineG4Length) {
        this.headlineG4Length = headlineG4Length;
    }

    public void setHeadlineG4IsNumeric(Boolean headlineG4IsNumeric) {
        this.headlineG4IsNumeric = headlineG4IsNumeric;
    }

    public void setHeadlineG4Align(String headlineG4Align) {
        this.headlineG4Align = headlineG4Align;
    }

    public void setHeadlineG5Set(Boolean headlineG5Set) {
        this.headlineG5Set = headlineG5Set;
    }

    public void setHeadlineG5(String headlineG5) {
        this.headlineG5 = headlineG5;
    }

    public void setHeadlineG5Length(Integer headlineG5Length) {
        this.headlineG5Length = headlineG5Length;
    }

    public void setHeadlineG5IsNumeric(Boolean headlineG5IsNumeric) {
        this.headlineG5IsNumeric = headlineG5IsNumeric;
    }

    public void setHeadlineG5Align(String headlineG5Align) {
        this.headlineG5Align = headlineG5Align;
    }

    public void setItemFormatG1Set(Boolean itemFormatG1Set) {
        this.itemFormatG1Set = itemFormatG1Set;
    }

    public void setItemFormatG1(String itemFormatG1) {
        this.itemFormatG1 = itemFormatG1;
    }

    public void setItemFormatG1Length(Integer itemFormatG1Length) {
        this.itemFormatG1Length = itemFormatG1Length;
    }

    public void setItemFormatG1IsNumeric(Boolean itemFormatG1IsNumeric) {
        this.itemFormatG1IsNumeric = itemFormatG1IsNumeric;
    }

    public void setItemFormatG1Align(String itemFormatG1Align) {
        this.itemFormatG1Align = itemFormatG1Align;
    }

    public void setItemFormatG2Set(Boolean itemFormatG2Set) {
        this.itemFormatG2Set = itemFormatG2Set;
    }

    public void setItemFormatG2(String itemFormatG2) {
        this.itemFormatG2 = itemFormatG2;
    }

    public void setItemFormatG2Length(Integer itemFormatG2Length) {
        this.itemFormatG2Length = itemFormatG2Length;
    }

    public void setItemFormatG2IsNumeric(Boolean itemFormatG2IsNumeric) {
        this.itemFormatG2IsNumeric = itemFormatG2IsNumeric;
    }

    public void setItemFormatG2Align(String itemFormatG2Align) {
        this.itemFormatG2Align = itemFormatG2Align;
    }

    public void setX83ProjectLabel(String x83ProjectLabel) {
        this.x83ProjectLabel = x83ProjectLabel;
    }

    public void setX83ProjectName(String x83ProjectName) {
        this.x83ProjectName = x83ProjectName;
    }

    public void setX83ProjectCurrency(String x83ProjectCurrency) {
        this.x83ProjectCurrency = x83ProjectCurrency;
    }

    public void setX83ProjectCurrencyLabel(String x83ProjectCurrencyLabel) {
        this.x83ProjectCurrencyLabel = x83ProjectCurrencyLabel;
    }

    public void setX83BoqInfoDate(LocalDate x83BoqInfoDate) {
        this.x83BoqInfoDate = x83BoqInfoDate;
    }

    public void setX83BoqName(String x83BoqName) {
        this.x83BoqName = x83BoqName;
    }

    public void setX83BoqLabel(String x83BoqLabel) {
        this.x83BoqLabel = x83BoqLabel;
    }

    public void setX83BoqAwardCurrency(String x83BoqAwardCurrency) {
        this.x83BoqAwardCurrency = x83BoqAwardCurrency;
    }

    public void setX83BoqAwardCurrencyLabel(String x83BoqAwardCurrencyLabel) {
        this.x83BoqAwardCurrencyLabel = x83BoqAwardCurrencyLabel;
    }

    @Deprecated
    public void setFlagConstantCompanyWage(Boolean flagConstantCompanyWage) {
        this.flagConstantCompanyWage = flagConstantCompanyWage;
    }

    @Deprecated
    public void setFlagOrderEnd(Boolean flagOrderEnd) {
        this.flagOrderEnd = flagOrderEnd;
    }

    public void setFlagOrderEqualsQuotation(Boolean flagOrderEqualsQuotation) {
        this.flagOrderEqualsQuotation = flagOrderEqualsQuotation;
    }

    @Deprecated
    public void setFlagSquadIsAllowedToCreateReleaseOrder(Boolean flagSquadIsAllowedToCreateReleaseOrder) {
        this.flagSquadIsAllowedToCreateReleaseOrder = flagSquadIsAllowedToCreateReleaseOrder;
    }

    public void setFlagMeasurementWithoutCommissionNumberAllowed(Boolean flagMeasurementWithoutCommissionNumberAllowed) {
        this.flagMeasurementWithoutCommissionNumberAllowed = flagMeasurementWithoutCommissionNumberAllowed;
    }

    @Deprecated
    public void setFlagReleaseOrderOrderNumberMandatory(Boolean flagReleaseOrderOrderNumberMandatory) {
        this.flagReleaseOrderOrderNumberMandatory = flagReleaseOrderOrderNumberMandatory;
    }

    @Deprecated
    public void setFlagAutomaticWageAssignmentAllowed(Boolean flagAutomaticWageAssignmentAllowed) {
        this.flagAutomaticWageAssignmentAllowed = flagAutomaticWageAssignmentAllowed;
    }

    public void setFlagDiscountFeePositions(Boolean flagDiscountFeePositions) {
        this.flagDiscountFeePositions = flagDiscountFeePositions;
    }

    public void setPdfExtractType(EPdfExtractType pdfExtractType) {
        this.pdfExtractType = pdfExtractType;
    }

    public void setFlagB2B(Boolean flagB2B) {
        this.flagB2B = flagB2B;
    }

    public void setFlagPositionGridLocked(Boolean flagPositionGridLocked) {
        this.flagPositionGridLocked = flagPositionGridLocked;
    }

    public void setFlagBudgetRelevant(Boolean flagBudgetRelevant) {
        this.flagBudgetRelevant = flagBudgetRelevant;
    }

    public void setFlagCrossVersionOrderValue(Boolean flagCrossVersionOrderValue) {
        this.flagCrossVersionOrderValue = flagCrossVersionOrderValue;
    }

    public void setBudget(BigDecimal budget) {
        this.budget = budget;
    }

    @Deprecated
    public void setOrderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
    }

    public void setOrderDescriptionCustomer(String orderDescriptionCustomer) {
        this.orderDescriptionCustomer = orderDescriptionCustomer;
    }

    public void setOrderDescriptionInternal(String orderDescriptionInternal) {
        this.orderDescriptionInternal = orderDescriptionInternal;
    }

    @Deprecated
    public void setContactPersonOld(String contactPersonOld) {
        this.contactPersonOld = contactPersonOld;
    }

    public void setAgent(Customer agent) {
        this.agent = agent;
    }

    public void setAgentAddress(Address agentAddress) {
        this.agentAddress = agentAddress;
    }

    public void setAgentShortName(String agentShortName) {
        this.agentShortName = agentShortName;
    }

    public void setAgentName1(String agentName1) {
        this.agentName1 = agentName1;
    }

    public void setAgentName2(String agentName2) {
        this.agentName2 = agentName2;
    }

    public void setAgentStreet(String agentStreet) {
        this.agentStreet = agentStreet;
    }

    public void setAgentStreetNo(String agentStreetNo) {
        this.agentStreetNo = agentStreetNo;
    }

    public void setAgentZipCode(String agentZipCode) {
        this.agentZipCode = agentZipCode;
    }

    public void setAgentCity(String agentCity) {
        this.agentCity = agentCity;
    }

    public void setAgentInvoice(Customer agentInvoice) {
        this.agentInvoice = agentInvoice;
    }

    public void setAgentInvoiceAddress(Address agentInvoiceAddress) {
        this.agentInvoiceAddress = agentInvoiceAddress;
    }

    @Deprecated
    public void setAgentInvoiceShortName(String agentInvoiceShortName) {
        this.agentInvoiceShortName = agentInvoiceShortName;
    }

    @Deprecated
    public void setAgentInvoiceName1(String agentInvoiceName1) {
        this.agentInvoiceName1 = agentInvoiceName1;
    }

    @Deprecated
    public void setAgentInvoiceName2(String agentInvoiceName2) {
        this.agentInvoiceName2 = agentInvoiceName2;
    }

    @Deprecated
    public void setAgentInvoiceStreet(String agentInvoiceStreet) {
        this.agentInvoiceStreet = agentInvoiceStreet;
    }

    @Deprecated
    public void setAgentInvoiceStreetNo(String agentInvoiceStreetNo) {
        this.agentInvoiceStreetNo = agentInvoiceStreetNo;
    }

    @Deprecated
    public void setAgentInvoiceZipCode(String agentInvoiceZipCode) {
        this.agentInvoiceZipCode = agentInvoiceZipCode;
    }

    @Deprecated
    public void setAgentInvoiceCity(String agentInvoiceCity) {
        this.agentInvoiceCity = agentInvoiceCity;
    }

    @Deprecated
    public void setFinanceCompanyNumber(String financeCompanyNumber) {
        this.financeCompanyNumber = financeCompanyNumber;
    }

    @Deprecated
    public void setFinanceAccountingText(String financeAccountingText) {
        this.financeAccountingText = financeAccountingText;
    }

    public void setFinanceTimeForPayment(Integer financeTimeForPayment) {
        this.financeTimeForPayment = financeTimeForPayment;
    }

    public void setFinanceCashDiscountTime1(Integer financeCashDiscountTime1) {
        this.financeCashDiscountTime1 = financeCashDiscountTime1;
    }

    public void setFinanceCashDiscount1(BigDecimal financeCashDiscount1) {
        this.financeCashDiscount1 = financeCashDiscount1;
    }

    public void setFinanceCashDiscountTime2(Integer financeCashDiscountTime2) {
        this.financeCashDiscountTime2 = financeCashDiscountTime2;
    }

    public void setFinanceCashDiscount2(BigDecimal financeCashDiscount2) {
        this.financeCashDiscount2 = financeCashDiscount2;
    }

    public void setFinanceDebtorAccountNumber(String financeDebtorAccountNumber) {
        this.financeDebtorAccountNumber = financeDebtorAccountNumber;
    }

    public void setFinanceTaxKeyValue(String financeTaxKeyValue) {
        this.financeTaxKeyValue = financeTaxKeyValue;
    }

    public void setFinanceAccount(String financeAccount) {
        this.financeAccount = financeAccount;
    }

    public void setFinanceCostUnit(Integer financeCostUnit) {
        this.financeCostUnit = financeCostUnit;
    }

    public void setVatPercent(BigDecimal vatPercent) {
        this.vatPercent = vatPercent;
    }

    public void setFinanceDefaultInvoiceType(EInvoiceType financeDefaultInvoiceType) {
        this.financeDefaultInvoiceType = financeDefaultInvoiceType;
    }

    public void setFinanceFlagSubcontractor(Boolean financeFlagSubcontractor) {
        this.financeFlagSubcontractor = financeFlagSubcontractor;
    }

    public void setFinanceRoutingReferenceId(String financeRoutingReferenceId) {
        this.financeRoutingReferenceId = financeRoutingReferenceId;
    }

    public void setGeneralDiscount(BigDecimal generalDiscount) {
        this.generalDiscount = generalDiscount;
    }

    public void setOtherDiscount(BigDecimal otherDiscount) {
        this.otherDiscount = otherDiscount;
    }

    public void setFinanceTaxKey(TaxKey financeTaxKey) {
        this.financeTaxKey = financeTaxKey;
    }

    public void setLastQuotationBoQ(QuotationBoQ lastQuotationBoQ) {
        this.lastQuotationBoQ = lastQuotationBoQ;
    }

    public void setQuotationBoQs(Set<QuotationBoQ> quotationBoQs) {
        this.quotationBoQs = quotationBoQs;
    }

    public void setQuotationPositions(Set<QuotationPosition> quotationPositions) {
        this.quotationPositions = quotationPositions;
    }

    public void setStageType(EQStageType stageType) {
        this.stageType = stageType;
    }

    public void setStageState(EQStageState stageState) {
        this.stageState = stageState;
    }

    public void setStageStateSince(LocalDateTime stageStateSince) {
        this.stageStateSince = stageStateSince;
    }

    public void setArchiveReason(String archiveReason) {
        this.archiveReason = archiveReason;
    }

    public void setStagePositionSortOption(EStagePositionSortOption stagePositionSortOption) {
        this.stagePositionSortOption = stagePositionSortOption;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setVersionSince(LocalDateTime versionSince) {
        this.versionSince = versionSince;
    }

    public void setWagePercentageMin(BigDecimal wagePercentageMin) {
        this.wagePercentageMin = wagePercentageMin;
    }

    public void setWagePercentageStandard(BigDecimal wagePercentageStandard) {
        this.wagePercentageStandard = wagePercentageStandard;
    }

    public void setWarrantySecurityRetentionPercent(BigDecimal warrantySecurityRetentionPercent) {
        this.warrantySecurityRetentionPercent = warrantySecurityRetentionPercent;
    }

    public void setFulfillmentSecurityRetentionPercent(BigDecimal fulfillmentSecurityRetentionPercent) {
        this.fulfillmentSecurityRetentionPercent = fulfillmentSecurityRetentionPercent;
    }

    public void setInquiryDate(LocalDate inquiryDate) {
        this.inquiryDate = inquiryDate;
    }

    public void setProcurementNumber(String procurementNumber) {
        this.procurementNumber = procurementNumber;
    }

    public void setSubmissionDateTime(LocalDateTime submissionDateTime) {
        this.submissionDateTime = submissionDateTime;
    }

    public void setFlagWithoutSubmissionDeadline(Boolean flagWithoutSubmissionDeadline) {
        this.flagWithoutSubmissionDeadline = flagWithoutSubmissionDeadline;
    }

    public void setPlannedSubmissionDate(LocalDate plannedSubmissionDate) {
        this.plannedSubmissionDate = plannedSubmissionDate;
    }

    public void setSubmissionOfBidDate(LocalDate submissionOfBidDate) {
        this.submissionOfBidDate = submissionOfBidDate;
    }

    public void setPlacementOfOrderDutyDate(LocalDate placementOfOrderDutyDate) {
        this.placementOfOrderDutyDate = placementOfOrderDutyDate;
    }

    public void setBindingPeriodDate(LocalDate bindingPeriodDate) {
        this.bindingPeriodDate = bindingPeriodDate;
    }

    public void setCommissionDate(LocalDate commissionDate) {
        this.commissionDate = commissionDate;
    }

    public void setGracePeriodDate(LocalDate gracePeriodDate) {
        this.gracePeriodDate = gracePeriodDate;
    }

    public void setCommissionType(ECommissionType commissionType) {
        this.commissionType = commissionType;
    }

    public void setInquiryType(EInquiryType inquiryType) {
        this.inquiryType = inquiryType;
    }

    public void setInquiryReceiveType(EInquiryReceiveType inquiryReceiveType) {
        this.inquiryReceiveType = inquiryReceiveType;
    }

    public void setQuotationSubmissionType(EQuotationSubmissionType quotationSubmissionType) {
        this.quotationSubmissionType = quotationSubmissionType;
    }

    public void setCoverLetterSubject1st(String coverLetterSubject1st) {
        this.coverLetterSubject1st = coverLetterSubject1st;
    }

    public void setCoverLetterSubject1stChanged(Boolean coverLetterSubject1stChanged) {
        this.coverLetterSubject1stChanged = coverLetterSubject1stChanged;
    }

    public void setCoverLetterSubject2nd(String coverLetterSubject2nd) {
        this.coverLetterSubject2nd = coverLetterSubject2nd;
    }

    public void setCoverLetterSubject2ndChanged(Boolean coverLetterSubject2ndChanged) {
        this.coverLetterSubject2ndChanged = coverLetterSubject2ndChanged;
    }

    public void setCoverLetterTitle(String coverLetterTitle) {
        this.coverLetterTitle = coverLetterTitle;
    }

    public void setCoverLetterTitleChanged(Boolean coverLetterTitleChanged) {
        this.coverLetterTitleChanged = coverLetterTitleChanged;
    }

    public void setCoverLetterBody1(String coverLetterBody1) {
        this.coverLetterBody1 = coverLetterBody1;
    }

    public void setCoverLetterBody1Changed(Boolean coverLetterBody1Changed) {
        this.coverLetterBody1Changed = coverLetterBody1Changed;
    }

    public void setCoverLetterBody2(String coverLetterBody2) {
        this.coverLetterBody2 = coverLetterBody2;
    }

    public void setCoverLetterBody2Changed(Boolean coverLetterBody2Changed) {
        this.coverLetterBody2Changed = coverLetterBody2Changed;
    }

    public void setCoverLetterBody3(String coverLetterBody3) {
        this.coverLetterBody3 = coverLetterBody3;
    }

    public void setCoverLetterBody3Changed(Boolean coverLetterBody3Changed) {
        this.coverLetterBody3Changed = coverLetterBody3Changed;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setPriceWithoutDiscountSum(BigDecimal priceWithoutDiscountSum) {
        this.priceWithoutDiscountSum = priceWithoutDiscountSum;
    }

    public void setPriceWithDiscountSum(BigDecimal priceWithDiscountSum) {
        this.priceWithDiscountSum = priceWithDiscountSum;
    }

    public void setSquadWageSum(BigDecimal squadWageSum) {
        this.squadWageSum = squadWageSum;
    }

    public void setCompanyWageSum(BigDecimal companyWageSum) {
        this.companyWageSum = companyWageSum;
    }

    public void setMaterialPurchasePriceSum(BigDecimal materialPurchasePriceSum) {
        this.materialPurchasePriceSum = materialPurchasePriceSum;
    }

    public void setMaterialSellingPriceSum(BigDecimal materialSellingPriceSum) {
        this.materialSellingPriceSum = materialSellingPriceSum;
    }

    public void setExternalServicePurchasePriceSum(BigDecimal externalServicePurchasePriceSum) {
        this.externalServicePurchasePriceSum = externalServicePurchasePriceSum;
    }

    public void setExternalServiceSellingPriceSum(BigDecimal externalServiceSellingPriceSum) {
        this.externalServiceSellingPriceSum = externalServiceSellingPriceSum;
    }

    public void setWagePercentageWeightedAverage(BigDecimal wagePercentageWeightedAverage) {
        this.wagePercentageWeightedAverage = wagePercentageWeightedAverage;
    }

    public void setMaterialPercentageWeightedAverage(BigDecimal materialPercentageWeightedAverage) {
        this.materialPercentageWeightedAverage = materialPercentageWeightedAverage;
    }

    public void setExternalServicePercentageWeightedAverage(BigDecimal externalServicePercentageWeightedAverage) {
        this.externalServicePercentageWeightedAverage = externalServicePercentageWeightedAverage;
    }

    public void setVatValueWithoutDiscountSum(BigDecimal vatValueWithoutDiscountSum) {
        this.vatValueWithoutDiscountSum = vatValueWithoutDiscountSum;
    }

    public void setVatValueWithDiscountSum(BigDecimal vatValueWithDiscountSum) {
        this.vatValueWithDiscountSum = vatValueWithDiscountSum;
    }

    public void setPriceGrossWithoutDiscountSum(BigDecimal priceGrossWithoutDiscountSum) {
        this.priceGrossWithoutDiscountSum = priceGrossWithoutDiscountSum;
    }

    public void setPriceGrossWithDiscountSum(BigDecimal priceGrossWithDiscountSum) {
        this.priceGrossWithDiscountSum = priceGrossWithDiscountSum;
    }

    public void setStageNotifyUsersText(String stageNotifyUsersText) {
        this.stageNotifyUsersText = stageNotifyUsersText;
    }

    public void setStageResponsibleUsersText(String stageResponsibleUsersText) {
        this.stageResponsibleUsersText = stageResponsibleUsersText;
    }

    public void setStageSignatureUsersText(String stageSignatureUsersText) {
        this.stageSignatureUsersText = stageSignatureUsersText;
    }

    public void setEr2ExportState(EER2ExportState er2ExportState) {
        this.er2ExportState = er2ExportState;
    }

    public void setEr2ExportedOn(LocalDateTime er2ExportedOn) {
        this.er2ExportedOn = er2ExportedOn;
    }

    public void setEr2ExportedToPath(String er2ExportedToPath) {
        this.er2ExportedToPath = er2ExportedToPath;
    }

    public void setSubProject(SubProject subProject) {
        this.subProject = subProject;
    }

    public void setQEntity(QEntity qEntity) {
        this.qEntity = qEntity;
    }

    public void setReference(Quotation reference) {
        this.reference = reference;
    }

    public void setParent(Quotation parent) {
        this.parent = parent;
    }

    public void setLastInvoice(Invoice lastInvoice) {
        this.lastInvoice = lastInvoice;
    }

    public void setFinalInvoice(Invoice finalInvoice) {
        this.finalInvoice = finalInvoice;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setChildren(Set<Quotation> children) {
        this.children = children;
    }

    public void setStageNotifyUsers(Set<StageNotifyUser> stageNotifyUsers) {
        this.stageNotifyUsers = stageNotifyUsers;
    }

    public void setStageResponsibleUsers(Set<StageResponsibleUser> stageResponsibleUsers) {
        this.stageResponsibleUsers = stageResponsibleUsers;
    }

    public void setStageSignatureUsers(Set<StageSignatureUser> stageSignatureUsers) {
        this.stageSignatureUsers = stageSignatureUsers;
    }

    public void setInvoices(Set<Invoice> invoices) {
        this.invoices = invoices;
    }

    public void setMeasurements(Set<Measurement> measurements) {
        this.measurements = measurements;
    }

    public void setStageInvoiceSupplements(Set<StageInvoiceSupplement> stageInvoiceSupplements) {
        this.stageInvoiceSupplements = stageInvoiceSupplements;
    }

    public String toString() {
        return "Quotation(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", origin=" + String.valueOf(this.getOrigin()) + ", searchIndexState=" + String.valueOf(this.getSearchIndexState()) + ", quotationName=" + this.getQuotationName() + ", quotationNumber=" + this.getQuotationNumber() + ", addendumNumber=" + this.getAddendumNumber() + ", qNumber=" + this.getQNumber() + ", alias=" + this.getAlias() + ", aliasChanged=" + this.getAliasChanged() + ", valueAggregated=" + String.valueOf(this.getValueAggregated()) + ", materialValueAggregated=" + String.valueOf(this.getMaterialValueAggregated()) + ", wageValueAggregated=" + String.valueOf(this.getWageValueAggregated()) + ", orderValue=" + String.valueOf(this.getOrderValue()) + ", orderValueWithDiscount=" + String.valueOf(this.getOrderValueWithDiscount()) + ", orderValueEstimate=" + String.valueOf(this.getOrderValueEstimate()) + ", budgetAllowedOverdraftPercent=" + String.valueOf(this.getBudgetAllowedOverdraftPercent()) + ", budgetAllowedOverdraftValue=" + String.valueOf(this.getBudgetAllowedOverdraftValue()) + ", priceAggregated=" + String.valueOf(this.getPriceAggregated()) + ", materialPercentageMin=" + String.valueOf(this.getMaterialPercentageMin()) + ", materialPercentageStandard=" + String.valueOf(this.getMaterialPercentageStandard()) + ", wageFactorMin=" + String.valueOf(this.getWageFactorMin()) + ", wageFactorMax=" + String.valueOf(this.getWageFactorMax()) + ", quotationDate=" + String.valueOf(this.getQuotationDate()) + ", quotationOpeningDate=" + String.valueOf(this.getQuotationOpeningDate()) + ", orderDate=" + String.valueOf(this.getOrderDate()) + ", orderNumber=" + this.getOrderNumber() + ", projectExecutionStartDate=" + String.valueOf(this.getProjectExecutionStartDate()) + ", projectExecutionEndDate=" + String.valueOf(this.getProjectExecutionEndDate()) + ", quotationProjectExecutionStartDate=" + String.valueOf(this.getQuotationProjectExecutionStartDate()) + ", quotationProjectExecutionEndDate=" + String.valueOf(this.getQuotationProjectExecutionEndDate()) + ", accountingFlag=" + this.getAccountingFlag() + ", accountingText=" + this.getAccountingText() + ", costCenterInternal=" + this.getCostCenterInternal() + ", costCenterExternal=" + this.getCostCenterExternal() + ", customer=" + String.valueOf(this.getCustomer()) + ", address=" + String.valueOf(this.getAddress()) + ", contactPerson=" + String.valueOf(this.getContactPerson()) + ", customerEmail=" + this.getCustomerEmail() + ", customerShortName=" + this.getCustomerShortName() + ", customerName1=" + this.getCustomerName1() + ", customerName2=" + this.getCustomerName2() + ", customerStreet=" + this.getCustomerStreet() + ", customerStreetNo=" + this.getCustomerStreetNo() + ", customerZipCode=" + this.getCustomerZipCode() + ", customerCity=" + this.getCustomerCity() + ", customerInvoice=" + String.valueOf(this.getCustomerInvoice()) + ", customerInvoiceAddress=" + String.valueOf(this.getCustomerInvoiceAddress()) + ", customerInvoiceShortName=" + this.getCustomerInvoiceShortName() + ", customerInvoiceName1=" + this.getCustomerInvoiceName1() + ", customerInvoiceName2=" + this.getCustomerInvoiceName2() + ", customerInvoiceStreet=" + this.getCustomerInvoiceStreet() + ", customerInvoiceStreetNo=" + this.getCustomerInvoiceStreetNo() + ", customerInvoiceZipCode=" + this.getCustomerInvoiceZipCode() + ", customerInvoiceCity=" + this.getCustomerInvoiceCity() + ", headlineG1Set=" + this.getHeadlineG1Set() + ", headlineG1=" + this.getHeadlineG1() + ", headlineG1Length=" + this.getHeadlineG1Length() + ", headlineG1IsNumeric=" + this.getHeadlineG1IsNumeric() + ", headlineG1Align=" + this.getHeadlineG1Align() + ", headlineG2Set=" + this.getHeadlineG2Set() + ", headlineG2=" + this.getHeadlineG2() + ", headlineG2Length=" + this.getHeadlineG2Length() + ", headlineG2IsNumeric=" + this.getHeadlineG2IsNumeric() + ", headlineG2Align=" + this.getHeadlineG2Align() + ", headlineG3Set=" + this.getHeadlineG3Set() + ", headlineG3=" + this.getHeadlineG3() + ", headlineG3Length=" + this.getHeadlineG3Length() + ", headlineG3IsNumeric=" + this.getHeadlineG3IsNumeric() + ", headlineG3Align=" + this.getHeadlineG3Align() + ", headlineG4Set=" + this.getHeadlineG4Set() + ", headlineG4=" + this.getHeadlineG4() + ", headlineG4Length=" + this.getHeadlineG4Length() + ", headlineG4IsNumeric=" + this.getHeadlineG4IsNumeric() + ", headlineG4Align=" + this.getHeadlineG4Align() + ", headlineG5Set=" + this.getHeadlineG5Set() + ", headlineG5=" + this.getHeadlineG5() + ", headlineG5Length=" + this.getHeadlineG5Length() + ", headlineG5IsNumeric=" + this.getHeadlineG5IsNumeric() + ", headlineG5Align=" + this.getHeadlineG5Align() + ", itemFormatG1Set=" + this.getItemFormatG1Set() + ", itemFormatG1=" + this.getItemFormatG1() + ", itemFormatG1Length=" + this.getItemFormatG1Length() + ", itemFormatG1IsNumeric=" + this.getItemFormatG1IsNumeric() + ", itemFormatG1Align=" + this.getItemFormatG1Align() + ", itemFormatG2Set=" + this.getItemFormatG2Set() + ", itemFormatG2=" + this.getItemFormatG2() + ", itemFormatG2Length=" + this.getItemFormatG2Length() + ", itemFormatG2IsNumeric=" + this.getItemFormatG2IsNumeric() + ", itemFormatG2Align=" + this.getItemFormatG2Align() + ", x83ProjectLabel=" + this.getX83ProjectLabel() + ", x83ProjectName=" + this.getX83ProjectName() + ", x83ProjectCurrency=" + this.getX83ProjectCurrency() + ", x83ProjectCurrencyLabel=" + this.getX83ProjectCurrencyLabel() + ", x83BoqInfoDate=" + String.valueOf(this.getX83BoqInfoDate()) + ", x83BoqName=" + this.getX83BoqName() + ", x83BoqLabel=" + this.getX83BoqLabel() + ", x83BoqAwardCurrency=" + this.getX83BoqAwardCurrency() + ", x83BoqAwardCurrencyLabel=" + (this.getX83BoqAwardCurrencyLabel() + ", flagConstantCompanyWage=" + this.getFlagConstantCompanyWage() + ", flagOrderEnd=" + this.getFlagOrderEnd() + ", flagOrderEqualsQuotation=" + this.getFlagOrderEqualsQuotation() + ", flagSquadIsAllowedToCreateReleaseOrder=" + this.getFlagSquadIsAllowedToCreateReleaseOrder() + ", flagMeasurementWithoutCommissionNumberAllowed=" + this.getFlagMeasurementWithoutCommissionNumberAllowed() + ", flagReleaseOrderOrderNumberMandatory=" + this.getFlagReleaseOrderOrderNumberMandatory() + ", flagAutomaticWageAssignmentAllowed=" + this.getFlagAutomaticWageAssignmentAllowed() + ", flagDiscountFeePositions=" + this.getFlagDiscountFeePositions() + ", pdfExtractType=" + String.valueOf(this.getPdfExtractType()) + ", flagB2B=" + this.getFlagB2B() + ", flagPositionGridLocked=" + this.getFlagPositionGridLocked() + ", flagBudgetRelevant=" + this.getFlagBudgetRelevant() + ", flagCrossVersionOrderValue=" + this.getFlagCrossVersionOrderValue() + ", budget=" + String.valueOf(this.getBudget()) + ", orderDescription=" + this.getOrderDescription() + ", orderDescriptionCustomer=" + this.getOrderDescriptionCustomer() + ", orderDescriptionInternal=" + this.getOrderDescriptionInternal() + ", contactPersonOld=" + this.getContactPersonOld() + ", agent=" + String.valueOf(this.getAgent()) + ", agentAddress=" + String.valueOf(this.getAgentAddress()) + ", agentShortName=" + this.getAgentShortName() + ", agentName1=" + this.getAgentName1() + ", agentName2=" + this.getAgentName2() + ", agentStreet=" + this.getAgentStreet() + ", agentStreetNo=" + this.getAgentStreetNo() + ", agentZipCode=" + this.getAgentZipCode() + ", agentCity=" + this.getAgentCity() + ", agentInvoice=" + String.valueOf(this.getAgentInvoice()) + ", agentInvoiceAddress=" + String.valueOf(this.getAgentInvoiceAddress()) + ", agentInvoiceShortName=" + this.getAgentInvoiceShortName() + ", agentInvoiceName1=" + this.getAgentInvoiceName1() + ", agentInvoiceName2=" + this.getAgentInvoiceName2() + ", agentInvoiceStreet=" + this.getAgentInvoiceStreet() + ", agentInvoiceStreetNo=" + this.getAgentInvoiceStreetNo() + ", agentInvoiceZipCode=" + this.getAgentInvoiceZipCode() + ", agentInvoiceCity=" + this.getAgentInvoiceCity() + ", financeCompanyNumber=" + this.getFinanceCompanyNumber() + ", financeAccountingText=" + this.getFinanceAccountingText() + ", financeTimeForPayment=" + this.getFinanceTimeForPayment() + ", financeCashDiscountTime1=" + this.getFinanceCashDiscountTime1() + ", financeCashDiscount1=" + String.valueOf(this.getFinanceCashDiscount1()) + ", financeCashDiscountTime2=" + this.getFinanceCashDiscountTime2() + ", financeCashDiscount2=" + String.valueOf(this.getFinanceCashDiscount2()) + ", financeDebtorAccountNumber=" + this.getFinanceDebtorAccountNumber() + ", financeTaxKeyValue=" + this.getFinanceTaxKeyValue() + ", financeAccount=" + this.getFinanceAccount() + ", financeCostUnit=" + this.getFinanceCostUnit() + ", vatPercent=" + String.valueOf(this.getVatPercent()) + ", financeDefaultInvoiceType=" + String.valueOf(this.getFinanceDefaultInvoiceType()) + ", financeFlagSubcontractor=" + this.getFinanceFlagSubcontractor() + ", financeRoutingReferenceId=" + this.getFinanceRoutingReferenceId() + ", generalDiscount=" + String.valueOf(this.getGeneralDiscount()) + ", otherDiscount=" + String.valueOf(this.getOtherDiscount()) + ", stageType=" + String.valueOf(this.getStageType()) + ", stageState=" + String.valueOf(this.getStageState()) + ", stageStateSince=" + String.valueOf(this.getStageStateSince()) + ", archiveReason=" + this.getArchiveReason() + ", stagePositionSortOption=" + String.valueOf(this.getStagePositionSortOption()) + ", version=" + this.getVersion() + ", versionSince=" + String.valueOf(this.getVersionSince()) + ", wagePercentageMin=" + String.valueOf(this.getWagePercentageMin()) + ", wagePercentageStandard=" + String.valueOf(this.getWagePercentageStandard()) + ", warrantySecurityRetentionPercent=" + String.valueOf(this.getWarrantySecurityRetentionPercent()) + ", fulfillmentSecurityRetentionPercent=" + String.valueOf(this.getFulfillmentSecurityRetentionPercent()) + ", inquiryDate=" + String.valueOf(this.getInquiryDate()) + ", procurementNumber=" + this.getProcurementNumber() + ", submissionDateTime=" + String.valueOf(this.getSubmissionDateTime()) + ", flagWithoutSubmissionDeadline=" + this.getFlagWithoutSubmissionDeadline() + ", plannedSubmissionDate=" + String.valueOf(this.getPlannedSubmissionDate()) + ", submissionOfBidDate=" + String.valueOf(this.getSubmissionOfBidDate()) + ", placementOfOrderDutyDate=" + String.valueOf(this.getPlacementOfOrderDutyDate()) + ", bindingPeriodDate=" + String.valueOf(this.getBindingPeriodDate()) + ", commissionDate=" + String.valueOf(this.getCommissionDate()) + ", gracePeriodDate=" + String.valueOf(this.getGracePeriodDate()) + ", commissionType=" + String.valueOf(this.getCommissionType()) + ", inquiryType=" + String.valueOf(this.getInquiryType()) + ", inquiryReceiveType=" + String.valueOf(this.getInquiryReceiveType()) + ", quotationSubmissionType=" + String.valueOf(this.getQuotationSubmissionType()) + ", coverLetterSubject1st=" + this.getCoverLetterSubject1st() + ", coverLetterSubject1stChanged=" + this.getCoverLetterSubject1stChanged() + ", coverLetterSubject2nd=" + this.getCoverLetterSubject2nd() + ", coverLetterSubject2ndChanged=" + this.getCoverLetterSubject2ndChanged() + ", coverLetterTitle=" + this.getCoverLetterTitle() + ", coverLetterTitleChanged=" + this.getCoverLetterTitleChanged() + ", coverLetterBody1=" + this.getCoverLetterBody1() + ", coverLetterBody1Changed=" + this.getCoverLetterBody1Changed() + ", coverLetterBody2=" + this.getCoverLetterBody2() + ", coverLetterBody2Changed=" + this.getCoverLetterBody2Changed() + ", coverLetterBody3=" + this.getCoverLetterBody3() + ", coverLetterBody3Changed=" + this.getCoverLetterBody3Changed() + ", remarks=" + this.getRemarks() + ", priceWithoutDiscountSum=" + String.valueOf(this.getPriceWithoutDiscountSum()) + ", priceWithDiscountSum=" + String.valueOf(this.getPriceWithDiscountSum()) + ", squadWageSum=" + String.valueOf(this.getSquadWageSum()) + ", companyWageSum=" + String.valueOf(this.getCompanyWageSum()) + ", materialPurchasePriceSum=" + String.valueOf(this.getMaterialPurchasePriceSum()) + ", materialSellingPriceSum=" + String.valueOf(this.getMaterialSellingPriceSum()) + ", externalServicePurchasePriceSum=" + String.valueOf(this.getExternalServicePurchasePriceSum()) + ", externalServiceSellingPriceSum=" + String.valueOf(this.getExternalServiceSellingPriceSum())) + (", wagePercentageWeightedAverage=" + String.valueOf(this.getWagePercentageWeightedAverage()) + ", materialPercentageWeightedAverage=" + String.valueOf(this.getMaterialPercentageWeightedAverage()) + ", externalServicePercentageWeightedAverage=" + String.valueOf(this.getExternalServicePercentageWeightedAverage()) + ", vatValueWithoutDiscountSum=" + String.valueOf(this.getVatValueWithoutDiscountSum()) + ", vatValueWithDiscountSum=" + String.valueOf(this.getVatValueWithDiscountSum()) + ", priceGrossWithoutDiscountSum=" + String.valueOf(this.getPriceGrossWithoutDiscountSum()) + ", priceGrossWithDiscountSum=" + String.valueOf(this.getPriceGrossWithDiscountSum()) + ", stageNotifyUsersText=" + this.getStageNotifyUsersText() + ", stageResponsibleUsersText=" + this.getStageResponsibleUsersText() + ", stageSignatureUsersText=" + this.getStageSignatureUsersText() + ", er2ExportState=" + String.valueOf(this.getEr2ExportState()) + ", er2ExportedOn=" + String.valueOf(this.getEr2ExportedOn()) + ", er2ExportedToPath=" + this.getEr2ExportedToPath() + ")");
    }
}

