/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EQTreeRootStage implements Translatable
{
    UNKNOWN,
    INQUIRY,
    CALCULATION,
    QUOTATION,
    COMMISSION,
    ADDENDUM,
    COST_UNIT,
    COST_ESTIMATE;

    private static final Map<String, EQTreeRootStage> LOOKUP;
    @Nonnull
    public static Iterable<EQTreeRootStage> ROOT_STAGE_TYPES;
    @Nonnull
    public static ImmutableMultimap<EQTreeRootStage, EQStageType> ROOT_STAGE_TYPE_CHILDREN;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EQTreeRootStage lookup(@NonNull String candidate, @NonNull EQTreeRootStage defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EQTreeRootStage.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EQTreeRootStage> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EQTreeRootStage.key((String)candidate);
        return Optional.ofNullable((EQTreeRootStage)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EQTreeRootStage item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EQTreeRootStage.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.tree_root_stage." + StringUtils.lowerCase((String)this.name());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EQTreeRootStage value : EQTreeRootStage.values()) {
            String key = EQTreeRootStage.key((EQTreeRootStage)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        ROOT_STAGE_TYPES = ImmutableList.of((Object)COMMISSION, (Object)ADDENDUM, (Object)COST_ESTIMATE, (Object)QUOTATION, (Object)CALCULATION, (Object)INQUIRY);
        ROOT_STAGE_TYPE_CHILDREN = ImmutableMultimap.builder().put((Object)COMMISSION, (Object)EQStageType.COMMISSION).put((Object)ADDENDUM, (Object)EQStageType.COMMISSION__ADDENDUM).put((Object)ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM).put((Object)COST_ESTIMATE, (Object)EQStageType.COMMISSION__COST_ESTIMATE).put((Object)QUOTATION, (Object)EQStageType.QUOTATION).put((Object)CALCULATION, (Object)EQStageType.CALCULATION).put((Object)INQUIRY, (Object)EQStageType.INQUIRY).build();
    }
}

