/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.message.Translatable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EQStageState implements Translatable
{
    UNKNOWN,
    TEMPORARY,
    REWORK,
    NOTIFIED,
    ACTIVE,
    CLOSED,
    ARCHIVED,
    APPROVED,
    SUBMITTED,
    COMMISSIONED,
    DESIGNATED_COMMISSION,
    DESIGNATED_COST_UNIT,
    ACCEPTED,
    REJECTED;

    private static final Map<String, EQStageState> LOOKUP;
    @Nonnull
    public static Iterable<EQStageState> ACCOUNTABLE_STAGE_STATES;
    @Nonnull
    public static Iterable<EQStageState> ADDITIONAL_MEASUREMENT_STAGE_STATES;
    @Nonnull
    public static final Collection<EQStageState> ALL_VALID;
    @Nonnull
    public static final Collection<EQStageState> ALL_STATES_WITHOUT_ARCHIVED;
    @Nonnull
    public static final Iterable<EQStageState> FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES;
    @Nonnull
    public static final Iterable<EQStageState> BUDGET_STATES__CONSIDER_VERSION;
    @Nonnull
    public static final Iterable<EQStageState> BUDGET_STATES__IGNORE_VERSION;
    public static final Iterable<EQStageState> VERSIONABLE_CHILD_STATES;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EQStageState lookup(@NonNull String candidate, @NonNull EQStageState defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EQStageState.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EQStageState> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EQStageState.key((String)candidate);
        return Optional.ofNullable((EQStageState)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EQStageState item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EQStageState.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.stage_state." + EQStageState.key((EQStageState)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EQStageState value : EQStageState.values()) {
            String key = EQStageState.key((EQStageState)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        ACCOUNTABLE_STAGE_STATES = ImmutableList.of((Object)ACTIVE, (Object)CLOSED);
        ADDITIONAL_MEASUREMENT_STAGE_STATES = ImmutableList.of((Object)DESIGNATED_COST_UNIT);
        ALL_VALID = ImmutableSet.of((Object)TEMPORARY, (Object)NOTIFIED, (Object)REWORK, (Object)ACTIVE, (Object)CLOSED, (Object)ARCHIVED, (Object[])new EQStageState[]{APPROVED, SUBMITTED, COMMISSIONED, DESIGNATED_COMMISSION, DESIGNATED_COST_UNIT, ACCEPTED, REJECTED});
        ALL_STATES_WITHOUT_ARCHIVED = ImmutableSet.of((Object)TEMPORARY, (Object)NOTIFIED, (Object)REWORK, (Object)ACTIVE, (Object)CLOSED, (Object)APPROVED, (Object[])new EQStageState[]{SUBMITTED, COMMISSIONED, DESIGNATED_COMMISSION, DESIGNATED_COST_UNIT, ACCEPTED, REJECTED});
        FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES = ImmutableSet.of((Object)TEMPORARY, (Object)APPROVED, (Object)SUBMITTED, (Object)DESIGNATED_COMMISSION);
        BUDGET_STATES__CONSIDER_VERSION = ImmutableSet.of((Object)ACTIVE, (Object)CLOSED, (Object)REWORK);
        BUDGET_STATES__IGNORE_VERSION = ImmutableSet.of((Object)ACTIVE, (Object)CLOSED, (Object)REWORK, (Object)ARCHIVED, (Object)TEMPORARY);
        VERSIONABLE_CHILD_STATES = ImmutableSet.of((Object)TEMPORARY, (Object)ACTIVE);
    }
}

