/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EQEntityState {
    UNKNOWN(-1),
    INQUIRY_TEMPORARY(0),
    INQUIRY_NOTIFIED(1),
    INQUIRY_ARCHIVED(-10),
    CALCULATION_TEMPORARY(3),
    CALCULATION_ARCHIVED(-10),
    QUOTATION_TEMPORARY(5),
    QUOTATION_APPROVED(6),
    QUOTATION_SUBMITTED(7),
    QUOTATION_DESIGNATED_COMMISSION(8),
    QUOTATION_ARCHIVED(-10),
    COMMISSION_TEMPORARY(10),
    COMMISSION_REWORK(11),
    COMMISSION_ACTIVE(12),
    COMMISSION_CLOSED(13),
    COMMISSION_ARCHIVED(-10);

    private final int value;
    public static final Iterable<EQEntityState> ALL;
    public static final Iterable<EQEntityState> ALL_VALID;
    public static final Iterable<EQEntityState> ALL_NON_ARCHIVED;
    private static final Map<String, EQEntityState> LOOKUP;

    private EQEntityState(int value) {
        this.value = value;
    }

    public boolean higher(@NonNull EQEntityState entityState) {
        if (entityState == null) {
            throw new NullPointerException("entityState is marked non-null but is null");
        }
        return this.value > entityState.value;
    }

    public boolean equal(@NonNull EQEntityState entityState) {
        if (entityState == null) {
            throw new NullPointerException("entityState is marked non-null but is null");
        }
        return this.value == entityState.value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EQEntityState lookup(@NonNull String candidate, @NonNull EQEntityState defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EQEntityState.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EQEntityState> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EQEntityState.key((String)candidate);
        return Optional.ofNullable((EQEntityState)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EQEntityState item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EQEntityState.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ALL = ImmutableSet.copyOf((Object[])EQEntityState.values());
        ALL_VALID = ImmutableSet.copyOf(Arrays.stream(EQEntityState.values()).filter(item -> item != UNKNOWN).iterator());
        ALL_NON_ARCHIVED = ImmutableSet.copyOf(Arrays.stream(EQEntityState.values()).filter(item -> !StringUtils.endsWithIgnoreCase((CharSequence)item.name(), (CharSequence)"ARCHIVED")).iterator());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EQEntityState value : EQEntityState.values()) {
            String key = EQEntityState.key((EQEntityState)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

