/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.queue;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EReferenceType {
    UNKNOWN,
    EXT_PSS_RELEASE_ORDER,
    INVOICE,
    MEASUREMENT,
    CUSTOMER,
    PSS_RELEASE_ORDER,
    QUOTATION,
    USER;

    private static final Map<String, EReferenceType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EReferenceType lookup(@NonNull String candidate, @NonNull EReferenceType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EReferenceType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EReferenceType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EReferenceType.key((String)candidate);
        return Optional.ofNullable((EReferenceType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EReferenceType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return EReferenceType.key((String)type.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EReferenceType value : EReferenceType.values()) {
            String key = EReferenceType.key((EReferenceType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

