/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.project;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;

@Entity(name="SubProject")
@Table(name="SUB_PROJECT")
public class SubProject
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUB_PROJECT_SEQ")
    @SequenceGenerator(sequenceName="SUB_PROJECT_SEQ", allocationSize=1, name="SUB_PROJECT_SEQ")
    private Long id;
    @Convert(converter=NullStringConverter.class)
    @Column(name="name", nullable=false, length=250)
    private String name;
    @Column(name="search_index_state", length=50)
    @Enumerated(value=EnumType.STRING)
    private ESearchIndexState searchIndexState;
    @JoinColumn(name="q_entity_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private QEntity qEntity;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="subProject")
    private Set<Quotation> stages;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        SubProject that = (SubProject)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ESearchIndexState getSearchIndexState() {
        return this.searchIndexState;
    }

    public QEntity getQEntity() {
        return this.qEntity;
    }

    public Set<Quotation> getStages() {
        return this.stages;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSearchIndexState(ESearchIndexState searchIndexState) {
        this.searchIndexState = searchIndexState;
    }

    public void setQEntity(QEntity qEntity) {
        this.qEntity = qEntity;
    }

    public void setStages(Set<Quotation> stages) {
        this.stages = stages;
    }

    public String toString() {
        return "SubProject(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", searchIndexState=" + String.valueOf(this.getSearchIndexState()) + ")";
    }
}

