/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.invoice;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="TaxKey")
@Table(name="TAX_KEY")
public class TaxKey
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TAX_KEY_SEQ")
    @SequenceGenerator(sequenceName="TAX_KEY_SEQ", allocationSize=1, name="TAX_KEY_SEQ")
    @Access(value=AccessType.PROPERTY)
    private Long id;
    @Convert(converter=NullStringConverter.class)
    @Column(name="name", length=50)
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="invoice_type", length=50)
    private EInvoiceType invoiceType;
    @Column(name="tax_key", length=50)
    private String taxKey;
    @Column(name="vat")
    private BigDecimal vat;
    @Column(name="account", length=50)
    private String account;
    @Column(name="counter_account", length=50)
    private String counterAccount;
    @Column(name="warranty_sec_ret_account", length=50)
    private String warrantySecurityRetentionAccount;
    @Column(name="fulfillment_sec_ret_account", length=50)
    private String fulfillmentSecurityRetentionAccount;
    @Column(name="flag_subcontractor_ext_service")
    private Boolean flagSubContractorAsExternalServiceAccounting;
    @Column(name="flag_company_group")
    private Boolean flagCompanyGroup;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        TaxKey invoice = (TaxKey)o;
        return this.id != null && Objects.equals(this.id, invoice.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public EInvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    public String getTaxKey() {
        return this.taxKey;
    }

    public BigDecimal getVat() {
        return this.vat;
    }

    public String getAccount() {
        return this.account;
    }

    public String getCounterAccount() {
        return this.counterAccount;
    }

    public String getWarrantySecurityRetentionAccount() {
        return this.warrantySecurityRetentionAccount;
    }

    public String getFulfillmentSecurityRetentionAccount() {
        return this.fulfillmentSecurityRetentionAccount;
    }

    public Boolean getFlagSubContractorAsExternalServiceAccounting() {
        return this.flagSubContractorAsExternalServiceAccounting;
    }

    public Boolean getFlagCompanyGroup() {
        return this.flagCompanyGroup;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInvoiceType(EInvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }

    public void setTaxKey(String taxKey) {
        this.taxKey = taxKey;
    }

    public void setVat(BigDecimal vat) {
        this.vat = vat;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setCounterAccount(String counterAccount) {
        this.counterAccount = counterAccount;
    }

    public void setWarrantySecurityRetentionAccount(String warrantySecurityRetentionAccount) {
        this.warrantySecurityRetentionAccount = warrantySecurityRetentionAccount;
    }

    public void setFulfillmentSecurityRetentionAccount(String fulfillmentSecurityRetentionAccount) {
        this.fulfillmentSecurityRetentionAccount = fulfillmentSecurityRetentionAccount;
    }

    public void setFlagSubContractorAsExternalServiceAccounting(Boolean flagSubContractorAsExternalServiceAccounting) {
        this.flagSubContractorAsExternalServiceAccounting = flagSubContractorAsExternalServiceAccounting;
    }

    public void setFlagCompanyGroup(Boolean flagCompanyGroup) {
        this.flagCompanyGroup = flagCompanyGroup;
    }

    public String toString() {
        return "TaxKey(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", invoiceType=" + String.valueOf(this.getInvoiceType()) + ", taxKey=" + this.getTaxKey() + ", vat=" + String.valueOf(this.getVat()) + ", account=" + this.getAccount() + ", counterAccount=" + this.getCounterAccount() + ", warrantySecurityRetentionAccount=" + this.getWarrantySecurityRetentionAccount() + ", fulfillmentSecurityRetentionAccount=" + this.getFulfillmentSecurityRetentionAccount() + ", flagSubContractorAsExternalServiceAccounting=" + this.getFlagSubContractorAsExternalServiceAccounting() + ", flagCompanyGroup=" + this.getFlagCompanyGroup() + ")";
    }
}

