/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.invoice;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceAttachmentType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="InvoiceAttachment")
@Table(name="INVOICE_ATTACHMENT")
public class InvoiceAttachment
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="INVOICE_ATTACHMENT_SEQ")
    @SequenceGenerator(sequenceName="INVOICE_ATTACHMENT_SEQ", allocationSize=1, name="INVOICE_ATTACHMENT_SEQ")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="invoice_attachment_type")
    private EInvoiceAttachmentType invoiceAttachmentType;
    @Convert(converter=NullStringConverter.class)
    @Column(name="name", length=250)
    private String name;
    @Column(name="ttl", nullable=false)
    private LocalDateTime ttl;
    @Column(name="option_print")
    private Boolean optionPrint;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="invoice_id")
    private Invoice invoice;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="file_store_id")
    private FileStore fileStore;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="file_store_pdf_id")
    private FileStore fileStorePDF;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        InvoiceAttachment invoiceAttachment = (InvoiceAttachment)o;
        return this.getId() != null && Objects.equals(this.getId(), invoiceAttachment.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public EInvoiceAttachmentType getInvoiceAttachmentType() {
        return this.invoiceAttachmentType;
    }

    public String getName() {
        return this.name;
    }

    public LocalDateTime getTtl() {
        return this.ttl;
    }

    public Boolean getOptionPrint() {
        return this.optionPrint;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public FileStore getFileStorePDF() {
        return this.fileStorePDF;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setInvoiceAttachmentType(EInvoiceAttachmentType invoiceAttachmentType) {
        this.invoiceAttachmentType = invoiceAttachmentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTtl(LocalDateTime ttl) {
        this.ttl = ttl;
    }

    public void setOptionPrint(Boolean optionPrint) {
        this.optionPrint = optionPrint;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public void setFileStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    public void setFileStorePDF(FileStore fileStorePDF) {
        this.fileStorePDF = fileStorePDF;
    }

    public String toString() {
        return "InvoiceAttachment(super=" + super.toString() + ", id=" + this.getId() + ", invoiceAttachmentType=" + String.valueOf(this.getInvoiceAttachmentType()) + ", name=" + this.getName() + ", ttl=" + String.valueOf(this.getTtl()) + ", optionPrint=" + this.getOptionPrint() + ")";
    }
}

