/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.generic;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.message.Translatable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EDayType implements Translatable
{
    UNKNOWN,
    STANDARD,
    BANKING_HOLIDAY;

    private static final Map<String, EDayType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EDayType lookup(@NonNull String candidate, @NonNull EDayType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EDayType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EDayType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EDayType.key((String)candidate);
        return Optional.ofNullable((EDayType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EDayType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EDayType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.day_type." + this.name();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EDayType value : EDayType.values()) {
            String key = EDayType.key((EDayType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

