/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.payroll;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccountTransaction;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="PayrollMonthItem")
@Table(name="PAYROLL_MONTH_ITEM")
public class PayrollMonthItem
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PAYROLL_MONTH_ITEM_SEQ")
    @SequenceGenerator(sequenceName="PAYROLL_MONTH_ITEM_SEQ", allocationSize=1, name="PAYROLL_MONTH_ITEM_SEQ")
    private Long id;
    @Column(name="reference_id", length=50)
    private String referenceId;
    @JoinColumn(name="payroll_month_id")
    @ManyToOne
    private PayrollMonth payrollMonth;
    @Enumerated(value=EnumType.STRING)
    @Column(name="payroll_item_clazz", length=50)
    private EPayrollItemClazz payrollItemClazz;
    @JoinColumn(name="payroll_item_type_id")
    @ManyToOne
    private PayrollItemType payrollItemType;
    @Convert(converter=NullStringConverter.class)
    @Column(name="quotation_number", length=12)
    private String quotationNumber;
    @Column(name="value")
    private BigDecimal value;
    @Column(name="remarks", length=250)
    @Convert(converter=NullStringConverter.class)
    private String remarks;
    @Column(name="cost_center_squad", length=12)
    @Convert(converter=NullStringConverter.class)
    private String costCenterSquad;
    @Column(name="sequential_number", length=50)
    private Integer sequentialNumber;
    @JoinColumn(name="quotation_id")
    @ManyToOne
    private Quotation quotation;
    @JoinColumn(name="recipient_user_id")
    @ManyToOne
    private User recipient;
    @JoinColumn(name="sender_user_id")
    @ManyToOne
    private User sender;
    @JoinColumn(name="project_id")
    @ManyToOne
    private Project project;
    @JoinColumn(name="wage_account_transaction_id")
    @OneToOne(cascade={CascadeType.ALL})
    private WageAccountTransaction wageAccountTransaction;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        PayrollMonthItem that = (PayrollMonthItem)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public PayrollMonth getPayrollMonth() {
        return this.payrollMonth;
    }

    public EPayrollItemClazz getPayrollItemClazz() {
        return this.payrollItemClazz;
    }

    public PayrollItemType getPayrollItemType() {
        return this.payrollItemType;
    }

    public String getQuotationNumber() {
        return this.quotationNumber;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getCostCenterSquad() {
        return this.costCenterSquad;
    }

    public Integer getSequentialNumber() {
        return this.sequentialNumber;
    }

    public Quotation getQuotation() {
        return this.quotation;
    }

    public User getRecipient() {
        return this.recipient;
    }

    public User getSender() {
        return this.sender;
    }

    public Project getProject() {
        return this.project;
    }

    public WageAccountTransaction getWageAccountTransaction() {
        return this.wageAccountTransaction;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setPayrollMonth(PayrollMonth payrollMonth) {
        this.payrollMonth = payrollMonth;
    }

    public void setPayrollItemClazz(EPayrollItemClazz payrollItemClazz) {
        this.payrollItemClazz = payrollItemClazz;
    }

    public void setPayrollItemType(PayrollItemType payrollItemType) {
        this.payrollItemType = payrollItemType;
    }

    public void setQuotationNumber(String quotationNumber) {
        this.quotationNumber = quotationNumber;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setCostCenterSquad(String costCenterSquad) {
        this.costCenterSquad = costCenterSquad;
    }

    public void setSequentialNumber(Integer sequentialNumber) {
        this.sequentialNumber = sequentialNumber;
    }

    public void setQuotation(Quotation quotation) {
        this.quotation = quotation;
    }

    public void setRecipient(User recipient) {
        this.recipient = recipient;
    }

    public void setSender(User sender) {
        this.sender = sender;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setWageAccountTransaction(WageAccountTransaction wageAccountTransaction) {
        this.wageAccountTransaction = wageAccountTransaction;
    }

    public String toString() {
        return "PayrollMonthItem(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", payrollItemClazz=" + String.valueOf(this.getPayrollItemClazz()) + ", quotationNumber=" + this.getQuotationNumber() + ", value=" + String.valueOf(this.getValue()) + ", remarks=" + this.getRemarks() + ", costCenterSquad=" + this.getCostCenterSquad() + ", sequentialNumber=" + this.getSequentialNumber() + ")";
    }
}

