/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.customer;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.EAddressType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="Address")
@Table(name="ADDRESS")
public class Address
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ADDRESS_SEQ")
    @SequenceGenerator(sequenceName="ADDRESS_SEQ", allocationSize=1, name="ADDRESS_SEQ")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="address_type", length=50)
    private EAddressType addressType;
    @Convert(converter=NullStringConverter.class)
    @Column(name="name", length=250)
    private String name;
    @Convert(converter=NullStringConverter.class)
    @Column(name="address_suffix", length=250)
    private String addressSuffix;
    @Convert(converter=NullStringConverter.class)
    @Column(name="po_box", length=250)
    private String poBox;
    @Convert(converter=NullStringConverter.class)
    @Column(name="street", length=250)
    private String street;
    @Convert(converter=NullStringConverter.class)
    @Column(name="street_no", length=50)
    private String streetNo;
    @Convert(converter=NullStringConverter.class)
    @Column(name="city", length=250)
    private String city;
    @Convert(converter=NullStringConverter.class)
    @Column(name="zip_code", length=10)
    private String zipCode;
    @Convert(converter=NullStringConverter.class)
    @Column(name="email", length=250)
    private String email;
    @Convert(converter=NullStringConverter.class)
    @Column(name="portal", length=1000)
    private String portal;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks", length=250)
    private String remarks;
    @Column(name="valid_begin")
    private LocalDate validBegin;
    @Column(name="valid_end")
    private LocalDate validEnd;
    @JoinColumn(name="reference_address_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Address referenceAddress;
    @JoinColumn(name="customer_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Customer customer;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        Address address = (Address)o;
        return this.id != null && Objects.equals(this.id, address.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public EAddressType getAddressType() {
        return this.addressType;
    }

    public String getName() {
        return this.name;
    }

    public String getAddressSuffix() {
        return this.addressSuffix;
    }

    public String getPoBox() {
        return this.poBox;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreetNo() {
        return this.streetNo;
    }

    public String getCity() {
        return this.city;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPortal() {
        return this.portal;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public LocalDate getValidBegin() {
        return this.validBegin;
    }

    public LocalDate getValidEnd() {
        return this.validEnd;
    }

    public Address getReferenceAddress() {
        return this.referenceAddress;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAddressType(EAddressType addressType) {
        this.addressType = addressType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddressSuffix(String addressSuffix) {
        this.addressSuffix = addressSuffix;
    }

    public void setPoBox(String poBox) {
        this.poBox = poBox;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setStreetNo(String streetNo) {
        this.streetNo = streetNo;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPortal(String portal) {
        this.portal = portal;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setValidBegin(LocalDate validBegin) {
        this.validBegin = validBegin;
    }

    public void setValidEnd(LocalDate validEnd) {
        this.validEnd = validEnd;
    }

    public void setReferenceAddress(Address referenceAddress) {
        this.referenceAddress = referenceAddress;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String toString() {
        return "Address(super=" + super.toString() + ", id=" + this.getId() + ", addressType=" + String.valueOf(this.getAddressType()) + ", name=" + this.getName() + ", addressSuffix=" + this.getAddressSuffix() + ", poBox=" + this.getPoBox() + ", street=" + this.getStreet() + ", streetNo=" + this.getStreetNo() + ", city=" + this.getCity() + ", zipCode=" + this.getZipCode() + ", email=" + this.getEmail() + ", portal=" + this.getPortal() + ", remarks=" + this.getRemarks() + ", validBegin=" + String.valueOf(this.getValidBegin()) + ", validEnd=" + String.valueOf(this.getValidEnd()) + ")";
    }
}

