/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.businessunit;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="UserCostCenter")
@Table(name="USER_COST_CENTER")
public class UserCostCenter
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_COST_CENTER_SEQ")
    @SequenceGenerator(sequenceName="USER_COST_CENTER_SEQ", allocationSize=1, name="USER_COST_CENTER_SEQ")
    private Long id;
    @Column(name="VALID_BEGIN")
    private LocalDate validBegin;
    @Column(name="VALID_END")
    private LocalDate validEnd;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @Column(name="cost_center", length=15)
    private String costCenter;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks", length=250)
    private String remarks;
    @Column(name="flag_lead")
    private Boolean flagLead;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        UserCostCenter that = (UserCostCenter)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public LocalDate getValidBegin() {
        return this.validBegin;
    }

    public LocalDate getValidEnd() {
        return this.validEnd;
    }

    public User getUser() {
        return this.user;
    }

    public String getCostCenter() {
        return this.costCenter;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Boolean getFlagLead() {
        return this.flagLead;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setValidBegin(LocalDate validBegin) {
        this.validBegin = validBegin;
    }

    public void setValidEnd(LocalDate validEnd) {
        this.validEnd = validEnd;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setFlagLead(Boolean flagLead) {
        this.flagLead = flagLead;
    }

    public String toString() {
        return "UserCostCenter(super=" + super.toString() + ", id=" + this.getId() + ", validBegin=" + String.valueOf(this.getValidBegin()) + ", validEnd=" + String.valueOf(this.getValidEnd()) + ", costCenter=" + this.getCostCenter() + ", remarks=" + this.getRemarks() + ", flagLead=" + this.getFlagLead() + ")";
    }
}

