/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.validation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.internal.message.Message;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class ValidationResult {
    public static final ValidationResult NO_ERROR = new ValidationResult(true, (Iterable)ImmutableList.of());
    private final boolean success;
    @NonNull
    private final Iterable<Message> messages;

    @Nonnull
    public static ValidationResult error(@NonNull Message error) {
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        return new ValidationResult(false, (Iterable)ImmutableList.of((Object)error));
    }

    @Nonnull
    public static ValidationResult error(@NonNull Iterable<Message> errors) {
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        return new ValidationResult(true, (Iterable)ImmutableList.copyOf(errors));
    }

    @Nonnull
    public static ValidationResult from(@NonNull Iterable<Message> errors) {
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        boolean containsErrors = Iterables.isEmpty(errors);
        return new ValidationResult(containsErrors, (Iterable)ImmutableList.copyOf(errors));
    }

    private ValidationResult(boolean success, @NonNull Iterable<Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.success = success;
        this.messages = messages;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @NonNull
    public Iterable<Message> getMessages() {
        return this.messages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Iterable this$messages = this.getMessages();
        Iterable other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !this$messages.equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Iterable $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : $messages.hashCode());
        return result;
    }

    public String toString() {
        return "ValidationResult(success=" + this.isSuccess() + ", messages=" + String.valueOf(this.getMessages()) + ")";
    }
}

