/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.user;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.message.Translatable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EAutoCompleteMode implements Translatable
{
    ALL,
    ALL_ACTIVE_AT,
    ALL_ACTIVE_AT_DATE,
    ALL_ACTIVE_IN_DATE_RANGE,
    PAYROLL_MONTH;

    private static final Map<String, EAutoCompleteMode> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EAutoCompleteMode lookup(@NonNull String candidate, @NonNull EAutoCompleteMode defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EAutoCompleteMode.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EAutoCompleteMode> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EAutoCompleteMode.key((String)candidate);
        return Optional.ofNullable((EAutoCompleteMode)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EAutoCompleteMode item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EAutoCompleteMode.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.autocomplete_mode." + this.name();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EAutoCompleteMode value : EAutoCompleteMode.values()) {
            String key = EAutoCompleteMode.key((EAutoCompleteMode)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

