/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.reporting;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EReportType {
    MEASUREMENT_VALUE_SUMS_PER_MONTH,
    MEASUREMENT_WAGE_SUMS_PER_MONTH,
    STAGE_BURN_DOWN;

    private static final Map<String, EReportType> LOOKUP;

    @Nonnull
    public static Iterable<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EReportType lookup(@NonNull String candidate, @NonNull EReportType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EReportType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EReportType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EReportType.key((String)candidate);
        return Optional.ofNullable((EReportType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EReportType hint) {
        if (hint == null) {
            throw new NullPointerException("hint is marked non-null but is null");
        }
        return EReportType.key((String)hint.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EReportType value : EReportType.values()) {
            String key = EReportType.key((EReportType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

