/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.quotation;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionComparator;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionDefaultComparator;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionGroupingLevelComparator;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionSequentialNumberComparator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EQuotationPositionSortOption {
    DEFAULT((QuotationPositionComparator)QuotationPositionDefaultComparator.of()),
    GROUPING_LEVELS_ASC((QuotationPositionComparator)QuotationPositionGroupingLevelComparator.of((boolean)true)),
    SEQUENTIAL_NUMBER_ASC((QuotationPositionComparator)QuotationPositionSequentialNumberComparator.of());

    private final QuotationPositionComparator comparator;
    private static final Map<String, EQuotationPositionSortOption> LOOKUP;

    private EQuotationPositionSortOption(QuotationPositionComparator comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        this.comparator = comparator;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EQuotationPositionSortOption lookup(@NonNull String candidate, @NonNull EQuotationPositionSortOption defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EQuotationPositionSortOption.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EQuotationPositionSortOption> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EQuotationPositionSortOption.key((String)candidate);
        return Optional.ofNullable((EQuotationPositionSortOption)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EQuotationPositionSortOption item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EQuotationPositionSortOption.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    public QuotationPositionComparator getComparator() {
        return this.comparator;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EQuotationPositionSortOption value : EQuotationPositionSortOption.values()) {
            String key = EQuotationPositionSortOption.key((EQuotationPositionSortOption)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

