/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.print.measurement;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintConfiguration;
import java.awt.Color;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class MeasurementGroupedPrintConfiguration
extends MeasurementPrintConfiguration {
    public static final Color DEFAULT_HEADER_BG_COLOR = Color.LIGHT_GRAY;
    private final Color headerBgColor;

    private MeasurementGroupedPrintConfiguration(Color headerBgColor, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions, @NonNull LocalDate printDate, @Nullable LocalDate transferOfPerilsDate) {
        super(headerBgColor, booleanPrintOptions, printDate, transferOfPerilsDate);
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        if (printDate == null) {
            throw new NullPointerException("printDate is marked non-null but is null");
        }
        this.headerBgColor = headerBgColor;
    }

    @Nonnull
    public static MeasurementGroupedPrintConfiguration of(@NonNull Color color, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions, @NonNull LocalDate printDate, @Nullable LocalDate transferOfPerilsDate) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        if (printDate == null) {
            throw new NullPointerException("printDate is marked non-null but is null");
        }
        return new MeasurementGroupedPrintConfiguration(color, (Iterable)ImmutableSet.copyOf(booleanPrintOptions), printDate, transferOfPerilsDate);
    }

    public Color getHeaderBgColor() {
        return this.headerBgColor;
    }
}

