/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.payroll;

import com.google.common.collect.Range;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import java.time.LocalDate;
import lombok.NonNull;

public class PayrollMonthFilter {
    private int page;
    private int size;
    private boolean includeInactive;
    private boolean includeTemporary;
    @NonNull
    private CostCenterFilter costCenterFilter;
    @NonNull
    private Range<LocalDate> accountingMonth;

    private PayrollMonthFilter(int page, int size, boolean includeInactive, boolean includeTemporary, @NonNull CostCenterFilter costCenterFilter, @NonNull Range<LocalDate> accountingMonth) {
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        this.page = page;
        this.size = size;
        this.includeInactive = includeInactive;
        this.includeTemporary = includeTemporary;
        this.costCenterFilter = costCenterFilter;
        this.accountingMonth = accountingMonth;
    }

    public static PayrollMonthFilter of(int page, int size, boolean includeInactive, boolean includeTemporary, @NonNull CostCenterFilter costCenterFilter, @NonNull Range<LocalDate> accountingMonth) {
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return new PayrollMonthFilter(page, size, includeInactive, includeTemporary, costCenterFilter, accountingMonth);
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isIncludeInactive() {
        return this.includeInactive;
    }

    public boolean isIncludeTemporary() {
        return this.includeTemporary;
    }

    @NonNull
    public CostCenterFilter getCostCenterFilter() {
        return this.costCenterFilter;
    }

    @NonNull
    public Range<LocalDate> getAccountingMonth() {
        return this.accountingMonth;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setIncludeInactive(boolean includeInactive) {
        this.includeInactive = includeInactive;
    }

    public void setIncludeTemporary(boolean includeTemporary) {
        this.includeTemporary = includeTemporary;
    }

    public void setCostCenterFilter(@NonNull CostCenterFilter costCenterFilter) {
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        this.costCenterFilter = costCenterFilter;
    }

    public void setAccountingMonth(@NonNull Range<LocalDate> accountingMonth) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        this.accountingMonth = accountingMonth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayrollMonthFilter)) {
            return false;
        }
        PayrollMonthFilter other = (PayrollMonthFilter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.isIncludeInactive() != other.isIncludeInactive()) {
            return false;
        }
        if (this.isIncludeTemporary() != other.isIncludeTemporary()) {
            return false;
        }
        CostCenterFilter this$costCenterFilter = this.getCostCenterFilter();
        CostCenterFilter other$costCenterFilter = other.getCostCenterFilter();
        if (this$costCenterFilter == null ? other$costCenterFilter != null : !this$costCenterFilter.equals(other$costCenterFilter)) {
            return false;
        }
        Range this$accountingMonth = this.getAccountingMonth();
        Range other$accountingMonth = other.getAccountingMonth();
        return !(this$accountingMonth == null ? other$accountingMonth != null : !this$accountingMonth.equals(other$accountingMonth));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayrollMonthFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        result = result * 59 + (this.isIncludeInactive() ? 79 : 97);
        result = result * 59 + (this.isIncludeTemporary() ? 79 : 97);
        CostCenterFilter $costCenterFilter = this.getCostCenterFilter();
        result = result * 59 + ($costCenterFilter == null ? 43 : $costCenterFilter.hashCode());
        Range $accountingMonth = this.getAccountingMonth();
        result = result * 59 + ($accountingMonth == null ? 43 : $accountingMonth.hashCode());
        return result;
    }

    public String toString() {
        return "PayrollMonthFilter(page=" + this.getPage() + ", size=" + this.getSize() + ", includeInactive=" + this.isIncludeInactive() + ", includeTemporary=" + this.isIncludeTemporary() + ", costCenterFilter=" + String.valueOf(this.getCostCenterFilter()) + ", accountingMonth=" + String.valueOf(this.getAccountingMonth()) + ")";
    }
}

