/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.payroll;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPayrollItemClazzFilterOption implements Translatable
{
    ALL,
    AUXILIARY_WAGE,
    INCENTIVE_PAYMENT;

    private static final Map<String, EPayrollItemClazzFilterOption> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPayrollItemClazzFilterOption lookup(@NonNull String candidate, @NonNull EPayrollItemClazzFilterOption defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPayrollItemClazzFilterOption.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPayrollItemClazzFilterOption> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPayrollItemClazzFilterOption.key((String)candidate);
        return Optional.ofNullable((EPayrollItemClazzFilterOption)LOOKUP.get(key));
    }

    @NonNull
    public static EPayrollItemClazzFilterOption lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional candidateEnum = EPayrollItemClazzFilterOption.lookup((String)candidate);
        if (candidateEnum.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_CLAZZ_FILTER_OPTION), (String)candidate, EPayrollItemClazzFilterOption.class, EPayrollItemClazzFilterOption::allowedKeys);
        }
        return (EPayrollItemClazzFilterOption)candidateEnum.get();
    }

    @Nonnull
    private static String key(@NonNull EPayrollItemClazzFilterOption item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EPayrollItemClazzFilterOption.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_clazz_filter_option." + EPayrollItemClazzFilterOption.key((EPayrollItemClazzFilterOption)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPayrollItemClazzFilterOption value : EPayrollItemClazzFilterOption.values()) {
            String key = EPayrollItemClazzFilterOption.key((EPayrollItemClazzFilterOption)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

