/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.invoice;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.invoice.EImportResultType;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class InvoicePdfExtraction {
    private final EImportResultType importResultType;
    @NonNull
    private final String errorMessage;
    @NonNull
    private final EPdfExtractType pdfExtractType;
    @NonNull
    private final String orderNumber1;
    @NonNull
    private final String orderNumber2;
    @NonNull
    private final String referenceNumber;
    @NonNull
    private final String voucherNumber;
    @NonNull
    private final String creditVoucherNumber;
    @NonNull
    private final LocalDate orderDate;
    @NonNull
    private final LocalDate voucherDate;
    @NonNull
    private final String costCenter;
    @NonNull
    private final LocalDate projectExecutionFrom;
    @NonNull
    private final LocalDate projectExecutionEnd;
    @NonNull
    private final BigDecimal valueOverallNet;
    @NonNull
    private final BigDecimal VatPercent;
    @NonNull
    private final BigDecimal valueOverallVAT;
    @NonNull
    private final BigDecimal valueOverallGross;
    @NonNull
    private final List<String> measurementNumbers;

    @Nonnull
    public static InvoicePdfExtraction warn(@NonNull String message, @NonNull EPdfExtractType pdfExtractType) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        return new InvoicePdfExtraction(EImportResultType.WARN, message, pdfExtractType, "", "", "", "", "", LocalDate.EPOCH, LocalDate.EPOCH, "", LocalDate.EPOCH, LocalDate.EPOCH, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (List)ImmutableList.of());
    }

    @Nonnull
    public static InvoicePdfExtraction error(@NonNull String message, @NonNull EPdfExtractType pdfExtractType) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        return new InvoicePdfExtraction(EImportResultType.ERROR, message, pdfExtractType, "", "", "", "", "", LocalDate.EPOCH, LocalDate.EPOCH, "", LocalDate.EPOCH, LocalDate.EPOCH, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (List)ImmutableList.of());
    }

    @Nonnull
    public static InvoicePdfExtraction success(@NonNull EPdfExtractType pdfExtractType, @NonNull String orderNumber1, @NonNull String orderNumber2, @NonNull String referenceNumber, @NonNull String voucherNumber, @NonNull String creditVoucherNumber, @NonNull LocalDate orderDate, @NonNull LocalDate voucherDate, @NonNull String costCenter, @NonNull LocalDate projectExecutionFrom, @NonNull LocalDate projectExecutionEnd, @NonNull BigDecimal valueOverallNet, @NonNull BigDecimal VAT, @NonNull BigDecimal valueOverallVAT, @NonNull BigDecimal valueOverallGross, @NonNull List<String> measurementNumbers) {
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        if (orderNumber1 == null) {
            throw new NullPointerException("orderNumber1 is marked non-null but is null");
        }
        if (orderNumber2 == null) {
            throw new NullPointerException("orderNumber2 is marked non-null but is null");
        }
        if (referenceNumber == null) {
            throw new NullPointerException("referenceNumber is marked non-null but is null");
        }
        if (voucherNumber == null) {
            throw new NullPointerException("voucherNumber is marked non-null but is null");
        }
        if (creditVoucherNumber == null) {
            throw new NullPointerException("creditVoucherNumber is marked non-null but is null");
        }
        if (orderDate == null) {
            throw new NullPointerException("orderDate is marked non-null but is null");
        }
        if (voucherDate == null) {
            throw new NullPointerException("voucherDate is marked non-null but is null");
        }
        if (costCenter == null) {
            throw new NullPointerException("costCenter is marked non-null but is null");
        }
        if (projectExecutionFrom == null) {
            throw new NullPointerException("projectExecutionFrom is marked non-null but is null");
        }
        if (projectExecutionEnd == null) {
            throw new NullPointerException("projectExecutionEnd is marked non-null but is null");
        }
        if (valueOverallNet == null) {
            throw new NullPointerException("valueOverallNet is marked non-null but is null");
        }
        if (VAT == null) {
            throw new NullPointerException("VAT is marked non-null but is null");
        }
        if (valueOverallVAT == null) {
            throw new NullPointerException("valueOverallVAT is marked non-null but is null");
        }
        if (valueOverallGross == null) {
            throw new NullPointerException("valueOverallGross is marked non-null but is null");
        }
        if (measurementNumbers == null) {
            throw new NullPointerException("measurementNumbers is marked non-null but is null");
        }
        return new InvoicePdfExtraction(EImportResultType.INFO, "", pdfExtractType, orderNumber1, orderNumber2, referenceNumber, voucherNumber, creditVoucherNumber, orderDate, voucherDate, costCenter, projectExecutionFrom, projectExecutionEnd, valueOverallNet, VAT, valueOverallVAT, valueOverallGross, (List)ImmutableList.copyOf(measurementNumbers));
    }

    public InvoicePdfExtraction(EImportResultType importResultType, @NonNull String errorMessage, @NonNull EPdfExtractType pdfExtractType, @NonNull String orderNumber1, @NonNull String orderNumber2, @NonNull String referenceNumber, @NonNull String voucherNumber, @NonNull String creditVoucherNumber, @NonNull LocalDate orderDate, @NonNull LocalDate voucherDate, @NonNull String costCenter, @NonNull LocalDate projectExecutionFrom, @NonNull LocalDate projectExecutionEnd, @NonNull BigDecimal valueOverallNet, @NonNull BigDecimal VatPercent, @NonNull BigDecimal valueOverallVAT, @NonNull BigDecimal valueOverallGross, @NonNull List<String> measurementNumbers) {
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        if (orderNumber1 == null) {
            throw new NullPointerException("orderNumber1 is marked non-null but is null");
        }
        if (orderNumber2 == null) {
            throw new NullPointerException("orderNumber2 is marked non-null but is null");
        }
        if (referenceNumber == null) {
            throw new NullPointerException("referenceNumber is marked non-null but is null");
        }
        if (voucherNumber == null) {
            throw new NullPointerException("voucherNumber is marked non-null but is null");
        }
        if (creditVoucherNumber == null) {
            throw new NullPointerException("creditVoucherNumber is marked non-null but is null");
        }
        if (orderDate == null) {
            throw new NullPointerException("orderDate is marked non-null but is null");
        }
        if (voucherDate == null) {
            throw new NullPointerException("voucherDate is marked non-null but is null");
        }
        if (costCenter == null) {
            throw new NullPointerException("costCenter is marked non-null but is null");
        }
        if (projectExecutionFrom == null) {
            throw new NullPointerException("projectExecutionFrom is marked non-null but is null");
        }
        if (projectExecutionEnd == null) {
            throw new NullPointerException("projectExecutionEnd is marked non-null but is null");
        }
        if (valueOverallNet == null) {
            throw new NullPointerException("valueOverallNet is marked non-null but is null");
        }
        if (VatPercent == null) {
            throw new NullPointerException("VatPercent is marked non-null but is null");
        }
        if (valueOverallVAT == null) {
            throw new NullPointerException("valueOverallVAT is marked non-null but is null");
        }
        if (valueOverallGross == null) {
            throw new NullPointerException("valueOverallGross is marked non-null but is null");
        }
        if (measurementNumbers == null) {
            throw new NullPointerException("measurementNumbers is marked non-null but is null");
        }
        this.importResultType = importResultType;
        this.errorMessage = errorMessage;
        this.pdfExtractType = pdfExtractType;
        this.orderNumber1 = orderNumber1;
        this.orderNumber2 = orderNumber2;
        this.referenceNumber = referenceNumber;
        this.voucherNumber = voucherNumber;
        this.creditVoucherNumber = creditVoucherNumber;
        this.orderDate = orderDate;
        this.voucherDate = voucherDate;
        this.costCenter = costCenter;
        this.projectExecutionFrom = projectExecutionFrom;
        this.projectExecutionEnd = projectExecutionEnd;
        this.valueOverallNet = valueOverallNet;
        this.VatPercent = VatPercent;
        this.valueOverallVAT = valueOverallVAT;
        this.valueOverallGross = valueOverallGross;
        this.measurementNumbers = measurementNumbers;
    }

    public EImportResultType getImportResultType() {
        return this.importResultType;
    }

    @NonNull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @NonNull
    public EPdfExtractType getPdfExtractType() {
        return this.pdfExtractType;
    }

    @NonNull
    public String getOrderNumber1() {
        return this.orderNumber1;
    }

    @NonNull
    public String getOrderNumber2() {
        return this.orderNumber2;
    }

    @NonNull
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @NonNull
    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    @NonNull
    public String getCreditVoucherNumber() {
        return this.creditVoucherNumber;
    }

    @NonNull
    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    @NonNull
    public LocalDate getVoucherDate() {
        return this.voucherDate;
    }

    @NonNull
    public String getCostCenter() {
        return this.costCenter;
    }

    @NonNull
    public LocalDate getProjectExecutionFrom() {
        return this.projectExecutionFrom;
    }

    @NonNull
    public LocalDate getProjectExecutionEnd() {
        return this.projectExecutionEnd;
    }

    @NonNull
    public BigDecimal getValueOverallNet() {
        return this.valueOverallNet;
    }

    @NonNull
    public BigDecimal getVatPercent() {
        return this.VatPercent;
    }

    @NonNull
    public BigDecimal getValueOverallVAT() {
        return this.valueOverallVAT;
    }

    @NonNull
    public BigDecimal getValueOverallGross() {
        return this.valueOverallGross;
    }

    @NonNull
    public List<String> getMeasurementNumbers() {
        return this.measurementNumbers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoicePdfExtraction)) {
            return false;
        }
        InvoicePdfExtraction other = (InvoicePdfExtraction)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EImportResultType this$importResultType = this.getImportResultType();
        EImportResultType other$importResultType = other.getImportResultType();
        if (this$importResultType == null ? other$importResultType != null : !this$importResultType.equals(other$importResultType)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        EPdfExtractType this$pdfExtractType = this.getPdfExtractType();
        EPdfExtractType other$pdfExtractType = other.getPdfExtractType();
        if (this$pdfExtractType == null ? other$pdfExtractType != null : !this$pdfExtractType.equals(other$pdfExtractType)) {
            return false;
        }
        String this$orderNumber1 = this.getOrderNumber1();
        String other$orderNumber1 = other.getOrderNumber1();
        if (this$orderNumber1 == null ? other$orderNumber1 != null : !this$orderNumber1.equals(other$orderNumber1)) {
            return false;
        }
        String this$orderNumber2 = this.getOrderNumber2();
        String other$orderNumber2 = other.getOrderNumber2();
        if (this$orderNumber2 == null ? other$orderNumber2 != null : !this$orderNumber2.equals(other$orderNumber2)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        String this$voucherNumber = this.getVoucherNumber();
        String other$voucherNumber = other.getVoucherNumber();
        if (this$voucherNumber == null ? other$voucherNumber != null : !this$voucherNumber.equals(other$voucherNumber)) {
            return false;
        }
        String this$creditVoucherNumber = this.getCreditVoucherNumber();
        String other$creditVoucherNumber = other.getCreditVoucherNumber();
        if (this$creditVoucherNumber == null ? other$creditVoucherNumber != null : !this$creditVoucherNumber.equals(other$creditVoucherNumber)) {
            return false;
        }
        LocalDate this$orderDate = this.getOrderDate();
        LocalDate other$orderDate = other.getOrderDate();
        if (this$orderDate == null ? other$orderDate != null : !((Object)this$orderDate).equals(other$orderDate)) {
            return false;
        }
        LocalDate this$voucherDate = this.getVoucherDate();
        LocalDate other$voucherDate = other.getVoucherDate();
        if (this$voucherDate == null ? other$voucherDate != null : !((Object)this$voucherDate).equals(other$voucherDate)) {
            return false;
        }
        String this$costCenter = this.getCostCenter();
        String other$costCenter = other.getCostCenter();
        if (this$costCenter == null ? other$costCenter != null : !this$costCenter.equals(other$costCenter)) {
            return false;
        }
        LocalDate this$projectExecutionFrom = this.getProjectExecutionFrom();
        LocalDate other$projectExecutionFrom = other.getProjectExecutionFrom();
        if (this$projectExecutionFrom == null ? other$projectExecutionFrom != null : !((Object)this$projectExecutionFrom).equals(other$projectExecutionFrom)) {
            return false;
        }
        LocalDate this$projectExecutionEnd = this.getProjectExecutionEnd();
        LocalDate other$projectExecutionEnd = other.getProjectExecutionEnd();
        if (this$projectExecutionEnd == null ? other$projectExecutionEnd != null : !((Object)this$projectExecutionEnd).equals(other$projectExecutionEnd)) {
            return false;
        }
        BigDecimal this$valueOverallNet = this.getValueOverallNet();
        BigDecimal other$valueOverallNet = other.getValueOverallNet();
        if (this$valueOverallNet == null ? other$valueOverallNet != null : !((Object)this$valueOverallNet).equals(other$valueOverallNet)) {
            return false;
        }
        BigDecimal this$VatPercent = this.getVatPercent();
        BigDecimal other$VatPercent = other.getVatPercent();
        if (this$VatPercent == null ? other$VatPercent != null : !((Object)this$VatPercent).equals(other$VatPercent)) {
            return false;
        }
        BigDecimal this$valueOverallVAT = this.getValueOverallVAT();
        BigDecimal other$valueOverallVAT = other.getValueOverallVAT();
        if (this$valueOverallVAT == null ? other$valueOverallVAT != null : !((Object)this$valueOverallVAT).equals(other$valueOverallVAT)) {
            return false;
        }
        BigDecimal this$valueOverallGross = this.getValueOverallGross();
        BigDecimal other$valueOverallGross = other.getValueOverallGross();
        if (this$valueOverallGross == null ? other$valueOverallGross != null : !((Object)this$valueOverallGross).equals(other$valueOverallGross)) {
            return false;
        }
        List this$measurementNumbers = this.getMeasurementNumbers();
        List other$measurementNumbers = other.getMeasurementNumbers();
        return !(this$measurementNumbers == null ? other$measurementNumbers != null : !((Object)this$measurementNumbers).equals(other$measurementNumbers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvoicePdfExtraction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EImportResultType $importResultType = this.getImportResultType();
        result = result * 59 + ($importResultType == null ? 43 : $importResultType.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        EPdfExtractType $pdfExtractType = this.getPdfExtractType();
        result = result * 59 + ($pdfExtractType == null ? 43 : $pdfExtractType.hashCode());
        String $orderNumber1 = this.getOrderNumber1();
        result = result * 59 + ($orderNumber1 == null ? 43 : $orderNumber1.hashCode());
        String $orderNumber2 = this.getOrderNumber2();
        result = result * 59 + ($orderNumber2 == null ? 43 : $orderNumber2.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        String $voucherNumber = this.getVoucherNumber();
        result = result * 59 + ($voucherNumber == null ? 43 : $voucherNumber.hashCode());
        String $creditVoucherNumber = this.getCreditVoucherNumber();
        result = result * 59 + ($creditVoucherNumber == null ? 43 : $creditVoucherNumber.hashCode());
        LocalDate $orderDate = this.getOrderDate();
        result = result * 59 + ($orderDate == null ? 43 : ((Object)$orderDate).hashCode());
        LocalDate $voucherDate = this.getVoucherDate();
        result = result * 59 + ($voucherDate == null ? 43 : ((Object)$voucherDate).hashCode());
        String $costCenter = this.getCostCenter();
        result = result * 59 + ($costCenter == null ? 43 : $costCenter.hashCode());
        LocalDate $projectExecutionFrom = this.getProjectExecutionFrom();
        result = result * 59 + ($projectExecutionFrom == null ? 43 : ((Object)$projectExecutionFrom).hashCode());
        LocalDate $projectExecutionEnd = this.getProjectExecutionEnd();
        result = result * 59 + ($projectExecutionEnd == null ? 43 : ((Object)$projectExecutionEnd).hashCode());
        BigDecimal $valueOverallNet = this.getValueOverallNet();
        result = result * 59 + ($valueOverallNet == null ? 43 : ((Object)$valueOverallNet).hashCode());
        BigDecimal $VatPercent = this.getVatPercent();
        result = result * 59 + ($VatPercent == null ? 43 : ((Object)$VatPercent).hashCode());
        BigDecimal $valueOverallVAT = this.getValueOverallVAT();
        result = result * 59 + ($valueOverallVAT == null ? 43 : ((Object)$valueOverallVAT).hashCode());
        BigDecimal $valueOverallGross = this.getValueOverallGross();
        result = result * 59 + ($valueOverallGross == null ? 43 : ((Object)$valueOverallGross).hashCode());
        List $measurementNumbers = this.getMeasurementNumbers();
        result = result * 59 + ($measurementNumbers == null ? 43 : ((Object)$measurementNumbers).hashCode());
        return result;
    }

    public String toString() {
        return "InvoicePdfExtraction(importResultType=" + String.valueOf(this.getImportResultType()) + ", errorMessage=" + this.getErrorMessage() + ", pdfExtractType=" + String.valueOf(this.getPdfExtractType()) + ", orderNumber1=" + this.getOrderNumber1() + ", orderNumber2=" + this.getOrderNumber2() + ", referenceNumber=" + this.getReferenceNumber() + ", voucherNumber=" + this.getVoucherNumber() + ", creditVoucherNumber=" + this.getCreditVoucherNumber() + ", orderDate=" + String.valueOf(this.getOrderDate()) + ", voucherDate=" + String.valueOf(this.getVoucherDate()) + ", costCenter=" + this.getCostCenter() + ", projectExecutionFrom=" + String.valueOf(this.getProjectExecutionFrom()) + ", projectExecutionEnd=" + String.valueOf(this.getProjectExecutionEnd()) + ", valueOverallNet=" + String.valueOf(this.getValueOverallNet()) + ", VatPercent=" + String.valueOf(this.getVatPercent()) + ", valueOverallVAT=" + String.valueOf(this.getValueOverallVAT()) + ", valueOverallGross=" + String.valueOf(this.getValueOverallGross()) + ", measurementNumbers=" + String.valueOf(this.getMeasurementNumbers()) + ")";
    }
}

