/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.invoice;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class InvoiceAccountValidationBucket {
    @NonNull
    private final Invoice invoice;
    @NonNull
    private final Iterable<Measurement> measurements;
    @NonNull
    private final Iterable<Invoice> finalInvoicesAccounted;

    public InvoiceAccountValidationBucket(@NonNull Invoice invoice, @NonNull Iterable<Measurement> measurements, @NonNull Iterable<Invoice> finalInvoicesAccounted) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        if (finalInvoicesAccounted == null) {
            throw new NullPointerException("finalInvoicesAccounted is marked non-null but is null");
        }
        this.invoice = invoice;
        this.measurements = measurements;
        this.finalInvoicesAccounted = finalInvoicesAccounted;
    }

    @Nonnull
    public static InvoiceAccountValidationBucket of(@NonNull Invoice invoice, @NonNull Iterable<Measurement> measurements, @NonNull Iterable<Invoice> finalInvoices) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        if (finalInvoices == null) {
            throw new NullPointerException("finalInvoices is marked non-null but is null");
        }
        return new InvoiceAccountValidationBucket(invoice, (Iterable)ImmutableList.copyOf(measurements), (Iterable)ImmutableList.copyOf(finalInvoices));
    }

    @NonNull
    public Invoice getInvoice() {
        return this.invoice;
    }

    @NonNull
    public Iterable<Measurement> getMeasurements() {
        return this.measurements;
    }

    @NonNull
    public Iterable<Invoice> getFinalInvoicesAccounted() {
        return this.finalInvoicesAccounted;
    }
}

