/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.invoice;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EInvoiceSortOption {
    ID_DESC,
    INVOICE_DATE_ASC,
    INVOICE_DATE_DESC,
    INVOICE_NUMBER_ASC;

    private static final Map<String, EInvoiceSortOption> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EInvoiceSortOption lookup(@NonNull String candidate, @NonNull EInvoiceSortOption defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EInvoiceSortOption.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EInvoiceSortOption> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EInvoiceSortOption.key((String)candidate);
        return Optional.ofNullable((EInvoiceSortOption)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EInvoiceSortOption item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EInvoiceSortOption.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EInvoiceSortOption value : EInvoiceSortOption.values()) {
            String key = EInvoiceSortOption.key((EInvoiceSortOption)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

