/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.fieldname;

import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;

public class CollectionFieldName
implements FieldName {
    private final EField field;
    private final int position;

    public String path() {
        return String.format("%s[%s]", this.field.getValue(), this.position);
    }

    private CollectionFieldName(EField field, int position) {
        this.field = field;
        this.position = position;
    }

    public static CollectionFieldName of(EField field, int position) {
        return new CollectionFieldName(field, position);
    }

    public EField getField() {
        return this.field;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionFieldName)) {
            return false;
        }
        CollectionFieldName other = (CollectionFieldName)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        EField this$field = this.getField();
        EField other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionFieldName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosition();
        EField $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public String toString() {
        return "CollectionFieldName(field=" + String.valueOf(this.getField()) + ", position=" + this.getPosition() + ")";
    }
}

