/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.businessunit;

import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.user.User;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public class BusinessUnitTree {
    private final int level;
    @NonNull
    private final BusinessUnit businessUnit;
    @NonNull
    private final List<BusinessUnitTree> children;
    @NonNull
    private final List<Pair<User, Boolean>> users;

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    private BusinessUnitTree(int level, @NonNull BusinessUnit businessUnit, @NonNull List<BusinessUnitTree> children, @NonNull List<Pair<User, Boolean>> users) {
        if (businessUnit == null) {
            throw new NullPointerException("businessUnit is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        this.level = level;
        this.businessUnit = businessUnit;
        this.children = children;
        this.users = users;
    }

    public static BusinessUnitTree of(int level, @NonNull BusinessUnit businessUnit, @NonNull List<BusinessUnitTree> children, @NonNull List<Pair<User, Boolean>> users) {
        if (businessUnit == null) {
            throw new NullPointerException("businessUnit is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        return new BusinessUnitTree(level, businessUnit, children, users);
    }

    public int getLevel() {
        return this.level;
    }

    @NonNull
    public BusinessUnit getBusinessUnit() {
        return this.businessUnit;
    }

    @NonNull
    public List<BusinessUnitTree> getChildren() {
        return this.children;
    }

    @NonNull
    public List<Pair<User, Boolean>> getUsers() {
        return this.users;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessUnitTree)) {
            return false;
        }
        BusinessUnitTree other = (BusinessUnitTree)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        BusinessUnit this$businessUnit = this.getBusinessUnit();
        BusinessUnit other$businessUnit = other.getBusinessUnit();
        if (this$businessUnit == null ? other$businessUnit != null : !this$businessUnit.equals(other$businessUnit)) {
            return false;
        }
        List this$children = this.getChildren();
        List other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List this$users = this.getUsers();
        List other$users = other.getUsers();
        return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessUnitTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        BusinessUnit $businessUnit = this.getBusinessUnit();
        result = result * 59 + ($businessUnit == null ? 43 : $businessUnit.hashCode());
        List $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessUnitTree(level=" + this.getLevel() + ", businessUnit=" + String.valueOf(this.getBusinessUnit()) + ", children=" + String.valueOf(this.getChildren()) + ", users=" + String.valueOf(this.getUsers()) + ")";
    }
}

