/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import de.qfm.erp.service.model.internal.message.Translatable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EYearMonthDateRange implements Translatable
{
    ALL("all"),
    EQ("eq"),
    LE("le");

    private final String value;
    private static final Map<String, EYearMonthDateRange> LOOKUP;
    private static final LocalDate MIN;
    private static final LocalDate MAX;

    private EYearMonthDateRange(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EYearMonthDateRange lookup(@NonNull String candidate, @NonNull EYearMonthDateRange defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EYearMonthDateRange.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EYearMonthDateRange> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EYearMonthDateRange.key((String)candidate);
        return Optional.ofNullable((EYearMonthDateRange)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EYearMonthDateRange item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EYearMonthDateRange.key((String)item.getValue());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.year_month_date_range." + this.value;
    }

    @Nonnull
    public Range<LocalDate> from(@NonNull LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("localDate is marked non-null but is null");
        }
        return this.from(YearMonth.from(localDate));
    }

    @Nonnull
    public Range<LocalDate> from(@NonNull YearMonth yearMonth) {
        LocalDate referenceDateFrom;
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return Range.closed((Comparable)referenceDateFrom, (Comparable)(switch (this.ordinal()) {
            case 1 -> {
                referenceDateFrom = yearMonth.atDay(1);
                yield yearMonth.atEndOfMonth();
            }
            case 2 -> {
                referenceDateFrom = MIN;
                yield yearMonth.atEndOfMonth();
            }
            default -> {
                referenceDateFrom = MIN;
                yield MAX;
            }
        }));
    }

    public String getValue() {
        return this.value;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EYearMonthDateRange value : EYearMonthDateRange.values()) {
            String key = EYearMonthDateRange.key((EYearMonthDateRange)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        MIN = LocalDate.of(1900, 1, 1);
        MAX = LocalDate.of(2100, 1, 1);
    }
}

