/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.exception.request;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.exception.request.NoDataException;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.user.User;
import java.time.YearMonth;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class NoContractForUserException
extends NoDataException {
    NoContractForUserException(@NonNull String messageText, @NonNull Message detail) {
        super(messageText, detail);
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        if (detail == null) {
            throw new NullPointerException("detail is marked non-null but is null");
        }
    }

    @Nonnull
    public static NoContractForUserException of(@NonNull String messageText, @NonNull Message detail) {
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        if (detail == null) {
            throw new NullPointerException("detail is marked non-null but is null");
        }
        return new NoContractForUserException(messageText, detail);
    }

    @Nonnull
    public static Message message(@NonNull User user, @NonNull YearMonth month) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (month == null) {
            throw new NullPointerException("month is marked non-null but is null");
        }
        String yearMonthString = month.toString();
        return Message.of((EMessageKey)EMessageKey.MISSING_LABOR_UNION_CONTRACT_FOR_USER_AND_MONTH, (List)ImmutableList.of((Object)user.getFullName(), (Object)yearMonthString));
    }
}

