/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.xstream;

import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import de.qfm.erp.service.model.external.gaeb.generic.Text;
import de.qfm.erp.service.model.external.gaeb.generic.TextComplement;
import de.qfm.erp.service.model.external.gaeb.x83.DetailTxt;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GaebDetailTextConverter
implements Converter {
    private static final Logger log = LogManager.getLogger(GaebDetailTextConverter.class);

    public boolean canConvert(Class clazz) {
        return clazz.equals(DetailTxt.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        DetailTxt detailTxt = (DetailTxt)value;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DetailTxt detailTxt = new DetailTxt();
        detailTxt.setObjects((List)Lists.newArrayList());
        try {
            while (reader.hasMoreChildren()) {
                LinkedHashMap attributes = Maps.newLinkedHashMap();
                int attributeCount = reader.getAttributeCount();
                if (attributeCount > 0) {
                    for (int i = 0; i < attributeCount; ++i) {
                        String attributeName = reader.getAttributeName(i);
                        String attributeValue = reader.getAttribute(i);
                        attributes.put(attributeName, attributeValue);
                    }
                }
                reader.moveDown();
                String nodeName = reader.getNodeName();
                String value = reader.getValue();
                if (StringUtils.length((CharSequence)value) > 0) {
                    Text text = null;
                    boolean moreChildren = reader.hasMoreChildren();
                    if ("Text".equals(nodeName) && moreChildren) {
                        text = (Text)context.convertAnother((Object)detailTxt, Text.class);
                        detailTxt.getObjects().add(text);
                    } else if ("TextComplement".equals(nodeName) && moreChildren) {
                        TextComplement textComplement = (TextComplement)context.convertAnother((Object)detailTxt, TextComplement.class);
                        textComplement.setKind(attributes.getOrDefault("Kind", ""));
                        textComplement.setMarkLabel(attributes.getOrDefault("MarkLbl", ""));
                        detailTxt.getObjects().add(textComplement);
                    } else {
                        log.warn("Illegal Node Name: {}", (Object)nodeName);
                    }
                }
                reader.moveUp();
            }
        }
        catch (Exception e) {
            log.error("Error unserializing DetailTxt: {}", (Object)e.getMessage(), (Object)e);
        }
        return detailTxt;
    }
}

