/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.search;

import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.search.IndexField;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.LongRange;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

/*
 * Exception performing whole class analysis ignored.
 */
public class LuceneHelper {
    public static final String DEFAULT_EMPTY_FACET_STRING = "<empty>";
    private static final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("MM.yyyy");
    private static final FieldType NOT_TOKENIZED_FIELD_STORED_OFFSET_TYPE;
    private static final FieldType TOKENIZED_FIELD_STORED_OFFSET_TYPE;

    @Nonnull
    public static Optional<Field> numeric(@NonNull IndexField field, @Nullable Long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            String fieldName = field.fieldName();
            return Optional.of(new LongPoint(fieldName, new long[]{value}));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Field range(@NonNull IndexField field, long lowerBound, long upperBound) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        String fieldName = field.fieldName();
        long[] d1 = new long[]{lowerBound};
        long[] d2 = new long[]{upperBound};
        return new LongRange(fieldName, d1, d2);
    }

    @Nonnull
    public static Optional<Field> numeric(@NonNull IndexField field, @Nullable BigDecimal value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return Optional.of(LuceneHelper.numeric((IndexField)field, (Double)value.doubleValue()));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> dateIdx(@NonNull IndexField field, @Nullable LocalDate value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.numeric((IndexField)field, (Long)value.toEpochDay());
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> dateTimeIdx(@NonNull IndexField field, @Nullable LocalDateTime value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.numeric((IndexField)field, (Long)value.toEpochSecond(ZoneOffset.UTC));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> dateStr(@NonNull IndexField field, @Nullable LocalDate value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.notTokenized((IndexField)field, (String)DateTimeHelper.toIsoDate((LocalDate)value));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> monthStr(@NonNull IndexField field, @Nullable LocalDate value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.notTokenized((IndexField)field, (String)MONTH_FORMATTER.format(value));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> dateTimeStr(@NonNull IndexField field, @Nullable LocalDateTime value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.notTokenized((IndexField)field, (String)DateTimeHelper.toIsoDateTime((LocalDateTime)value));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> sort(@NonNull IndexField field, @Nullable LocalDateTime value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            NumericDocValuesField dateField = new NumericDocValuesField(field.fieldName(), value.toEpochSecond(ZoneOffset.UTC));
            return Optional.of(dateField);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> sort(@NonNull IndexField field, @NonNull Long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        NumericDocValuesField dateField = new NumericDocValuesField(field.fieldName(), value);
        return Optional.of(dateField);
    }

    @Nonnull
    public static Optional<Field> longStr(@NonNull IndexField field, @Nullable Long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.notTokenized((IndexField)field, (String)Long.toString(value));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Field numeric(@NonNull IndexField field, Double value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        String fieldName = field.fieldName();
        return new DoublePoint(fieldName, new double[]{value});
    }

    @Nonnull
    public static Field numeric(@NonNull IndexField field, long from, long to) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        String fieldName = field.fieldName();
        return new LongRange(fieldName, new long[]{from}, new long[]{to});
    }

    @Nonnull
    public static Optional<Field> tokenized(@NonNull IndexField field, @Nullable String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String fieldName = field.fieldName();
            return Optional.of(new Field(fieldName, (CharSequence)StringUtils.trimToEmpty((String)value), (IndexableFieldType)TOKENIZED_FIELD_STORED_OFFSET_TYPE));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Field> notTokenized(@NonNull IndexField field, @Nullable String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String fieldName = field.fieldName();
            return Optional.of(new Field(fieldName, (CharSequence)StringUtils.trimToEmpty((String)value), (IndexableFieldType)NOT_TOKENIZED_FIELD_STORED_OFFSET_TYPE));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Field store(@NonNull IndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String fieldName = field.fieldName();
        return new StoredField(fieldName, value);
    }

    @Nonnull
    public static Optional<FacetField> facet(@NonNull IndexField field, @Nullable LocalDate value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.facet((IndexField)field, (String)DateTimeHelper.toIsoDate((LocalDate)value));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<FacetField> facet(@NonNull IndexField field, @Nullable LocalDateTime value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.facet((IndexField)field, (String)DateTimeHelper.toIsoDateTime((LocalDateTime)value));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<FacetField> facet(@NonNull IndexField field, @Nullable Long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            return LuceneHelper.facet((IndexField)field, (String)Long.toString(value));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<FacetField> facet(@NonNull IndexField field, @Nullable String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (null != value) {
            String fieldName = field.fieldName();
            return Optional.of(LuceneHelper.facet((String)fieldName, (String)StringUtils.trimToEmpty((String)value)));
        }
        return Optional.empty();
    }

    @Nonnull
    public static FacetField facet(@NonNull String fieldName, @NonNull String value) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String safeValue = (String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)"<empty>");
        return new FacetField(fieldName, new String[]{safeValue});
    }

    @Nonnull
    public static Field sorted(@NonNull IndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String fieldName = field.fieldName();
        return new SortedDocValuesField(fieldName, new BytesRef((CharSequence)value));
    }

    @Nonnull
    public static Field sorted(@NonNull IndexField field, long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        String fieldName = field.fieldName();
        return new NumericDocValuesField(fieldName, value);
    }

    @Nonnull
    public static String normalize(@NonNull Analyzer analyzer, @NonNull IndexField field, @NonNull String candidate) {
        if (analyzer == null) {
            throw new NullPointerException("analyzer is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return analyzer.normalize(field.fieldName(), candidate).utf8ToString();
    }

    static {
        TOKENIZED_FIELD_STORED_OFFSET_TYPE = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        TOKENIZED_FIELD_STORED_OFFSET_TYPE.setStoreTermVectors(true);
        TOKENIZED_FIELD_STORED_OFFSET_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        NOT_TOKENIZED_FIELD_STORED_OFFSET_TYPE = new FieldType((IndexableFieldType)StringField.TYPE_STORED);
        NOT_TOKENIZED_FIELD_STORED_OFFSET_TYPE.setStoreTermVectors(true);
        NOT_TOKENIZED_FIELD_STORED_OFFSET_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
    }
}

