/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.MeasurementSearchResultItem;
import de.qfm.erp.service.model.search.SearchResultItem;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

/*
 * Exception performing whole class analysis ignored.
 */
public final class IndexAccessHelper {
    public static int totalPages(int pageSize, long totalElements) {
        return (int)((totalElements + (long)pageSize - 1L) / (long)pageSize);
    }

    @Nonnull
    public static List<Pair<Document, Float>> documents(@NonNull IndexReader indexReader, @NonNull TopDocs topDocs) throws IOException {
        if (indexReader == null) {
            throw new NullPointerException("indexReader is marked non-null but is null");
        }
        if (topDocs == null) {
            throw new NullPointerException("topDocs is marked non-null but is null");
        }
        return IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)0);
    }

    @Nonnull
    public static List<Pair<Document, Float>> documents(@NonNull IndexReader indexReader, @NonNull TopDocs topDocs, int skip) throws IOException {
        if (indexReader == null) {
            throw new NullPointerException("indexReader is marked non-null but is null");
        }
        if (topDocs == null) {
            throw new NullPointerException("topDocs is marked non-null but is null");
        }
        ImmutableList.Builder documentBuilder = ImmutableList.builder();
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        for (int index = skip; index < scoreDocs.length; ++index) {
            ScoreDoc scoreDoc = scoreDocs[index];
            int docId = scoreDoc.doc;
            float score = scoreDoc.score;
            Document document = indexReader.storedFields().document(docId);
            documentBuilder.add((Object)Pair.of((Object)document, (Object)Float.valueOf(score)));
        }
        return documentBuilder.build();
    }

    @Nonnull
    public static List<Document> documents(@NonNull List<MeasurementSearchResultItem> scoreDocuments) {
        if (scoreDocuments == null) {
            throw new NullPointerException("scoreDocuments is marked non-null but is null");
        }
        return (List)scoreDocuments.stream().map(SearchResultItem::getDocument).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static Iterable<String> documentIds(@NonNull Iterable<Document> scoreDocuments) {
        if (scoreDocuments == null) {
            throw new NullPointerException("scoreDocuments is marked non-null but is null");
        }
        return (Iterable)Streams.stream(scoreDocuments).map(item -> {
            String id = item.get(EMeasurementIndexField._ID.fieldName());
            String type = item.get(EMeasurementIndexField._TYPE.fieldName());
            return String.format("Type: %s, Id: %s", type, id);
        }).collect(ImmutableList.toImmutableList());
    }
}

