/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.RolePrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.jpa.user.UserPrivilege;
import de.qfm.erp.service.model.jpa.user.UserRole;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

/*
 * Exception performing whole class analysis ignored.
 */
public final class UserHelper {
    public static final Joiner AUTH_JOINER = Joiner.on((String)"|");
    private static final CharMatcher GRANTED_AUTHORITY_MATCHER = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)"_")).negate();

    @Nonnull
    public static String asString(@NonNull User user) {
        String personalNumberString;
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        String firstName = StringUtils.trimToEmpty((String)user.getFirstName());
        String lastName = StringUtils.trimToEmpty((String)user.getLastName());
        String fullName = StringUtils.trimToEmpty((String)user.getFullName());
        Integer personalNumber = user.getPersonalNumber();
        String string = personalNumberString = null != personalNumber ? String.format("[%s]", personalNumber) : "";
        if (StringUtils.isNotBlank((CharSequence)fullName)) {
            return String.format("%s %s", fullName, personalNumberString);
        }
        return String.format("%s %s %s", firstName, lastName, personalNumberString);
    }

    @Deprecated
    @Nonnull
    public static Iterable<EPrivilege> customPrivileges(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Iterable userPrivilege = (Iterable)MoreObjects.firstNonNull((Object)user.getUserPrivileges(), (Object)ImmutableSet.of());
        return (Iterable)Streams.stream((Iterable)userPrivilege).map(UserPrivilege::getPrivilege).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static Iterable<Role> allRoles(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Iterable userRoles = (Iterable)MoreObjects.firstNonNull((Object)user.getUserRoles(), (Object)ImmutableSet.of());
        ImmutableList.Builder allRolesBuilder = ImmutableList.builder();
        Streams.stream((Iterable)userRoles).map(UserRole::getRole).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)allRolesBuilder).add(arg_0));
        return allRolesBuilder.build();
    }

    @Nonnull
    public static String grantedAuthorityName(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        String name = StringUtils.trimToEmpty((String)role.getDescription());
        return String.format("R_%s", GRANTED_AUTHORITY_MATCHER.replaceFrom((CharSequence)name, (CharSequence)"_"));
    }

    @Nonnull
    public static String grantedAuthorityName(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        String name = StringUtils.trimToEmpty((String)privilege.name());
        return String.format("P_%s", GRANTED_AUTHORITY_MATCHER.replaceFrom((CharSequence)name, (CharSequence)"_"));
    }

    @Nonnull
    public static Iterable<GrantedAuthority> grantedAuthorities(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        ImmutableSet.Builder rolesAndPrivilegeNamesBuilder = ImmutableSet.builder();
        String name = UserHelper.grantedAuthorityName((Role)role);
        rolesAndPrivilegeNamesBuilder.add((Object)name);
        List rolePrivileges = (List)MoreObjects.firstNonNull((Object)role.getRolePrivileges(), (Object)ImmutableList.of());
        rolePrivileges.stream().map(RolePrivilege::getPrivilege).filter(Objects::nonNull).map(UserHelper::grantedAuthorityName).forEach(arg_0 -> ((ImmutableSet.Builder)rolesAndPrivilegeNamesBuilder).add(arg_0));
        ImmutableSet rolesAndPrivilegeNames = rolesAndPrivilegeNamesBuilder.build();
        return (Iterable)rolesAndPrivilegeNames.stream().map(SimpleGrantedAuthority::new).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static Iterable<GrantedAuthority> grantedAuthoritiesAlternative(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        ImmutableSet.Builder rolesAndPrivilegeNamesBuilder = ImmutableSet.builder();
        String name = UserHelper.grantedAuthorityName((Role)role);
        rolesAndPrivilegeNamesBuilder.add((Object)name);
        List rolePrivileges = (List)MoreObjects.firstNonNull((Object)role.getRolePrivileges(), (Object)ImmutableList.of());
        ImmutableSet allPrivileges = (ImmutableSet)rolePrivileges.stream().map(RolePrivilege::getPrivilege).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        allPrivileges.stream().map(UserHelper::grantedAuthorityName).filter(StringUtils::isNotBlank).forEach(arg_0 -> ((ImmutableSet.Builder)rolesAndPrivilegeNamesBuilder).add(arg_0));
        ImmutableSet rolesAndPrivilegeNames = rolesAndPrivilegeNamesBuilder.build();
        ImmutableList strings = ImmutableList.sortedCopyOf((Iterable)rolesAndPrivilegeNames);
        String allPrivilegesString = AUTH_JOINER.join((Iterable)strings);
        HashCode hashCode = Hashing.sha256().hashString((CharSequence)allPrivilegesString, StandardCharsets.UTF_8);
        String hashCodeAsString = hashCode.toString();
        ImmutableList.Builder allGrantedAuthorities = ImmutableList.builder();
        allGrantedAuthorities.add((Object)new SimpleGrantedAuthority(hashCodeAsString));
        ImmutableSet specialPrivileges = ImmutableSet.of((Object)EPrivilege.ACCESS_MEASUREMENT_ALL, (Object)EPrivilege.UNRESTRICTED);
        for (EPrivilege specialPrivilege : specialPrivileges) {
            if (!allPrivileges.contains((Object)specialPrivilege)) continue;
            allGrantedAuthorities.add((Object)new SimpleGrantedAuthority(UserHelper.grantedAuthorityName((EPrivilege)specialPrivilege)));
        }
        return allGrantedAuthorities.build();
    }

    @Nonnull
    public static Iterable<GrantedAuthority> grantedAuthorities(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return UserHelper.grantedAuthorities((Iterable)UserHelper.allRoles((User)user));
    }

    @Nonnull
    public static Iterable<GrantedAuthority> grantedAuthorities(@NonNull Iterable<Role> grantedAuthorities) {
        if (grantedAuthorities == null) {
            throw new NullPointerException("grantedAuthorities is marked non-null but is null");
        }
        return (Iterable)Streams.stream(grantedAuthorities).flatMap(item -> Streams.stream((Iterable)UserHelper.grantedAuthorities((Role)item))).filter(item -> StringUtils.isNotBlank((CharSequence)item.getAuthority())).collect(ImmutableSet.toImmutableSet());
    }
}

