/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.ProductCalculatorHelper;
import de.qfm.erp.service.model.internal.transposition.Cell;
import de.qfm.erp.service.model.internal.transposition.Column;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionStandardToTranspose;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionTransposedToStandard;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionsTransposed;
import de.qfm.erp.service.model.internal.transposition.MeasurementTransposedRemark;
import de.qfm.erp.service.model.internal.transposition.Row;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class TranspositionHelper {
    private static final Logger log = LogManager.getLogger(TranspositionHelper.class);
    private static final Boolean TRANSPOSE_BACK__KEEP_NULL_AMOUNTS = Boolean.FALSE;
    private static final BigDecimal DEFAULT_TRANSPOSE_BACK_FACTOR = null;
    private static final Ordering<Comparable<Integer>> COMPARE_NULLS_LAST = Ordering.natural().nullsLast();
    public static final Comparator<MeasurementPositionStandardToTranspose> MEASUREMENT_POSITION_STANDARD_TO_TRANSPOSE_COMPARATOR = (left, right) -> {
        int first = COMPARE_NULLS_LAST.compare((Object)left.getTransposedSortIndex(), (Object)right.getTransposedSortIndex());
        if (first != 0) {
            return first;
        }
        return COMPARE_NULLS_LAST.compare((Object)left.getSequenceNumberMeasurementStandard(), (Object)right.getSequenceNumberMeasurementStandard());
    };
    public static final String DEFAULT_ROW_KEY = "";

    @Nonnull
    public static MeasurementPositionsTransposed transpose(@NonNull Pair<Iterable<MeasurementTransposedRemark>, Iterable<MeasurementPositionStandardToTranspose>> pair) {
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        Iterable measurementTransposedRemarks = (Iterable)pair.getLeft();
        Iterable measurementPositionsToTranspose = (Iterable)pair.getRight();
        List remarksSortingKept = TranspositionHelper.remarksSortingKept((Iterable)measurementPositionsToTranspose, MeasurementPositionStandardToTranspose::getRemarks, (Iterable)measurementTransposedRemarks);
        ImmutableList measurementPositionsToTransposeSorted = ImmutableList.copyOf(IterableHelper.stream((Iterable)measurementPositionsToTranspose).sorted(MEASUREMENT_POSITION_STANDARD_TO_TRANSPOSE_COMPARATOR).iterator());
        LinkedHashMap measurementPositionsPerRow = Maps.newLinkedHashMap();
        LinkedHashMap measurementPositionsPerColumn = Maps.newLinkedHashMap();
        LinkedHashSet columnKeysSorted = Sets.newLinkedHashSet();
        for (MeasurementPositionStandardToTranspose measurementPositionStandardToTranspose : measurementPositionsToTransposeSorted) {
            Integer sequenceNumberStandard = measurementPositionStandardToTranspose.getSequenceNumberMeasurementStandard();
            String rowKey = TranspositionHelper.rowKey((MeasurementPositionStandardToTranspose)measurementPositionStandardToTranspose);
            List measurementPositionPerRow = measurementPositionsPerRow.getOrDefault(rowKey, Lists.newArrayList());
            measurementPositionPerRow.add(Pair.of((Object)measurementPositionStandardToTranspose, (Object)sequenceNumberStandard));
            measurementPositionsPerRow.put(rowKey, measurementPositionPerRow);
            String columnKey = TranspositionHelper.columnKey((MeasurementPositionStandardToTranspose)measurementPositionStandardToTranspose);
            List measurementPositionPerColumn = measurementPositionsPerColumn.getOrDefault(columnKey, Lists.newArrayList());
            measurementPositionPerColumn.add(measurementPositionStandardToTranspose);
            measurementPositionsPerColumn.put(columnKey, measurementPositionPerColumn);
            columnKeysSorted.add(columnKey);
        }
        ImmutableList.Builder columnBuilder = ImmutableList.builder();
        int transposedSortIndex = 0;
        for (String columnKey : columnKeysSorted) {
            List columnValues = (List)measurementPositionsPerColumn.get(columnKey);
            Optional<BigDecimal> amountAggregatedCandidate = columnValues.stream().map(TranspositionHelper::product).filter(Optional::isPresent).map(Optional::get).reduce(BigDecimal::add);
            MeasurementPositionStandardToTranspose firstMeasurementPosition = (MeasurementPositionStandardToTranspose)columnValues.iterator().next();
            Long quotationPositionId = firstMeasurementPosition.getQuotationPositionId();
            String surrogatePositionNumber = firstMeasurementPosition.getSurrogatePositionNumber();
            BigDecimal squadWagePerUnit = firstMeasurementPosition.getSquadWagePerUnit();
            String shortText = firstMeasurementPosition.getShortText();
            String unit = firstMeasurementPosition.getUnit();
            BigDecimal pricePerUnit = firstMeasurementPosition.getPricePerUnit();
            BigDecimal amountAggregated = amountAggregatedCandidate.orElse(BigDecimal.ZERO);
            BigDecimal squadWageAggregated = ((BigDecimal)MoreObjects.firstNonNull((Object)amountAggregated, (Object)BigDecimal.ZERO)).multiply(squadWagePerUnit);
            columnBuilder.add((Object)Column.of((String)columnKey, (String)surrogatePositionNumber, (String)shortText, (String)unit, (BigDecimal)squadWagePerUnit, (BigDecimal)squadWageAggregated, (BigDecimal)amountAggregated, (BigDecimal)pricePerUnit, (Integer)transposedSortIndex++, (Long)quotationPositionId));
        }
        ImmutableList columns = columnBuilder.build();
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        AtomicInteger sequenceNumberTransposedTLRB = new AtomicInteger(0);
        remarksSortingKept.forEach(arg_0 -> TranspositionHelper.lambda$transpose$1(measurementPositionsPerRow, (List)columns, sequenceNumberTransposedTLRB, rowsBuilder, arg_0));
        ImmutableList rows = rowsBuilder.build();
        return MeasurementPositionsTransposed.of((Iterable)columns, (Iterable)rows, (Iterable)ImmutableList.of());
    }

    @Nonnull
    public static <T> List<String> remarksSortingKept(@NonNull Iterable<T> input, @NonNull Function<T, String> remarkFunction, @NonNull Iterable<MeasurementTransposedRemark> measurementTransposedRemarks) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (remarkFunction == null) {
            throw new NullPointerException("remarkFunction is marked non-null but is null");
        }
        if (measurementTransposedRemarks == null) {
            throw new NullPointerException("measurementTransposedRemarks is marked non-null but is null");
        }
        List<String> remarksSortingKept = IterableHelper.stream(input).map(remarkFunction).map(StringUtils::trimToEmpty).distinct().collect(Collectors.toList());
        for (MeasurementTransposedRemark measurementTransposedRemark : measurementTransposedRemarks) {
            String remark = measurementTransposedRemark.getRemark();
            int rowIndex = measurementTransposedRemark.getRowIndex() - 1;
            boolean fits = remarksSortingKept.size() >= rowIndex;
            boolean exists = remarksSortingKept.contains(remark);
            if (!fits || exists) continue;
            remarksSortingKept.add(rowIndex, remark);
        }
        return remarksSortingKept;
    }

    @Nonnull
    @VisibleForTesting
    static Map<String, Cell> valuesForRow(@NonNull List<Column> columns, @NonNull List<Pair<MeasurementPositionStandardToTranspose, Integer>> measurementPositionsToTransposesPair, int sequenceNumberTransposedIndex) {
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        if (measurementPositionsToTransposesPair == null) {
            throw new NullPointerException("measurementPositionsToTransposesPair is marked non-null but is null");
        }
        LinkedHashMap cells = Maps.newLinkedHashMap();
        HashSet columnsNotEmpty = Sets.newHashSet();
        int index = 0;
        for (Pair<MeasurementPositionStandardToTranspose, Integer> measurementPositionToTransposesPair : measurementPositionsToTransposesPair) {
            MeasurementPositionStandardToTranspose measurementPositionStandardToTranspose = (MeasurementPositionStandardToTranspose)measurementPositionToTransposesPair.getLeft();
            String columnKey = TranspositionHelper.columnKey((MeasurementPositionStandardToTranspose)measurementPositionStandardToTranspose);
            BigDecimal amount = TranspositionHelper.product((MeasurementPositionStandardToTranspose)measurementPositionStandardToTranspose).orElse(null);
            LocalDate accountingMonth = measurementPositionStandardToTranspose.getAccountingMonth();
            Integer sequenceNumberStandard = cells.containsKey(columnKey) ? ((Cell)cells.get(columnKey)).getSequenceNumberMeasurementStandard() : (Integer)measurementPositionToTransposesPair.getRight();
            Integer sequenceNumberTransposed = cells.containsKey(columnKey) ? ((Cell)cells.get(columnKey)).getSequenceNumberMeasurementTransposed() : sequenceNumberTransposedIndex + index++;
            BigDecimal valuePresent = cells.containsKey(columnKey) ? ((Cell)cells.get(columnKey)).getAmount() : null;
            ImmutableSet measurementPositionIdsPresent = cells.containsKey(columnKey) ? ((Cell)cells.get(columnKey)).getMeasurementPositionIds() : ImmutableSet.of();
            BigDecimal amountNew = TranspositionHelper.addToNull((BigDecimal)amount, (BigDecimal)valuePresent);
            Long measurementPositionId = measurementPositionStandardToTranspose.getId();
            ImmutableSet measurementPositionIds = null != measurementPositionId ? ImmutableSet.builder().addAll((Iterable)measurementPositionIdsPresent).add((Object)measurementPositionId).build() : measurementPositionIdsPresent;
            Cell cell = Cell.of((String)columnKey, (BigDecimal)amountNew, (Integer)sequenceNumberStandard, (Integer)sequenceNumberTransposed, (LocalDate)accountingMonth, (Iterable)measurementPositionIds);
            cells.put(columnKey, cell);
            columnsNotEmpty.add(columnKey);
        }
        Set allColumnIds = columns.stream().map(Column::getId).collect(Collectors.toSet());
        Sets.SetView difference = Sets.difference(allColumnIds, (Set)columnsNotEmpty);
        ImmutableSet columnIdsToBePopulatedWithZero = difference.immutableCopy();
        for (String columnIdToBeZero : columnIdsToBePopulatedWithZero) {
            cells.put(columnIdToBeZero, Cell.of((String)columnIdToBeZero, null, (Integer)0, (Integer)(sequenceNumberTransposedIndex + index++), (LocalDate)DateTimeHelper.thisMonth(), (Iterable)ImmutableSet.of()));
        }
        return ImmutableMap.copyOf((Map)cells);
    }

    @Nullable
    @VisibleForTesting
    static BigDecimal addToNull(@Nullable BigDecimal left, @Nullable BigDecimal right) {
        if (null == left && null == right) {
            return null;
        }
        if (null == left) {
            return right;
        }
        if (null == right) {
            return left;
        }
        return left.add(right);
    }

    @Nonnull
    @VisibleForTesting
    static String columnKey(@NonNull MeasurementPositionStandardToTranspose measurementPositionStandardToTranspose) {
        if (measurementPositionStandardToTranspose == null) {
            throw new NullPointerException("measurementPositionStandardToTranspose is marked non-null but is null");
        }
        return measurementPositionStandardToTranspose.surrogatePositionNumber();
    }

    @Nonnull
    @VisibleForTesting
    static String rowKey(@NonNull MeasurementPositionStandardToTranspose measurementPositionCommon) {
        if (measurementPositionCommon == null) {
            throw new NullPointerException("measurementPositionCommon is marked non-null but is null");
        }
        String remarks = measurementPositionCommon.getRemarks();
        return StringUtils.trimToEmpty((String)remarks);
    }

    @Nonnull
    public static Pair<Iterable<String>, Iterable<MeasurementPositionTransposedToStandard>> unTranspose(@NonNull MeasurementPositionsTransposed measurementPositionsTransposed) {
        if (measurementPositionsTransposed == null) {
            throw new NullPointerException("measurementPositionsTransposed is marked non-null but is null");
        }
        ImmutableList.Builder measurementPositionTransposedToStandardBuilder = ImmutableList.builder();
        Iterable unsortedColumns = measurementPositionsTransposed.getColumns();
        Iterable sortedColumns = IterableHelper.stream((Iterable)unsortedColumns).sorted(Comparator.comparingInt(Column::getTransposedSortIndex)).collect(Collectors.toList());
        Iterable unsortedRows = measurementPositionsTransposed.getRows();
        Iterable sortedRows = IterableHelper.stream((Iterable)unsortedRows).sorted(Comparator.comparingInt(Row::getSequentialNumber)).collect(Collectors.toList());
        LinkedHashSet nonUsedRemarks = Sets.newLinkedHashSet();
        if (!Iterables.isEmpty((Iterable)sortedRows) && !Iterables.isEmpty((Iterable)sortedColumns)) {
            int sequenceNumberStandard = 0;
            int sequenceNumberTransposed = 0;
            ImmutableList rowKeys = ImmutableList.copyOf(IterableHelper.stream((Iterable)sortedRows).map(Row::getRemarks).map(StringUtils::trimToEmpty).map(item -> (String)StringUtils.defaultIfEmpty((CharSequence)item, (CharSequence)"")).iterator());
            ImmutableList columnKeys = ImmutableList.copyOf(IterableHelper.stream((Iterable)sortedColumns).map(Column::getId).map(StringUtils::trimToEmpty).iterator());
            ArrayTable table = ArrayTable.create((Iterable)rowKeys, (Iterable)columnKeys);
            for (Column column : sortedColumns) {
                String columnKey = column.getId();
                for (Row row : sortedRows) {
                    Map cells = row.getCells();
                    if (!cells.containsKey(columnKey)) continue;
                    String remarks = StringUtils.trimToEmpty((String)row.getRemarks());
                    String rowKey = (String)StringUtils.defaultIfEmpty((CharSequence)remarks, (CharSequence)"");
                    Cell cell = (Cell)cells.get(columnKey);
                    table.put((Object)rowKey, (Object)columnKey, (Object)cell);
                }
            }
            boolean firstRow = true;
            for (String remarks : table.rowKeySet()) {
                boolean found = false;
                for (Column column : sortedColumns) {
                    String columnKey = column.getId();
                    String positionNumber = column.getSurrogatePositionNumber();
                    Integer transposedSortIndex = column.getTransposedSortIndex();
                    Long quotationPositionId = column.getPositionId();
                    Cell cell = (Cell)table.get((Object)remarks, (Object)columnKey);
                    BigDecimal amount = cell.getAmount();
                    if (null == amount && !TRANSPOSE_BACK__KEEP_NULL_AMOUNTS.booleanValue()) continue;
                    BigDecimal product = (BigDecimal)MoreObjects.firstNonNull((Object)cell.getAmount(), (Object)BigDecimal.ZERO);
                    LocalDate accountingMonth = cell.getAccountingMonth();
                    Long measurementPositionId = (Long)Iterables.get((Iterable)((Iterable)MoreObjects.firstNonNull((Object)cell.getMeasurementPositionIds(), (Object)ImmutableSet.of())), (int)0, null);
                    MeasurementPositionTransposedToStandard measurementPositionTransposedToStandard = MeasurementPositionTransposedToStandard.of((String)positionNumber, (BigDecimal)amount, (String)remarks, (LocalDate)accountingMonth, (BigDecimal)DEFAULT_TRANSPOSE_BACK_FACTOR, (BigDecimal)DEFAULT_TRANSPOSE_BACK_FACTOR, (BigDecimal)DEFAULT_TRANSPOSE_BACK_FACTOR, (BigDecimal)product, (Integer)sequenceNumberStandard++, (Integer)sequenceNumberTransposed++, (Integer)transposedSortIndex, (Long)measurementPositionId, (Long)quotationPositionId);
                    measurementPositionTransposedToStandardBuilder.add((Object)measurementPositionTransposedToStandard);
                    found = true;
                }
                if (!found) {
                    nonUsedRemarks.add(remarks);
                }
                if (firstRow) {
                    for (Column column : sortedColumns) {
                        String positionNumber = column.getSurrogatePositionNumber();
                        Integer transposedSortIndex = column.getTransposedSortIndex();
                        Long quotationPositionId = column.getPositionId();
                        String columnKey = column.getId();
                        Map cellsInColumn = table.column((Object)columnKey);
                        Optional<BigDecimal> first = cellsInColumn.values().stream().map(Cell::getAmount).filter(item -> null != item || TRANSPOSE_BACK__KEEP_NULL_AMOUNTS != false).findFirst();
                        if (!first.isEmpty()) continue;
                        MeasurementPositionTransposedToStandard measurementPositionTransposedToStandard = MeasurementPositionTransposedToStandard.of((String)positionNumber, null, (String)remarks, (LocalDate)DateTimeHelper.thisMonth(), (BigDecimal)DEFAULT_TRANSPOSE_BACK_FACTOR, (BigDecimal)DEFAULT_TRANSPOSE_BACK_FACTOR, (BigDecimal)DEFAULT_TRANSPOSE_BACK_FACTOR, (BigDecimal)BigDecimal.ZERO, (Integer)sequenceNumberStandard++, (Integer)sequenceNumberTransposed++, (Integer)transposedSortIndex, null, (Long)quotationPositionId);
                        measurementPositionTransposedToStandardBuilder.add((Object)measurementPositionTransposedToStandard);
                    }
                }
                firstRow = false;
            }
        } else {
            for (Row row : sortedRows) {
                String remarks = row.getRemarks();
                if (!StringUtils.isNotBlank((CharSequence)remarks)) continue;
                nonUsedRemarks.add(row.getRemarks());
            }
        }
        ImmutableList transposedToStandardRows = measurementPositionTransposedToStandardBuilder.build();
        ImmutableSet allRemarks = (ImmutableSet)IterableHelper.stream((Iterable)sortedRows).map(Row::getRemarks).collect(ImmutableSet.toImmutableSet());
        return Pair.of((Object)allRemarks, (Object)transposedToStandardRows);
    }

    @Nonnull
    @VisibleForTesting
    static Optional<BigDecimal> product(@NonNull MeasurementPositionStandardToTranspose item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        BigDecimal amount = item.getAmount();
        BigDecimal factor1 = item.getFactor1();
        BigDecimal factor2 = item.getFactor2();
        BigDecimal factor3 = item.getFactor3();
        if (null != amount || null != factor1 || null != factor2 || null != factor3) {
            return Optional.of(ProductCalculatorHelper.product((BigDecimal)amount, (BigDecimal)factor1, (BigDecimal)factor2, (BigDecimal)factor3));
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$transpose$1(LinkedHashMap measurementPositionsPerRow, List columns, AtomicInteger sequenceNumberTransposedTLRB, ImmutableList.Builder rowsBuilder, String remark) {
        List value = (List)MoreObjects.firstNonNull((Object)((List)measurementPositionsPerRow.get(remark)), (Object)ImmutableList.of());
        Map valuesForRow = TranspositionHelper.valuesForRow((List)columns, (List)value, (int)sequenceNumberTransposedTLRB.get());
        sequenceNumberTransposedTLRB.addAndGet(valuesForRow.size());
        rowsBuilder.add((Object)Row.of((String)remark, (Integer)sequenceNumberTransposedTLRB.get(), (Map)valuesForRow));
    }
}

