/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.quotation.StagePositionUpdateItem;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionComparator;
import de.qfm.erp.service.model.internal.quotation.EQuotationPositionSortOption;
import de.qfm.erp.service.model.internal.quotation.QStagePositionUpdateBucket;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class StagePositionHelper {
    private static final Logger log = LogManager.getLogger(StagePositionHelper.class);

    public static boolean changeInQuantityEquality(@NonNull QuotationPosition position, @NonNull QStagePositionUpdateBucket updateBucket) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        StagePositionUpdateItem updateItem = updateBucket.getUpdateItem();
        boolean result = true;
        result &= StagePositionHelper.equals((String)position.getGroupingElementLevel1(), (String)updateItem.getGroupingElementLevel1());
        result &= StagePositionHelper.equals((String)position.getGroupingElementLevel2(), (String)updateItem.getGroupingElementLevel2());
        result &= StagePositionHelper.equals((String)position.getGroupingElementLevel3(), (String)updateItem.getGroupingElementLevel3());
        result &= StagePositionHelper.equals((String)position.getGroupingElementLevel4(), (String)updateItem.getGroupingElementLevel4());
        result &= StagePositionHelper.equals((String)position.getPositionNumber(), (String)updateItem.getPositionNumber());
        result &= Objects.equals(position.getSubPositionNumber(), updateItem.getSubPositionNumber());
        result &= Objects.equals(position.getAlternativePositionType(), updateBucket.getAlternativePositionType());
        result &= StagePositionHelper.equals((BigDecimal)position.getCompanyWagePerItem(), (BigDecimal)updateItem.getCompanyWagePerUnit());
        result &= StagePositionHelper.equals((BigDecimal)position.getExternalServicePercentage(), (BigDecimal)updateItem.getExternalServicePercentage());
        result &= StagePositionHelper.equals((BigDecimal)position.getExternalServicePurchasePricePerUnit(), (BigDecimal)updateItem.getExternalServicePurchasePricePerUnit());
        result &= StagePositionHelper.equals((BigDecimal)position.getExternalServiceSellingPricePerUnit(), (BigDecimal)updateItem.getExternalServiceSellingPricePerUnit());
        result &= StagePositionHelper.equals((Boolean)position.getFlagFeePosition(), (Boolean)updateItem.getFlagFeePosition());
        result &= StagePositionHelper.equals((String)position.getLongText(), (String)updateItem.getLongText());
        result &= StagePositionHelper.equals((BigDecimal)position.getMaterialPercentage(), (BigDecimal)updateItem.getMaterialPercentage());
        result &= StagePositionHelper.equals((BigDecimal)position.getMaterialSellingPricePerUnit(), (BigDecimal)updateItem.getMaterialSellingPricePerUnit());
        result &= StagePositionHelper.equals((BigDecimal)position.getMaterialWholesalePriceIncludingDiscountPerItem(), (BigDecimal)updateItem.getMaterialPurchasePricePerUnit());
        result &= StagePositionHelper.equals((String)position.getPositionNumberExternal(), (String)updateItem.getPositionNumberExternal());
        result &= StagePositionHelper.equals((BigDecimal)position.getPricePerUnit(), (BigDecimal)updateItem.getPricePerUnit());
        result &= StagePositionHelper.equals((String)position.getShortText(), (String)updateItem.getShortText());
        result &= StagePositionHelper.equals((BigDecimal)position.getSquadWagePerUnit(), (BigDecimal)updateItem.getSquadWagePerUnit());
        result &= StagePositionHelper.equals((String)position.getUnit(), (String)updateItem.getUnit());
        return result &= StagePositionHelper.equals((BigDecimal)position.getWagePercentage(), (BigDecimal)updateItem.getWagePercentage());
    }

    private static boolean equals(@Nullable BigDecimal left, @Nullable BigDecimal right) {
        if (left == null && right == null) {
            return true;
        }
        if (left != null && right == null && left.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        if (left == null && right.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        return left != null && right != null && left.compareTo(right) == 0;
    }

    private static boolean equals(@Nullable String left, @Nullable String right) {
        return StringUtils.equals((CharSequence)StringUtils.trimToEmpty((String)left), (CharSequence)StringUtils.trimToEmpty((String)right));
    }

    private static boolean equals(@Nullable Boolean left, @Nullable Boolean right) {
        return MoreObjects.firstNonNull((Object)left, (Object)false) == MoreObjects.firstNonNull((Object)right, (Object)false);
    }

    @Nonnull
    public static Iterable<QuotationPosition> automaticShuffle(@NonNull Quotation stage, @NonNull EQuotationPositionSortOption sortOption, @NonNull Iterable<QuotationPosition> positions) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (sortOption == null) {
            throw new NullPointerException("sortOption is marked non-null but is null");
        }
        if (positions == null) {
            throw new NullPointerException("positions is marked non-null but is null");
        }
        QuotationPositionComparator comparator = sortOption.getComparator().from(stage);
        List sorted = IterableHelper.stream(positions).filter(item -> EPositionType.REMARK != item.getPositionType()).sorted((Comparator<QuotationPosition>)comparator).collect(Collectors.toList());
        List remarkPos = IterableHelper.stream(positions).filter(item -> EPositionType.REMARK == item.getPositionType()).sorted((l, r) -> {
            Integer left = (Integer)MoreObjects.firstNonNull((Object)l.getSequenceNumberQuotationStandard(), (Object)0);
            Integer right = (Integer)MoreObjects.firstNonNull((Object)r.getSequenceNumberQuotationStandard(), (Object)0);
            return Ints.compare((int)left, (int)right);
        }).collect(Collectors.toList());
        for (QuotationPosition remarkPo : remarkPos) {
            Integer supposedTarget = (Integer)MoreObjects.firstNonNull((Object)remarkPo.getSequenceNumberQuotationStandard(), (Object)1);
            sorted.add(supposedTarget - 1, remarkPo);
        }
        return ImmutableList.copyOf(sorted);
    }
}

