/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.BidderComplementHelper;
import de.qfm.erp.service.model.internal.quotation.BidderComplement;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.internal.quotation.EntityStatistics;
import de.qfm.erp.service.model.internal.quotation.StageAmountPriceWage;
import de.qfm.erp.service.model.internal.quotation.StageTypeAndState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageHelper {
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> MEASUREMENT_ACTIVE__QUOTATION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.QUOTATION, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.DESIGNATED_COMMISSION}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> MEASUREMENT_ACTIVE__COMMISSION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.ACTIVE}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.DESIGNATED_COST_UNIT}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> MEASUREMENT_ALL__QUOTATION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.QUOTATION, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.DESIGNATED_COMMISSION}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> MEASUREMENT_ALL__COMMISSION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK, EQStageState.DESIGNATED_COST_UNIT}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> NAL__QUOTATION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.QUOTATION, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.DESIGNATED_COMMISSION}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> NAL__COMMISSION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.REWORK, EQStageState.DESIGNATED_COST_UNIT}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> REPORT__QUOTATION_TYPES_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.QUOTATION, (Object[])new EQStageState[]{EQStageState.SUBMITTED}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> REPORT__COMMISSION_WITH_ADDENDUM_TYPES_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__ADDENDUM, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COST_UNIT__ADDENDUM, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK, EQStageState.DESIGNATED_COMMISSION}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> REPORT__COMMISSION_WITHOUT_ADDENDUM_TYPES_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK, EQStageState.DESIGNATED_COMMISSION}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> ACCOUNTING_COMMISSION_TYPES_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> STAGE__ALL__COMMISSION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__ADDENDUM, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COST_UNIT__ADDENDUM, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK, EQStageState.DESIGNATED_COST_UNIT}).putAll((Object)EQStageType.QUOTATION, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.DESIGNATED_COMMISSION, EQStageState.COMMISSIONED, EQStageState.SUBMITTED, EQStageState.APPROVED, EQStageState.ARCHIVED}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> STAGE__IMPORT__CALCULATION_OR_QUOTATION__ADDENDUM__COMMISSION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__ADDENDUM, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COST_UNIT__ADDENDUM, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK, EQStageState.DESIGNATED_COST_UNIT}).putAll((Object)EQStageType.QUOTATION, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.DESIGNATED_COMMISSION, EQStageState.COMMISSIONED, EQStageState.SUBMITTED, EQStageState.APPROVED, EQStageState.ARCHIVED}).putAll((Object)EQStageType.CALCULATION, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.ACTIVE, EQStageState.ARCHIVED}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> STAGE__IMPORT__COST_UNIT__COMMISSION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).build();
    @Nonnull
    public static final ImmutableMultimap<EQStageType, EQStageState> STAGE__IMPORT__COST_ESTIMATE__COMMISSION_TYPE_AND_STATES = ImmutableMultimap.builder().putAll((Object)EQStageType.COMMISSION, (Object[])new EQStageState[]{EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__ADDENDUM, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COST_UNIT__ADDENDUM, (Object[])new EQStageState[]{EQStageState.SUBMITTED, EQStageState.ACTIVE, EQStageState.ARCHIVED, EQStageState.REWORK}).putAll((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.ACTIVE, EQStageState.CLOSED, EQStageState.ARCHIVED, EQStageState.REWORK, EQStageState.DESIGNATED_COST_UNIT}).build();
    private static final CharMatcher FILE_NAME_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"-_[].")).precomputed();
    public static final Joiner STAGE_TEXT_JOINER = Joiner.on((char)' ').skipNulls();
    public static final Joiner DATE_RANGE_JOINER = Joiner.on((String)"-").skipNulls();

    @NonNull
    public static String printBidderComplementLongText(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String longText = StringUtils.trimToEmpty((String)position.getLongText());
        String bidderComplement = StringUtils.trimToEmpty((String)position.getBidderComplement());
        Iterable bidderComplements = BidderComplementHelper.bidderComplements((String)bidderComplement);
        String[] ids = (String[])Streams.stream((Iterable)bidderComplements).map(item -> BidderComplementHelper.bidderComplementPlaceHolder((String)item.getId())).toArray(String[]::new);
        String[] complements = (String[])Streams.stream((Iterable)bidderComplements).map(BidderComplement::getComplement).toArray(String[]::new);
        return StringUtils.trimToEmpty((String)StringUtils.replaceEach((String)longText, (String[])ids, (String[])complements));
    }

    @NonNull
    public static String bidderComplementTextOnly(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String bidderComplement = StringUtils.trimToEmpty((String)position.getBidderComplement());
        return Streams.stream((Iterable)BidderComplementHelper.bidderComplements((String)bidderComplement)).map(BidderComplement::getComplement).collect(Collectors.joining("; "));
    }

    @Nonnull
    public static String costUnit(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EStageOrigin origin = stage.getOrigin();
        String stageNumber = stage.getQNumber();
        EQStageType stageType = stage.getStageType();
        if (origin == EStageOrigin.QUANTE_V1) {
            return stage.getQuotationNumber();
        }
        if (EQStageType.QUOTATION == stageType) {
            return StringUtils.left((String)stageNumber, (int)7) + "0000";
        }
        return stageNumber;
    }

    @Nonnull
    public static Quotation ensureQuotationNumber(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EStageOrigin origin = stage.getOrigin();
        String existingQuotationNumber = stage.getQuotationNumber();
        String qNumber = stage.getQNumber();
        if (origin == EStageOrigin.QUANTE_V2 && StringUtils.isBlank((CharSequence)existingQuotationNumber) && StringUtils.isBlank((CharSequence)qNumber)) {
            String supposedQuotationNumber = (String)MoreObjects.firstNonNull((Object)qNumber, (Object)StringUtils.right((String)Long.toString(System.currentTimeMillis()), (int)12));
            stage.setQuotationNumber(supposedQuotationNumber);
        } else if (origin == EStageOrigin.QUANTE_V2 && StringUtils.isNotBlank((CharSequence)existingQuotationNumber) && StringUtils.isNotBlank((CharSequence)qNumber) && !StringUtils.equalsIgnoreCase((CharSequence)existingQuotationNumber, (CharSequence)qNumber)) {
            stage.setQuotationNumber(qNumber);
        }
        return stage;
    }

    @Nonnull
    public static ImmutableMultimap<EQStageType, EQStageState> accountableStates(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return StageHelper.accountableStates((Quotation)stage, (ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE);
    }

    @Nonnull
    public static ImmutableMultimap<EQStageType, EQStageState> accountableStates(@NonNull Quotation stage, @NonNull ECostUnitCEViewMode costUnitCEViewMode) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (costUnitCEViewMode == null) {
            throw new NullPointerException("costUnitCEViewMode is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        ImmutableMultimap.Builder stageTypesAndStatesBuilder = ImmutableMultimap.builder();
        if (stageType == EQStageType.COMMISSION) {
            stageTypesAndStatesBuilder.putAll((Object)EQStageType.COMMISSION, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COMMISSION__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COST_UNIT__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES);
        } else if (stageType == EQStageType.QUOTATION && stage.getFlagMeasurementWithoutCommissionNumberAllowed().booleanValue()) {
            stageTypesAndStatesBuilder.putAll((Object)EQStageType.QUOTATION, (Object[])new EQStageState[]{EQStageState.TEMPORARY, EQStageState.APPROVED, EQStageState.SUBMITTED, EQStageState.DESIGNATED_COMMISSION});
        } else if (stageType == EQStageType.COMMISSION__COST_UNIT) {
            stageTypesAndStatesBuilder.putAll((Object)EQStageType.COST_UNIT__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COMMISSION__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES);
        } else if (stageType == EQStageType.COMMISSION__COST_UNIT__CE) {
            if (ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE == costUnitCEViewMode) {
                stageTypesAndStatesBuilder.putAll((Object)EQStageType.COST_UNIT__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COMMISSION__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES);
            } else if (ECostUnitCEViewMode.COMMISSION == costUnitCEViewMode) {
                stageTypesAndStatesBuilder.putAll((Object)EQStageType.COMMISSION, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COMMISSION__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COST_UNIT__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES);
            }
        } else {
            stageTypesAndStatesBuilder.putAll((Object)EQStageType.COMMISSION__COST_UNIT, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COST_UNIT__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES).putAll((Object)EQStageType.COMMISSION__ADDENDUM, EQStageState.ACCOUNTABLE_STAGE_STATES);
        }
        return stageTypesAndStatesBuilder.build();
    }

    @Nonnull
    public static Iterable<StageTypeAndState> accountableStates(@NonNull Quotation stage, boolean considerCommissionFlag) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        ImmutableSet.Builder stageTypeAndStateBuilder = ImmutableSet.builder();
        EQStageType stageType = stage.getStageType();
        if (stageType == EQStageType.COMMISSION) {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COMMISSION, (Object)EQStageType.COMMISSION__ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM), (Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (boolean)false));
            if (considerCommissionFlag) {
                stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COMMISSION__ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM), (Iterable)EQStageState.FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES, (boolean)true));
            }
        } else if (stageType == EQStageType.QUOTATION && stage.getFlagMeasurementWithoutCommissionNumberAllowed().booleanValue()) {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.QUOTATION), (Iterable)EQStageState.FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES, (boolean)true));
        } else if (stageType == EQStageType.COMMISSION__COST_UNIT) {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COST_UNIT__ADDENDUM, (Object)EQStageType.COMMISSION__ADDENDUM), (Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (boolean)false));
            if (considerCommissionFlag) {
                stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COMMISSION__ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM), (Iterable)EQStageState.FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES, (boolean)true));
            }
        } else if (stageType == EQStageType.COMMISSION__COST_UNIT__CE) {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COST_UNIT__ADDENDUM, (Object)EQStageType.COMMISSION__ADDENDUM), (Iterable)Iterables.concat((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (Iterable)EQStageState.ADDITIONAL_MEASUREMENT_STAGE_STATES), (boolean)false));
            if (considerCommissionFlag) {
                stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COMMISSION__ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM), (Iterable)EQStageState.FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES, (boolean)true));
            }
        } else {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COMMISSION__COST_UNIT, (Object)EQStageType.COST_UNIT__ADDENDUM, (Object)EQStageType.COMMISSION__ADDENDUM), (Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (boolean)false));
            if (considerCommissionFlag) {
                stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COST_UNIT__ADDENDUM, (Object)EQStageType.COMMISSION__ADDENDUM), (Iterable)EQStageState.FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES, (boolean)true));
            }
        }
        return stageTypeAndStateBuilder.build();
    }

    @Nonnull
    public static Iterable<StageTypeAndState> archiveValidationStates(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        ImmutableSet.Builder stageTypeAndStateBuilder = ImmutableSet.builder();
        if (stageType == EQStageType.COMMISSION) {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COMMISSION, (Object)EQStageType.COMMISSION__ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM), (Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (boolean)false));
        } else if (stageType == EQStageType.QUOTATION && stage.getFlagMeasurementWithoutCommissionNumberAllowed().booleanValue()) {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.QUOTATION), (Iterable)EQStageState.FLAG_MEASUREMENT_WO_COMMISSION_STAGE_STATES, (boolean)true));
        } else {
            stageTypeAndStateBuilder.add((Object)StageTypeAndState.of((Iterable)ImmutableSet.of((Object)EQStageType.COMMISSION__COST_UNIT), (Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (boolean)false));
        }
        return stageTypeAndStateBuilder.build();
    }

    @Nonnull
    public static Iterable<StageTypeAndState> allStates(boolean includeArchived) {
        Collection relevantStates = includeArchived ? EQStageState.ALL_VALID : EQStageState.ALL_STATES_WITHOUT_ARCHIVED;
        return ImmutableSet.of((Object)StageTypeAndState.of((Iterable)EQStageType.ALL, (Iterable)relevantStates, (boolean)false));
    }

    @Nonnull
    public static Path entityRootPath(@NonNull Path homeFolderPath, @NonNull String entityNumber) {
        if (homeFolderPath == null) {
            throw new NullPointerException("homeFolderPath is marked non-null but is null");
        }
        if (entityNumber == null) {
            throw new NullPointerException("entityNumber is marked non-null but is null");
        }
        String entityChildPath = FILE_NAME_MATCHER.negate().replaceFrom((CharSequence)entityNumber, (CharSequence)"_");
        return Path.of(homeFolderPath.toString(), entityChildPath);
    }

    @Nonnull
    public static Path mainCostUnitPath(@NonNull Path homeFolderPath, @NonNull String entityNumber) {
        if (homeFolderPath == null) {
            throw new NullPointerException("homeFolderPath is marked non-null but is null");
        }
        if (entityNumber == null) {
            throw new NullPointerException("entityNumber is marked non-null but is null");
        }
        String entityPathPath = FILE_NAME_MATCHER.negate().replaceFrom((CharSequence)entityNumber, (CharSequence)"_");
        String mainCostUnitRootPath = FILE_NAME_MATCHER.negate().replaceFrom((CharSequence)(entityNumber + "0000"), (CharSequence)"_");
        return Path.of(homeFolderPath.toString(), entityPathPath, mainCostUnitRootPath);
    }

    @Nonnull
    public static Path costUnitPath(@NonNull Path homeFolderPath, @NonNull String entityNumber, @NonNull String stageNumber) {
        if (homeFolderPath == null) {
            throw new NullPointerException("homeFolderPath is marked non-null but is null");
        }
        if (entityNumber == null) {
            throw new NullPointerException("entityNumber is marked non-null but is null");
        }
        if (stageNumber == null) {
            throw new NullPointerException("stageNumber is marked non-null but is null");
        }
        String entityPathPath = FILE_NAME_MATCHER.negate().replaceFrom((CharSequence)entityNumber, (CharSequence)"_");
        String costUnitRootPath = FILE_NAME_MATCHER.negate().replaceFrom((CharSequence)stageNumber, (CharSequence)"_");
        return Path.of(homeFolderPath.toString(), entityPathPath, costUnitRootPath);
    }

    @Nonnull
    public static Path inquiryPath(@NonNull Path homeFolderPath, @NonNull QEntity entity) {
        if (homeFolderPath == null) {
            throw new NullPointerException("homeFolderPath is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        Long id = entity.getId();
        String alias = entity.getAlias();
        return StageHelper.entityRootPath((Path)homeFolderPath, (String)(alias + "_[" + id + "]"));
    }

    @Nonnull
    public static Path allPath(@NonNull Path homeFolderPath, @NonNull QEntity entity) {
        if (homeFolderPath == null) {
            throw new NullPointerException("homeFolderPath is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return StageHelper.entityRootPath((Path)homeFolderPath, (String)entity.getQNumber());
    }

    @Nonnull
    public static String stageText(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return StageHelper.stageText((Quotation)stage, (boolean)false);
    }

    @Nonnull
    public static String stageText(@NonNull Quotation stage, boolean includeAddendum) {
        String dateRangeString;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        String alias = stage.getAlias();
        String qNumber = stage.getQNumber();
        Long addendumNumber = stage.getAddendumNumber();
        Integer version = stage.getVersion();
        LocalDate startDate = stage.getProjectExecutionStartDate();
        LocalDate endDate = stage.getProjectExecutionEndDate();
        ArrayList dateRangeParts = Lists.newArrayList();
        if (null != startDate) {
            dateRangeParts.add(DateTimeHelperService.germanDate((LocalDate)startDate));
        }
        if (null != endDate) {
            dateRangeParts.add(DateTimeHelperService.germanDate((LocalDate)endDate));
        }
        Object dateRangeStringText = StringUtils.isNotBlank((CharSequence)(dateRangeString = DATE_RANGE_JOINER.join((Iterable)dateRangeParts))) ? "[" + dateRangeString + "]" : "";
        return StageHelper.stageText((boolean)includeAddendum, (String)alias, (String)qNumber, (Long)addendumNumber, (Integer)version, (String)dateRangeStringText);
    }

    @Nonnull
    public static String stageText(@NonNull EntityStatistics statistics) {
        if (statistics == null) {
            throw new NullPointerException("statistics is marked non-null but is null");
        }
        String alias = statistics.getStageAlias();
        String qNumber = statistics.getStageQNumber();
        Integer version = statistics.getVersion();
        return StageHelper.stageText((boolean)false, (String)alias, (String)qNumber, (Long)0L, (Integer)version, (String)"");
    }

    @Nonnull
    public static String stageText(@NonNull StageAmountPriceWage stageAmountPriceWage) {
        if (stageAmountPriceWage == null) {
            throw new NullPointerException("stageAmountPriceWage is marked non-null but is null");
        }
        String stageAlias = stageAmountPriceWage.getStageAlias();
        String stageNumber = stageAmountPriceWage.getStageNumber();
        Integer version = stageAmountPriceWage.getStageVersion();
        return StageHelper.stageText((boolean)false, (String)stageAlias, (String)stageNumber, (Long)0L, (Integer)version, (String)"");
    }

    @Nonnull
    private static String stageText(boolean includeAddendum, @NonNull String alias, @NonNull String qNumber, @Nullable Long addendumNumber, @Nullable Integer version, @NonNull String dateRangeStringText) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (qNumber == null) {
            throw new NullPointerException("qNumber is marked non-null but is null");
        }
        if (dateRangeStringText == null) {
            throw new NullPointerException("dateRangeStringText is marked non-null but is null");
        }
        LinkedHashSet textParts = Sets.newLinkedHashSet();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            textParts.add(alias);
        }
        if (StringUtils.isNotBlank((CharSequence)qNumber)) {
            textParts.add(qNumber);
        }
        if (includeAddendum && null != addendumNumber && 0L != addendumNumber) {
            textParts.add(String.format("/%s", addendumNumber));
        }
        if (null != version) {
            textParts.add(String.format("V%s", version));
        }
        if (StringUtils.isNotBlank((CharSequence)dateRangeStringText)) {
            textParts.add(dateRangeStringText);
        }
        return STAGE_TEXT_JOINER.join((Iterable)textParts);
    }

    @Nonnull
    public static String quotationOrStageNumber(Quotation stage) {
        EStageOrigin origin = stage.getOrigin();
        if (origin == EStageOrigin.QUANTE_V1) {
            return stage.getQuotationNumber();
        }
        return stage.getQNumber();
    }

    @Nonnull
    public static Optional<QuotationPosition> determineJumboPosition(@NonNull QuotationPosition stagePosition) {
        if (stagePosition == null) {
            throw new NullPointerException("stagePosition is marked non-null but is null");
        }
        EPositionType positionType = stagePosition.getPositionType();
        if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType || EPositionType.JUMBO_INTERNAL_TYPE_B == positionType) {
            EPositionType parentPositionType;
            QuotationPosition parent = stagePosition.getParent();
            if (null != parent && EPositionType.JUMBO == (parentPositionType = parent.getPositionType())) {
                return Optional.of(parent);
            }
            QuotationPosition referencePosition = stagePosition.getReferencePosition();
            if (null != referencePosition) {
                return StageHelper.determineJumboPosition((QuotationPosition)referencePosition);
            }
        } else if (EPositionType.JUMBO == positionType) {
            return Optional.of(stagePosition);
        }
        return Optional.empty();
    }
}

