/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import de.qfm.erp.service.model.jpa.filestore.FileStore;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class FileStoreHelper {
    @Nonnull
    public static Optional<byte[]> fetchBytes(@NonNull FileStore fileStore) {
        if (fileStore == null) {
            throw new NullPointerException("fileStore is marked non-null but is null");
        }
        Blob blob = fileStore.getData();
        if (null != blob) {
            try {
                byte[] data;
                int length = (int)blob.length();
                if (length > 0 && null != (data = blob.getBytes(1L, length))) {
                    return Optional.of(data);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }
}

