/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateRange
implements Iterable<LocalDate> {
    @NonNull
    private final Range<LocalDate> dateRange;

    @Override
    public Iterator<LocalDate> iterator() {
        return this.stream().iterator();
    }

    @Nonnull
    public Stream<LocalDate> stream() {
        LocalDate lowerBound = (LocalDate)this.dateRange.lowerEndpoint();
        LocalDate upperBound = (LocalDate)this.dateRange.upperEndpoint();
        return Stream.iterate(lowerBound, d -> d.plusDays(1L)).limit(ChronoUnit.DAYS.between(lowerBound, upperBound) + 1L);
    }

    @Nonnull
    public Iterable<LocalDate> asList() {
        return (Iterable)this.stream().collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static DateRange from(@NonNull YearMonth yearMonth) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        LocalDate startDate = yearMonth.atDay(1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        Range dateRange = Range.closed((Comparable)startDate, (Comparable)endDate);
        return DateRange.of((Range)dateRange);
    }

    private DateRange(@NonNull Range<LocalDate> dateRange) {
        if (dateRange == null) {
            throw new NullPointerException("dateRange is marked non-null but is null");
        }
        this.dateRange = dateRange;
    }

    public static DateRange of(@NonNull Range<LocalDate> dateRange) {
        if (dateRange == null) {
            throw new NullPointerException("dateRange is marked non-null but is null");
        }
        return new DateRange(dateRange);
    }
}

