/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class BigDecimalHelper {
    private static final Logger log = LogManager.getLogger(BigDecimalHelper.class);
    private static final DecimalFormat NUMBER_FORMAT;

    @Nonnull
    public static String asString(@NonNull BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new NullPointerException("bigDecimal is marked non-null but is null");
        }
        int scale = bigDecimal.scale();
        int safeScale = scale >= 2 && scale <= 3 ? scale : 2;
        return BigDecimalHelper.asString((BigDecimal)bigDecimal, (int)safeScale);
    }

    @Nonnull
    public static String asString(@NonNull BigDecimal bigDecimal, int factionDigits) {
        if (bigDecimal == null) {
            throw new NullPointerException("bigDecimal is marked non-null but is null");
        }
        BigDecimal valueWithScale = bigDecimal.setScale(factionDigits, RoundingMode.HALF_UP);
        NUMBER_FORMAT.setMinimumFractionDigits(factionDigits);
        NUMBER_FORMAT.setMaximumFractionDigits(factionDigits);
        return NUMBER_FORMAT.format(valueWithScale);
    }

    @Nonnull
    public static String asString(@Nullable BigDecimal value, @NonNull String fallback, boolean printZero) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        if (null != value && (0 != value.compareTo(BigDecimal.ZERO) || printZero)) {
            return BigDecimalHelper.asString((BigDecimal)value);
        }
        return fallback;
    }

    public static boolean anyZero(BigDecimal ... values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        for (BigDecimal value : values) {
            if (!value.equals(BigDecimal.ZERO) && 0 != value.compareTo(BigDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    public static boolean allZero(@NonNull Iterable<BigDecimal> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        for (BigDecimal value : values) {
            if (value.equals(BigDecimal.ZERO) || 0 == value.compareTo(BigDecimal.ZERO)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static BigDecimal nullSafeScale(@Nullable BigDecimal value, int scale) {
        return null != value ? value.setScale(scale, RoundingMode.HALF_UP) : null;
    }

    @Nonnull
    @VisibleForTesting
    public static BigDecimal parseGermanCurrency(@NonNull String valueAsString) {
        if (valueAsString == null) {
            throw new NullPointerException("valueAsString is marked non-null but is null");
        }
        try {
            Number number = NUMBER_FORMAT.parse(valueAsString);
            if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
                return BigDecimal.valueOf(number.longValue());
            }
            return BigDecimal.valueOf(number.doubleValue());
        }
        catch (ParseException parseException) {
            return BigDecimal.ZERO;
        }
    }

    static {
        DecimalFormat numberFormat3 = new DecimalFormat("#,##0.000");
        numberFormat3.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.GERMAN));
        NUMBER_FORMAT = numberFormat3;
    }
}

