/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.filter;

import de.qfm.erp.service.model.exception.request.JwtTokenException;
import de.qfm.erp.service.service.security.JwtTokenProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtTokenFilter
extends OncePerRequestFilter {
    @NonNull
    private final RequestMatcher requestMatcher;
    @NonNull
    private final JwtTokenProvider jwtTokenProvider;

    protected void doFilterInternal(@Nullable HttpServletRequest httpServletRequest, @Nullable HttpServletResponse httpServletResponse, @Nullable FilterChain filterChain) throws ServletException, IOException {
        if (this.requestMatcher.matches(httpServletRequest)) {
            String token = this.jwtTokenProvider.resolveToken(httpServletRequest);
            try {
                if (token != null && this.jwtTokenProvider.validateToken(token)) {
                    Authentication auth = this.jwtTokenProvider.getAuthentication(token);
                    SecurityContextHolder.getContext().setAuthentication(auth);
                } else {
                    SecurityContextHolder.clearContext();
                }
            }
            catch (JwtTokenException ex) {
                SecurityContextHolder.clearContext();
                httpServletResponse.sendError(HttpStatus.UNAUTHORIZED.value(), ex.getMessage());
                return;
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private JwtTokenFilter(@NonNull RequestMatcher requestMatcher, @NonNull JwtTokenProvider jwtTokenProvider) {
        if (requestMatcher == null) {
            throw new NullPointerException("requestMatcher is marked non-null but is null");
        }
        if (jwtTokenProvider == null) {
            throw new NullPointerException("jwtTokenProvider is marked non-null but is null");
        }
        this.requestMatcher = requestMatcher;
        this.jwtTokenProvider = jwtTokenProvider;
    }

    public static JwtTokenFilter of(@NonNull RequestMatcher requestMatcher, @NonNull JwtTokenProvider jwtTokenProvider) {
        if (requestMatcher == null) {
            throw new NullPointerException("requestMatcher is marked non-null but is null");
        }
        if (jwtTokenProvider == null) {
            throw new NullPointerException("jwtTokenProvider is marked non-null but is null");
        }
        return new JwtTokenFilter(requestMatcher, jwtTokenProvider);
    }
}

